/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.geom.Vent;
import pyrosim.gui.geom.AARectangleEditor;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.Point3DPanel;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.PropertyUtil;

public class VentGeomEditor
extends guiPanel
implements IGeomEditor<Vent.VentGeom> {
    private static final long serialVersionUID = 2939186383674263719L;
    public static final String FACE_NAME = Intl.intl("Face");
    private static final int NORMALIX = 0;
    private static final int NEGIX = 1;
    private static final int POSIX = 2;
    private final Integer[] d_aiXNormals = new Integer[]{0, -1, 1};
    private final Integer[] d_aiYNormals = new Integer[]{0, -2, 2};
    private final Integer[] d_aiZNormals = new Integer[]{0, -3, 3};
    private final guiComboBox<Integer> d_cbNormal;
    private final AARectangleEditor d_rectEditor;
    private final ValueField<UnitDouble> d_radiusEditor;
    private final guiCheckBox d_enableCircular;
    private final ValueField<UnitDouble> d_areaField;
    private guiComboBox<CenterPointType> d_cpType;
    private Point3DPanel d_cpPoint;
    private final UpdateCpStatusListener d_updateCpStatus;
    private final PropertyUtil.IProp normalProp = new PropertyUtil.AProp<IPyroGeomSrc, Vector3d>(IPyroGeomSrc.class){

        @Override
        public Object get(IPyroGeomSrc obj) {
            Vent.VentGeom vg = (Vent.VentGeom)obj.getGeom().getLocalGeom();
            return vg.normal == null ? GeomConstants.VEC3D_ZERO : vg.normal;
        }

        @Override
        public void set(IPyroGeomSrc obj, Vector3d prop) {
            Vent.VentGeom vg = (Vent.VentGeom)obj.getGeom().getLocalGeom();
            obj.setGeom(GeomNodeUtil.newNode(new Vent.VentGeom(vg, prop, vg.centerPoint, vg.louver, vg.radius)));
        }
    };
    private final PropertyUtil.IProp originProp = new PropertyUtil.AProp<IPyroGeomSrc, UnitPoint3D>(IPyroGeomSrc.class){

        @Override
        public Object get(IPyroGeomSrc obj) {
            Vent v = (Vent)obj;
            return v.getCenterPoint();
        }

        @Override
        public void set(IPyroGeomSrc obj, UnitPoint3D prop) {
            Vent v = (Vent)obj;
            v.setCenterPoint(prop);
        }
    };
    private final PropertyUtil.IProp defOriginProp = new PropertyUtil.AProp<IPyroGeomSrc, UnitPoint3D>(IPyroGeomSrc.class){

        @Override
        public Object get(IPyroGeomSrc obj) {
            Vent v = (Vent)obj;
            return v.getDefaultCenterPoint();
        }

        @Override
        public void set(IPyroGeomSrc obj, UnitPoint3D prop) {
        }
    };
    private final PropertyUtil.IProp radiusProp = new PropertyUtil.AProp<IPyroGeomSrc, UnitDouble>(IPyroGeomSrc.class){

        @Override
        public void set(IPyroGeomSrc obj, UnitDouble prop) {
            Vent.VentGeom vg = (Vent.VentGeom)obj.getGeom().getLocalGeom();
            Vent.VentGeom newvg = new Vent.VentGeom(vg, vg.normal, vg.centerPoint, vg.louver, VentGeomEditor.this.d_enableCircular.isSelected() ? (UnitDouble)VentGeomEditor.this.d_radiusEditor.getValue() : null);
            obj.setGeom(GeomNodeUtil.newNode(newvg));
        }

        @Override
        public Object get(IPyroGeomSrc obj) {
            Vent.VentGeom vg = (Vent.VentGeom)obj.getGeom().getLocalGeom();
            return vg.radius;
        }
    };

    public VentGeomEditor() {
        super(new GridBagLayout());
        this.d_cbNormal = new guiComboBox<Integer>((T[])this.d_aiXNormals);
        this.d_cbNormal.setRenderer(new NormalListCellRenderer());
        this.d_rectEditor = new AARectangleEditor(true);
        this.d_rectEditor.getPlaneCB().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                int orientation = VentGeomEditor.this.d_cbNormal.getSelectedIndex();
                int plane = VentGeomEditor.this.d_rectEditor.getPlaneCB().getSelectedIndex();
                if (plane == 0) {
                    VentGeomEditor.this.d_cbNormal.setItems(VentGeomEditor.this.d_aiXNormals);
                } else if (plane == 1) {
                    VentGeomEditor.this.d_cbNormal.setItems(VentGeomEditor.this.d_aiYNormals);
                } else {
                    VentGeomEditor.this.d_cbNormal.setItems(VentGeomEditor.this.d_aiZNormals);
                }
                VentGeomEditor.this.d_cbNormal.setSelectedIndex(orientation);
            }
        });
        this.d_cpPoint = new Point3DPanel("", true);
        guiLabel cpLabel = new guiLabel(Intl.intl("Center Point:"));
        cpLabel.setToolTipText(Intl.intl("XYZ"));
        this.d_cpType = new guiComboBox<Object>((T[])new Object[]{CenterPointType.AUTO, CenterPointType.CUSTOM});
        this.d_cpType.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 3917711678910135993L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value == CenterPointType.AUTO) {
                    this.setText(Intl.intl("Auto"));
                }
                if (value == CenterPointType.CUSTOM) {
                    this.setText(Intl.intl("Custom"));
                }
                return this;
            }
        });
        this.d_updateCpStatus = new UpdateCpStatusListener();
        this.d_radiusEditor = ValueFields.udFld(DoubleVR.above(0.0, true), SIUS.unit(0), UnitSystem.getSource(0));
        this.d_enableCircular = new guiCheckBox(Intl.intl("Circular Vent"));
        guiLabel normalLbl = new guiLabel(Intl.intl("Normal Direction:"));
        guiLabel radiusLbl = new guiLabel(Intl.intl("Radius:"));
        LinkStatus.link((AbstractButton)this.d_enableCircular, radiusLbl, this.d_radiusEditor);
        guiLabel areaLbl = new guiLabel(Intl.intl("Area:"));
        this.d_areaField = ValueFields.udFld(UnitSystem.getSource(79));
        this.d_areaField.setEditable(false);
        this.d_areaField.setNullAllowed(true);
        this.d_rectEditor.getPlaneCB().addItemListener(evt -> this.updateAreaLabel());
        this.d_rectEditor.getBoxGeomEditor().addPropertyChangeListeners(evt -> this.updateAreaLabel());
        Optional<Component> szComp = Arrays.stream(this.d_rectEditor.getBoxGeomEditor().getComponents()).filter(c -> c instanceof ValueField).findAny();
        if (szComp.isPresent()) {
            this.d_areaField.setPreferredSize(new Dimension(szComp.get().getPreferredSize()));
        }
        guiPanel areaContainer = new guiPanel(new GridBagLayout());
        GridBagUtil.add(areaContainer, Box.createHorizontalGlue(), 0, 0, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(areaContainer, areaLbl, 1, 0, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(areaContainer, this.d_areaField, 2, 0, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, normalLbl, 0, 0, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_cbNormal, 1, 0, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_rectEditor, 0, 1, 2, 1, 0, 0, 6, 0, 0, 1.0, 0.0, 17);
        GridBagUtil.add(this, areaContainer, 0, 2, 2, 1, 0, 0, 6, 0, 0, 1.0, 0.0, 13);
        GridBagUtil.add(this, cpLabel, 0, 5, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_cpType, 1, 5, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_cpPoint, 0, 6, 2, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_enableCircular, 0, 7, 2, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, radiusLbl, 0, 8, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_radiusEditor, 1, 8, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.addGlue(this);
    }

    @Override
    public String[] getFaceNames() {
        return new String[]{FACE_NAME};
    }

    @Override
    public int getNumFaces() {
        return 1;
    }

    @Override
    public int[] getFaceOrder(IGeomNode geom) {
        return null;
    }

    @Override
    public String getGeomName() {
        return Intl.intl("Vent Geometry");
    }

    @Override
    public guiPanel getPanel() {
        return this;
    }

    private void updateAreaLabel() {
        UnitDouble area = this.d_rectEditor.getArea();
        this.d_areaField.setValue(area);
    }

    @Override
    public boolean validateData(Collection<? extends IPyroGeomSrc> geoms, boolean showWarn, boolean allowModify) {
        return this.d_rectEditor.validateData(geoms, showWarn, allowModify);
    }

    @Override
    public void load(Collection<? extends IPyroGeomSrc> geoms) {
        this.d_rectEditor.load(geoms);
        Object normal = PropertyUtil.getProperty(this.normalProp, geoms);
        if (!(normal instanceof Vector3d)) {
            normal = null;
        }
        if (normal == null) {
            this.d_cbNormal.setSelectedItem(null);
        } else if (normal.equals(GeomConstants.VEC3D_ZERO)) {
            this.d_cbNormal.setSelectedIndex(0);
        } else {
            Vector3d normalVal = (Vector3d)normal;
            this.d_cbNormal.setSelectedIndex(this.getNormalIx(normalVal));
        }
        Object origin = PropertyUtil.getProperty(this.originProp, geoms);
        if (geoms.size() == 1) {
            if (origin == null) {
                this.d_cpType.setSelectedItem((Object)CenterPointType.AUTO);
                this.d_cpPoint.load(null);
            } else if (origin instanceof UnitPoint3D) {
                this.d_cpType.setSelectedItem((Object)CenterPointType.CUSTOM);
                this.d_cpPoint.load((UnitPoint3D)origin);
            } else assert (false);
        } else if (origin == null) {
            this.d_cpType.setSelectedItem((Object)CenterPointType.AUTO);
            this.d_cpPoint.load(null);
        } else if (origin instanceof UnitPoint3D) {
            this.d_cpType.setSelectedItem((Object)CenterPointType.CUSTOM);
            this.d_cpPoint.load((UnitPoint3D)origin);
        } else {
            this.d_cpType.setSelectedItem(null);
            this.d_cpPoint.load(null);
        }
        this.updateCpStatus();
        this.d_cpType.removeItemListener(this.d_updateCpStatus);
        this.d_cpType.addItemListener(this.d_updateCpStatus);
        this.d_rectEditor.getComm().addObserver(this.d_updateCpStatus);
        Object radius = PropertyUtil.getProperty(this.radiusProp, geoms);
        if (!(radius instanceof UnitDouble)) {
            radius = null;
        }
        if (radius == null) {
            this.d_enableCircular.setSelected(false);
            this.d_radiusEditor.setValue(new UnitDouble(0.0, PyroSim.getApp().getUnitSystem().getLengthUnit()));
        } else {
            this.d_enableCircular.setSelected(true);
            this.d_radiusEditor.setValue((UnitDouble)radius);
        }
    }

    private void updateCpStatus() {
        UnitAABox ventBounds;
        this.d_cpPoint.setEditable(this.d_cpType.getSelectedItem() == CenterPointType.CUSTOM);
        if (this.d_cpType.getSelectedItem() == CenterPointType.AUTO && this.d_rectEditor.validateData(false, false) && (ventBounds = this.d_rectEditor.getBoundingBox()) != null) {
            this.d_cpPoint.load(ventBounds.getCenter());
        }
    }

    private int getNormalIx(Vector3d vec) {
        switch (this.d_rectEditor.getPlaneCB().getSelectedIndex()) {
            case -1: {
                return -1;
            }
            case 0: {
                return vec.x > 0.0 ? 2 : 1;
            }
            case 1: {
                return vec.y > 0.0 ? 2 : 1;
            }
            case 2: {
                return vec.z > 0.0 ? 2 : 1;
            }
        }
        return -1;
    }

    private Vector3d getNormal(int normalIx) {
        if (normalIx == 0) {
            return GeomConstants.VEC3D_ZERO;
        }
        switch (this.d_rectEditor.getPlaneCB().getSelectedIndex()) {
            case -1: {
                return null;
            }
            case 0: {
                return normalIx == 2 ? GeomConstants.VEC3D_XPOS : GeomConstants.VEC3D_XNEG;
            }
            case 1: {
                return normalIx == 2 ? GeomConstants.VEC3D_YPOS : GeomConstants.VEC3D_YNEG;
            }
            case 2: {
                return normalIx == 2 ? GeomConstants.VEC3D_ZPOS : GeomConstants.VEC3D_ZNEG;
            }
        }
        return null;
    }

    @Override
    public void save(Collection<? extends IPyroGeomSrc> geoms) {
        Vector3d normal;
        this.d_rectEditor.save(geoms);
        int normalIx = this.d_cbNormal.getSelectedIndex();
        if (normalIx >= 0 && (normal = this.getNormal(normalIx)) != null) {
            if (normal.equals(GeomConstants.VEC3D_ZERO)) {
                normal = null;
            }
            PropertyUtil.setProperty(this.normalProp, normal, geoms);
        }
        if (this.d_cpType.getSelectedItem() != null) {
            UnitPoint3D cp;
            if (this.d_cpType.getSelectedItem() == CenterPointType.AUTO) {
                PropertyUtil.setProperty(this.originProp, null, geoms);
            } else if (this.d_cpType.getSelectedItem() == CenterPointType.CUSTOM && (cp = this.d_cpPoint.save()) != null) {
                PropertyUtil.setProperty(this.originProp, cp, geoms);
            }
        }
        UnitDouble radius = (UnitDouble)this.d_radiusEditor.getValue();
        PropertyUtil.setProperty(this.radiusProp, radius, geoms);
    }

    private class NormalListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 7676892310073633448L;

        private NormalListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                label.setText("");
                return label;
            }
            switch ((Integer)value) {
                case 0: {
                    label.setText(Intl.intl("Automatic (Recommended)"));
                    break;
                }
                case -1: {
                    label.setText("-X");
                    break;
                }
                case 1: {
                    label.setText("+X");
                    break;
                }
                case -2: {
                    label.setText("-Y");
                    break;
                }
                case 2: {
                    label.setText("+Y");
                    break;
                }
                case -3: {
                    label.setText("-Z");
                    break;
                }
                case 3: {
                    label.setText("+Z");
                }
            }
            return label;
        }
    }

    private class UpdateCpStatusListener
    implements ItemListener,
    Observer {
        private UpdateCpStatusListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            VentGeomEditor.this.updateCpStatus();
        }

        @Override
        public void update(Observable o, Object arg) {
            VentGeomEditor.this.updateCpStatus();
        }
    }

    private static enum CenterPointType {
        AUTO,
        CUSTOM;

    }
}

