/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.devices.DeviceManager;
import pyrosim.domain.devices.measurers.AMeasuringDevc;
import pyrosim.domain.devices.measurers.GaugeHeatFluxMeasurer;
import pyrosim.domain.devices.measurers.InnerTempMeasurer;
import pyrosim.domain.devices.measurers.PressureCoeffMeasurer;
import pyrosim.domain.devices.measurers.SolidDensityMeasurer;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.devices.AlarmInfoPanel;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.devices.MsrDeviceEditorUtil;
import pyrosim.gui.geom.AttachedPointGeomEditor;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Sets;

public class SolidPointDeviceEditor
extends ADevcEditor<SolidPointMeasurer> {
    private final SolidPointDeviceDataPanel d_dataPanel;

    public SolidPointDeviceEditor(PyroMod pyMod, IDevcEditor.Mode mode) {
        this.d_dataPanel = new SolidPointDeviceDataPanel(pyMod, mode);
    }

    @Override
    public String getDesc() {
        return Intl.intl("Solid-phase Device");
    }

    @Override
    public String getDefName() {
        return Intl.intl("SOLID");
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new AttachedPointGeomEditor();
    }

    @Override
    public AlarmInfoPanel createAlarmPanel() {
        final AlarmInfoPanel alarmPanel = new AlarmInfoPanel((IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem());
        this.d_dataPanel.d_measCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                alarmPanel.setCurrentMsr((IQuantity)SolidPointDeviceEditor.this.d_dataPanel.d_measCombo.getSelectedItem());
            }
        });
        return alarmPanel;
    }

    @Override
    public Collection<String> getCustomTypes() {
        HashSet<String> types = new HashSet<String>();
        SolidPointMeasurer.getCustomFDSTypes((IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem(), types);
        return types;
    }

    @Override
    public Set<String> getFDSPreviewTypes() {
        return Sets.fromArrayHS("PROP", "DEVC");
    }

    @Override
    public SolidPointMeasurer create() {
        return this.d_dataPanel.create();
    }

    @Override
    public void load(SolidPointMeasurer spm) {
        this.d_dataPanel.load(spm);
    }

    @Override
    public void save(SolidPointMeasurer msr) {
        this.d_dataPanel.save(msr);
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    @Override
    public boolean validateData(Component parent, SolidPointMeasurer loadedObj, boolean showWarn, boolean allowModify) {
        return MsrDeviceEditorUtil.validateData(parent, loadedObj, (IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem(), showWarn, allowModify);
    }

    public class SolidPointDeviceDataPanel
    extends guiPanel {
        private static final long serialVersionUID = 1726105864786556448L;
        private final IDevcEditor.Mode d_mode;
        private final DeviceManager d_mgr;
        private final QuantityComboBox d_measCombo;
        private final GuageHeatFluxProps d_heatFluxPanel;
        private final PressureCoeffProps d_pressCoeffPanel;
        private final DepthProps d_surfDepthPanel;
        private guiPanel d_cardPanel;
        private CardLayout d_cardLayout;
        private static final String SURFACE_DEPTH = "SURFACE_DEPTH";

        public SolidPointDeviceDataPanel(PyroMod pyMod, IDevcEditor.Mode mode) {
            this.d_mgr = pyMod.getDevices();
            this.d_mode = mode;
            this.setLayout(new GridBagLayout());
            this.d_measCombo = new QuantityComboBox(SolidPointMeasurer.getOutputType(), SolidPointMeasurer.getQuantityType());
            this.d_measCombo.setMinimumSize(this.d_measCombo.getPreferredSize());
            this.d_cardLayout = new CardLayout();
            this.d_cardPanel = new guiPanel(this.d_cardLayout);
            this.d_heatFluxPanel = new GuageHeatFluxProps();
            this.d_pressCoeffPanel = new PressureCoeffProps();
            this.d_surfDepthPanel = new DepthProps(new UnitDouble(0.0, SI.METER));
            this.d_cardPanel.add((Component)this.d_heatFluxPanel, Quantity.GAUGE_HEAT_FLUX.create().getDescription());
            this.d_cardPanel.add((Component)this.d_pressCoeffPanel, Quantity.PRESSURE_COEFFICIENT.create().getDescription());
            this.d_cardPanel.add((Component)this.d_surfDepthPanel, SURFACE_DEPTH);
            this.d_measCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    SolidPointDeviceDataPanel.this.updateCardSelect();
                }
            });
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Quantity:"), this.d_measCombo, 0);
            gb.addRow(this.d_cardPanel, 0, 1.0);
            gb.finalizeRows();
            this.d_cardPanel.setVisible(false);
            this.updateCardSelect();
        }

        private void updateCardSelect() {
            IQuantity sel = (IQuantity)this.d_measCombo.getSelectedItem();
            if (sel.get().equals((Object)Quantity.GAUGE_HEAT_FLUX) || sel.get().equals((Object)Quantity.PRESSURE_COEFFICIENT)) {
                this.d_cardLayout.show(this.d_cardPanel, sel.getDescription());
                this.d_cardPanel.setVisible(true);
            } else if (sel.get().equals((Object)Quantity.INSIDE_WALL_TEMPERATURE) || sel.get().equals((Object)Quantity.MATL_SOLID_DENSITY)) {
                this.d_cardLayout.show(this.d_cardPanel, SURFACE_DEPTH);
                this.d_cardPanel.setVisible(true);
            } else {
                this.d_cardPanel.setVisible(false);
            }
            PyroGuiUtil.pack(this);
        }

        public void load(SolidPointMeasurer spm) {
            boolean enableCombo = this.d_mode == IDevcEditor.Mode.CREATE;
            Predicate<Quantity> msrFilter = this.d_measCombo.getFilter();
            if (spm instanceof GaugeHeatFluxMeasurer) {
                this.d_heatFluxPanel.setTemp(((GaugeHeatFluxMeasurer)spm).getGaugeTemperature());
                this.d_heatFluxPanel.setEmiss(((GaugeHeatFluxMeasurer)spm).getGaugeEmissivity());
                this.d_measCombo.setEnabled(enableCombo);
            } else if (spm instanceof PressureCoeffMeasurer) {
                this.d_pressCoeffPanel.setVel(((PressureCoeffMeasurer)spm).getCharacteristicVel());
                this.d_measCombo.setEnabled(enableCombo);
            } else if (spm instanceof InnerTempMeasurer) {
                this.d_surfDepthPanel.setDepth(((InnerTempMeasurer)spm).getDepth());
                this.d_measCombo.setEnabled(enableCombo);
            } else if (spm instanceof SolidDensityMeasurer) {
                this.d_surfDepthPanel.setDepth(((SolidDensityMeasurer)spm).getDepth());
                if (this.d_mode == IDevcEditor.Mode.EDIT) {
                    msrFilter = msrFilter.and(SolidDensityMeasurer.getQuantityFilter());
                }
            } else if (this.d_mode == IDevcEditor.Mode.EDIT) {
                EnumSet<Quantity> invalidMsrs = EnumSet.of(Quantity.GAUGE_HEAT_FLUX, Quantity.PRESSURE_COEFFICIENT, Quantity.INSIDE_WALL_TEMPERATURE);
                msrFilter = msrFilter.and(Filters.reject(invalidMsrs));
                msrFilter = msrFilter.and(SolidDensityMeasurer.getQuantityFilter().negate());
                this.d_measCombo.setEnabled(true);
            }
            this.d_measCombo.setSelectedItem(spm.getQuantity());
            this.d_measCombo.setFilter(msrFilter);
            this.updateCardSelect();
        }

        public SolidPointMeasurer create() {
            IQuantity msrt = (IQuantity)this.d_measCombo.getSelectedItem();
            if (msrt.get().equals((Object)Quantity.GAUGE_HEAT_FLUX)) {
                return new GaugeHeatFluxMeasurer("", this.d_heatFluxPanel.getTemp(), this.d_heatFluxPanel.getEmiss(), new AttachedPointLoc());
            }
            if (msrt.get().equals((Object)Quantity.PRESSURE_COEFFICIENT)) {
                return new PressureCoeffMeasurer("", this.d_pressCoeffPanel.getVel(), new AttachedPointLoc());
            }
            if (msrt.get().equals((Object)Quantity.INSIDE_WALL_TEMPERATURE)) {
                return new InnerTempMeasurer("", this.d_surfDepthPanel.getDepth(), new AttachedPointLoc());
            }
            if (msrt.get().equals((Object)Quantity.MATL_SOLID_DENSITY)) {
                return new SolidDensityMeasurer("", (ObjectQuantity)msrt, this.d_surfDepthPanel.getDepth(), new AttachedPointLoc());
            }
            return new SolidPointMeasurer("", (IQuantity)this.d_measCombo.getSelectedItem(), new AttachedPointLoc());
        }

        public void save(SolidPointMeasurer msr) {
            if (msr instanceof GaugeHeatFluxMeasurer) {
                ((GaugeHeatFluxMeasurer)msr).setGaugeTemperature(this.d_heatFluxPanel.getTemp());
                ((GaugeHeatFluxMeasurer)msr).setGaugeEmissivity(this.d_heatFluxPanel.getEmiss());
            } else if (msr instanceof PressureCoeffMeasurer) {
                ((PressureCoeffMeasurer)msr).setCharacteristicVel(this.d_pressCoeffPanel.getVel());
            } else if (msr instanceof InnerTempMeasurer) {
                ((InnerTempMeasurer)msr).setDepth(this.d_surfDepthPanel.getDepth());
            } else if (msr instanceof SolidDensityMeasurer) {
                SolidDensityMeasurer sdm = (SolidDensityMeasurer)msr;
                this.updateMsr(sdm);
                sdm.setDepth(this.d_surfDepthPanel.getDepth());
            } else {
                this.updateMsr(msr);
            }
        }

        private void updateMsr(AMeasuringDevc devc) {
            IQuantity newMsr = (IQuantity)this.d_measCombo.getSelectedItem();
            UnitSystem us = PyroSim.getApp().getUnitSystem();
            Unit newUnit = us.getUnit(newMsr.get().unitType);
            devc.setQuantity(newMsr, newUnit);
        }
    }

    public static class DepthProps
    extends guiPanel {
        private static final long serialVersionUID = -2411132089444480219L;
        private final UnitSystem d_currentUS = ((PyroSim)Application.getApp()).getUnitSystem();
        private ValueField<UnitDouble> d_depth;

        public DepthProps(UnitDouble defValue) {
            this.setLayout(new GridBagLayout());
            guiLabel depthLab = new guiLabel(Intl.intl("Surface Depth") + ":");
            this.d_depth = ValueFields.udFld(defValue, UnitSystem.getSource(0));
            GridBagUtil.add(this, depthLab, 0, 0, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_depth, 1, 0, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public UnitDouble getDepth() {
            return (UnitDouble)this.d_depth.getValue();
        }

        public void setDepth(UnitDouble depth) {
            this.d_depth.setValue(depth);
        }
    }

    public static class PressureCoeffProps
    extends guiPanel {
        private static final long serialVersionUID = 9038362831755486092L;
        private final UnitSystem d_currentUS = ((PyroSim)Application.getApp()).getUnitSystem();
        private ValueField<UnitDouble> d_vel;

        public PressureCoeffProps() {
            guiLabel velLab = new guiLabel(Intl.intl("Characteristic Velocity") + ":");
            this.d_vel = ValueFields.udFld(new PressureCoeffMeasurer("", null).getCharacteristicVel(), UnitSystem.getSource(8));
            this.setLayout(new GridBagLayout());
            GridBagUtil.add(this, velLab, 0, 0, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_vel, 1, 0, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public UnitDouble getVel() {
            return (UnitDouble)this.d_vel.getValue();
        }

        public void setVel(UnitDouble vel) {
            this.d_vel.setValue(vel);
        }
    }

    public static class GuageHeatFluxProps
    extends guiPanel {
        private static final long serialVersionUID = -6098232058307237925L;
        private final UnitSystem d_currentUS = ((PyroSim)Application.getApp()).getUnitSystem();
        private ValueField<UnitDouble> d_temp;
        private ValueField<Double> d_emiss;

        public GuageHeatFluxProps() {
            guiLabel tempLab = new guiLabel(Intl.intl("Gauge Temperature") + ":");
            this.d_temp = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_temp.setNullAllowed(true);
            ValueFields.getFormat(this.d_temp).alias(null, "TMPA");
            this.d_temp.setValue(null);
            guiLabel emissLab = new guiLabel(Intl.intl("Gauge Emissivity") + ":");
            this.d_emiss = ValueFields.doubleFld(0.9, DoubleVR.between(0.0, 1.0, false, true));
            this.setLayout(new GridBagLayout());
            GridBagUtil.add(this, tempLab, 0, 0, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_temp, 1, 0, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, emissLab, 0, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_emiss, 1, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public UnitDouble getTemp() {
            return (UnitDouble)this.d_temp.getValue();
        }

        public void setTemp(UnitDouble temp) {
            this.d_temp.setValue(temp);
        }

        public Double getEmiss() {
            return (Double)this.d_emiss.getValue();
        }

        public void setEmiss(Double emiss) {
            this.d_emiss.setValue(emiss);
        }
    }
}

