/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.devices.DeviceManager;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.devices.measurers.Thermocouple;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.devices.AlarmInfoPanel;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.devices.MsrDeviceEditorUtil;
import pyrosim.gui.geom.FreePointGeomEditor;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Sets;

public class GasPointDevcEditor
extends ADevcEditor<GasPointMeasurer> {
    private final String d_desc;
    private final String d_defName;
    private final GasPointDeviceDataPanel d_dataPanel;
    private final IQuantity d_fixedMsr;

    public GasPointDevcEditor(PyroMod pyMod, IDevcEditor.Mode mode) {
        this(pyMod, Intl.intl("Gas-phase Device"), Intl.intl("GAS"), null, mode);
    }

    public GasPointDevcEditor(PyroMod pyMod, String desc, String defName, IQuantity type, IDevcEditor.Mode mode) {
        this.d_desc = desc;
        this.d_defName = defName;
        this.d_dataPanel = new GasPointDeviceDataPanel(pyMod, type, mode);
        this.d_fixedMsr = type;
    }

    @Override
    public String getDefName() {
        return this.d_defName;
    }

    @Override
    public String getDesc() {
        return this.d_desc;
    }

    @Override
    public Collection<String> getCustomTypes() {
        HashSet<String> types = new HashSet<String>();
        GasPointMeasurer.getCustomFDSTypes((IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem(), types);
        return types;
    }

    @Override
    public Set<String> getFDSPreviewTypes() {
        return Sets.fromArrayHS("PROP", "DEVC");
    }

    @Override
    public AlarmInfoPanel createAlarmPanel() {
        final AlarmInfoPanel alarmPanel = new AlarmInfoPanel((IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem());
        this.d_dataPanel.d_measCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    alarmPanel.setCurrentMsr((IQuantity)GasPointDevcEditor.this.d_dataPanel.d_measCombo.getSelectedItem());
                }
            }
        });
        if (this.d_fixedMsr != null) {
            alarmPanel.setCurrentMsr(this.d_fixedMsr);
        }
        return alarmPanel;
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new FreePointGeomEditor();
    }

    @Override
    public void load(GasPointMeasurer gpm) {
        this.d_dataPanel.load(gpm);
    }

    @Override
    public GasPointMeasurer create() {
        return this.d_dataPanel.create("");
    }

    @Override
    public void save(GasPointMeasurer msr) {
        this.d_dataPanel.save(msr);
    }

    @Override
    public boolean validateData(Component parent, GasPointMeasurer loadedObj, boolean showWarn, boolean allowModify) {
        return MsrDeviceEditorUtil.validateData(parent, loadedObj, (IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem(), showWarn, allowModify);
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    public static class GasPointDeviceDataPanel
    extends guiPanel {
        private static final long serialVersionUID = 3844599879929888196L;
        private final IDevcEditor.Mode d_mode;
        private final DeviceManager d_mgr;
        private final QuantityComboBox d_measCombo;
        private final ThermocoupleProps d_thermocouplePanel;

        public GasPointDeviceDataPanel(PyroMod pyMod, IQuantity defType, IDevcEditor.Mode mode) {
            this.d_mgr = pyMod.getDevices();
            this.d_mode = mode;
            this.setLayout(new GridBagLayout());
            this.d_measCombo = new QuantityComboBox(GasPointMeasurer.getOutputType(), GasPointMeasurer.getQuantityType());
            this.d_measCombo.setMinimumSize(this.d_measCombo.getPreferredSize());
            this.d_thermocouplePanel = new ThermocoupleProps();
            this.d_measCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    this.updateCardSelect();
                }
            });
            if (defType != null) {
                this.d_measCombo.setSelectedItem(defType);
            }
            if (mode == IDevcEditor.Mode.EDIT) {
                this.d_measCombo.setEnabled(false);
            }
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Quantity:"), this.d_measCombo, 0);
            gb.addRow(this.d_thermocouplePanel, 0, 1.0);
            gb.finalizeRows();
            this.updateCardSelect();
        }

        private void updateCardSelect() {
            this.d_thermocouplePanel.setVisible(((IQuantity)this.d_measCombo.getSelectedItem()).get().equals((Object)Quantity.THERMOCOUPLE));
            PyroGuiUtil.pack(this);
        }

        public void load(GasPointMeasurer gpm) {
            this.d_measCombo.setSelectedItem(gpm.getQuantity());
            if (gpm instanceof Thermocouple) {
                Thermocouple tc = (Thermocouple)gpm;
                this.d_thermocouplePanel.load(tc);
                if (this.d_mode == IDevcEditor.Mode.EDIT) {
                    this.d_measCombo.setEnabled(false);
                }
            } else {
                if (this.d_mode == IDevcEditor.Mode.EDIT) {
                    Predicate<Quantity> thcpFilter = Filters.reject(Quantity.THERMOCOUPLE);
                    Predicate<Quantity> filter = thcpFilter.and(this.d_measCombo.getFilter());
                    this.d_measCombo.setFilter(filter);
                }
                this.d_measCombo.setEnabled(true);
            }
        }

        public GasPointMeasurer create(String name) {
            if (((IQuantity)this.d_measCombo.getSelectedItem()).get().equals((Object)Quantity.THERMOCOUPLE)) {
                return new Thermocouple(name, new FreePointLoc());
            }
            return new GasPointMeasurer(name, (IQuantity)this.d_measCombo.getSelectedItem(), new FreePointLoc());
        }

        public void save(GasPointMeasurer msr) {
            if (msr instanceof Thermocouple) {
                assert (((IQuantity)this.d_measCombo.getSelectedItem()).get().equals((Object)Quantity.THERMOCOUPLE));
                Thermocouple tc = (Thermocouple)msr;
                this.d_thermocouplePanel.save(tc);
            } else {
                IQuantity newMsr = (IQuantity)this.d_measCombo.getSelectedItem();
                UnitSystem us = PyroSim.getApp().getUnitSystem();
                Unit newUnit = us.getUnit(newMsr.get().unitType);
                msr.setQuantity(newMsr, newUnit);
            }
        }
    }

    private static class ThermocoupleProps
    extends guiPanel {
        private static final long serialVersionUID = 904712893678455207L;
        private ValueField<UnitDouble> d_beadDiam = ValueFields.udFld(UnitSystem.getSource(9));
        private ValueField<Double> d_emissivity = ValueFields.doubleFld();
        private ValueField<UnitDouble> d_beadDensity = ValueFields.udFld(UnitSystem.getSource(4));
        private ValueField<UnitDouble> d_beadSpecHeat = ValueFields.udFld(UnitSystem.getSource(11));

        public ThermocoupleProps() {
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Bead Diameter") + ":", this.d_beadDiam);
            gb.addRow(Intl.intl("Emissivity") + ":", this.d_emissivity);
            gb.addRow(Intl.intl("Bead Density:"), this.d_beadDensity);
            gb.addRow(Intl.intl("Bead Specific Heat:"), this.d_beadSpecHeat);
            gb.finalizeRows();
            this.load(new Thermocouple("", null));
        }

        public void load(Thermocouple tc) {
            this.d_beadDiam.setValue(tc.getBeadDiameter());
            this.d_emissivity.setValue(tc.getEmissivity());
            this.d_beadDensity.setValue(tc.getBeadDensity());
            this.d_beadSpecHeat.setValue(tc.getBeadSpecHeat());
        }

        public void save(Thermocouple tc) {
            tc.setBeadDiameter((UnitDouble)this.d_beadDiam.getValue());
            tc.setEmissivity((Double)this.d_emissivity.getValue());
            tc.setBeadDensity((UnitDouble)this.d_beadDensity.getValue());
            tc.setBeadSpecHeat((UnitDouble)this.d_beadSpecHeat.getValue());
        }
    }
}

