/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.devices.aspiration.Aspirator;
import pyrosim.domain.devices.aspiration.AspiratorSampler;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.geom.FreePointGeomEditor;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.NamedSorter;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.SortCache;

public class AspiratorEditor
extends ADevcEditor<Aspirator> {
    private final AspiratorDataPanel d_dataPanel = new AspiratorDataPanel();
    private final SamplerPanel d_samplerPanel;

    public AspiratorEditor(PyroMod pyMod) {
        this.d_samplerPanel = new SamplerPanel(pyMod);
    }

    @Override
    public String getDesc() {
        return Intl.intl("Aspirator");
    }

    @Override
    public String getDefName() {
        return Intl.intl("ASP");
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new FreePointGeomEditor();
    }

    @Override
    public guiPanel getDataPanel() {
        guiPanel pnl = new guiPanel();
        GridBagHelper gb = new GridBagHelper(pnl);
        gb.addFilledRow(this.d_dataPanel);
        gb.addFilledRow(new TitleSeparator(Intl.intl("Input Samplers")));
        gb.addFilledRow(this.d_samplerPanel);
        gb.finalizeRows();
        return pnl;
    }

    @Override
    public boolean validateData(Component parent, Aspirator loadedObj, boolean showWarn, boolean allowModify) {
        return true;
    }

    @Override
    public void load(Aspirator asp) {
        this.d_dataPanel.setFlowRate(asp.getBypassFlowrate());
        this.d_samplerPanel.load(asp);
    }

    @Override
    public Aspirator create() {
        return new Aspirator("", this.d_dataPanel.getFlowRate(), new FreePointLoc());
    }

    @Override
    public void save(Aspirator asp) {
        asp.setBypassFlowrate(this.d_dataPanel.getFlowRate());
        this.d_samplerPanel.save(asp);
    }

    public static class AspiratorDataPanel
    extends guiPanel {
        private static final long serialVersionUID = -1724769536556729000L;
        private final ValueField<UnitDouble> d_flowRate;

        public AspiratorDataPanel() {
            this.setLayout(new GridBagLayout());
            this.d_flowRate = ValueFields.udFld(new Aspirator("", null).getBypassFlowrate(), UnitSystem.getSource(38));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Bypass Flow Rate:"), this.d_flowRate);
            gb.finalizeRows();
        }

        public UnitDouble getFlowRate() {
            return (UnitDouble)this.d_flowRate.getValue();
        }

        public void setFlowRate(UnitDouble flowRate) {
            this.d_flowRate.setValue(flowRate);
        }
    }

    private class SamplerPanel
    extends guiPanel {
        private static final long serialVersionUID = 5423362506775964122L;
        private final SamplerTableModel d_tableModel;
        private guiTable d_table;

        public SamplerPanel(PyroMod model) {
            super(new BorderLayout());
            this.d_tableModel = new SamplerTableModel(model);
            if (this.d_tableModel.getRowCount() > 0) {
                this.d_table = new guiTable((TableModel)this.d_tableModel, 0);
                guiTableEditor editor = new guiTableEditor(this.d_table, 0);
                int width = this.d_table.autoSizeColumns(true, 100);
                editor.setPreferredSize(new Dimension(width, 100));
                this.add((Component)editor, "Center");
            } else {
                this.add((Component)new guiLabel(Intl.intl("There are currently no samplers in the model.")), "Center");
            }
        }

        public void load(Aspirator asp) {
            this.d_tableModel.load(asp);
        }

        public void save(Aspirator asp) {
            this.d_tableModel.save(asp);
        }

        private class SamplerTableModel
        extends AbstractTableModel {
            private static final long serialVersionUID = -1056606631145984560L;
            private final Unit d_frUnit;
            private final Unit d_delayUnit;
            private final boolean[] d_enabled;
            private final Double[] d_delays;
            private final Double[] d_flowrates;
            private final SortCache<AspiratorSampler> d_samplers;

            public SamplerTableModel(PyroMod model) {
                this.d_samplers = new SortCache<AspiratorSampler>(((APyroObject)model.getDevices()).flatten(AspiratorSampler.class), new NamedSorter());
                this.d_enabled = new boolean[this.d_samplers.size()];
                UnitSystem us = PyroSim.getApp().getUnitSystem();
                this.d_frUnit = us.getUnit(38);
                this.d_delayUnit = us.getUnit(2);
                Aspirator.SamplerLine defSampLine = new Aspirator.SamplerLine(null);
                Arrays.fill(this.d_enabled, false);
                this.d_delays = new Double[this.d_samplers.size()];
                Arrays.fill((Object[])this.d_delays, (Object)defSampLine.d_delay.getValue(this.d_delayUnit));
                this.d_flowrates = new Double[this.d_samplers.size()];
                Arrays.fill((Object[])this.d_flowrates, (Object)defSampLine.d_flowrate.getValue(this.d_frUnit));
            }

            public void save(Aspirator aspirator) {
                ArrayList<Aspirator.SamplerLine> lines = new ArrayList<Aspirator.SamplerLine>();
                for (int m = 0; m < this.d_enabled.length; ++m) {
                    if (!this.d_enabled[m] || this.d_flowrates[m] == null || this.d_delays[m] == null) continue;
                    UnitDouble flowrate = new UnitDouble(this.d_flowrates[m], this.d_frUnit);
                    UnitDouble delay = new UnitDouble(this.d_delays[m], this.d_delayUnit);
                    lines.add(new Aspirator.SamplerLine(this.d_samplers.get(m), flowrate, delay));
                }
                aspirator.setSamplerLines(lines);
            }

            public void load(Aspirator aspirator) {
                for (Aspirator.SamplerLine line : aspirator.getSamplerLines()) {
                    int index = this.d_samplers.indexOf(line.d_sampler);
                    this.d_enabled[index] = true;
                    this.d_delays[index] = line.d_delay.getValue(this.d_delayUnit);
                    this.d_flowrates[index] = line.d_flowrate.getValue(this.d_frUnit);
                }
            }

            @Override
            public int getRowCount() {
                return this.d_samplers.size();
            }

            @Override
            public int getColumnCount() {
                return 4;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return Intl.intl("Enabled");
                    }
                    case 1: {
                        return Intl.intl("Sampler");
                    }
                    case 2: {
                        return String.format(Intl.intl("Transfer Delay (%s)"), this.d_delayUnit.toString());
                    }
                    case 3: {
                        return String.format(Intl.intl("Flowrate (%s)"), this.d_frUnit.toString());
                    }
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return Boolean.class;
                    }
                    case 1: {
                        return String.class;
                    }
                    case 2: {
                        return Double.class;
                    }
                    case 3: {
                        return Double.class;
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 0 || columnIndex == 2 || columnIndex == 3;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return this.d_enabled[rowIndex];
                    }
                    case 1: {
                        return this.d_samplers.get(rowIndex).getName();
                    }
                    case 2: {
                        return this.d_delays[rowIndex];
                    }
                    case 3: {
                        return this.d_flowrates[rowIndex];
                    }
                }
                return null;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        if (aValue == null) break;
                        this.d_enabled[rowIndex] = (Boolean)aValue;
                        break;
                    }
                    case 2: {
                        this.d_delays[rowIndex] = (Double)aValue;
                        break;
                    }
                    case 3: {
                        this.d_flowrates[rowIndex] = (Double)aValue;
                    }
                }
                this.fireTableChanged(new TableModelEvent(this, rowIndex));
            }
        }
    }
}

