/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.INamed;
import pyrosim.domain.controls.AControl;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.CustomCtrl;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.ManualCtrl;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.detectors.Timer;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.hvac.IHvacObject;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ILogicInPin;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.Util;
import pyrosim.gui.ResizableWindow;
import pyrosim.gui.controls.ControlDesc;
import pyrosim.io.fds.DefaultFieldRenderer;
import pyrosim.io.fds.FDSGrammar;
import pyrosim.io.fds.FDSParseException;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParseResult;
import pyrosim.io.fds.FDSParseWarning;
import pyrosim.io.fds.FDSRecord;
import pyrosim.io.fds.FDSRecordCollector;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.FDSRenderer;
import pyrosim.io.fds.FDSWarningReport;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.parsers.FDS6Parser;
import pyrosim.io.fds.v6.renderers.FDS6Renderer;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.Utils;
import thunderheadeng.gui.Validateable;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.io.StringPrintWriter;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.SortCache;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.theUtil;

public class ControlPnl
extends guiPanel
implements IEditor<ControlBridge> {
    private static final long serialVersionUID = -6642987861153912507L;
    private static final int INDENT = 18;
    private final ActionPnl d_actionPnl;
    private final InputPnl d_inputTypePnl;
    private final StatementPnl d_statementPnl;
    private List<ISignalSink> d_originalSinks = Collections.EMPTY_LIST;
    private PopupWindow d_currentPopup = null;

    public ControlPnl() {
        this(true);
    }

    public ControlPnl(boolean displaySinks) {
        super(new GridBagLayout());
        this.d_actionPnl = new ActionPnl();
        this.d_inputTypePnl = new InputPnl();
        this.d_statementPnl = new StatementPnl(this, displaySinks);
        int row = 0;
        GridBagUtil.add(this, this.d_inputTypePnl, 0, ++row, 1, 1, 0, 0, 12, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, this.d_actionPnl, 0, ++row, 1, 1, 0, 0, 12, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, this.d_statementPnl, 0, ++row, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 17);
        ActionListener updateList = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ControlPnl.this.updatePanels();
            }
        };
        this.d_actionPnl.addListener(updateList);
        this.d_inputTypePnl.addListener(updateList);
        this.d_actionPnl.d_createBtn.setSelected(true);
        this.d_inputTypePnl.d_timeBtn.setSelected(true);
        this.updatePanels();
        this.setEnabled(false);
        this.setModified(false);
    }

    @Override
    public ControlBridge preview(ControlBridge previewObj) {
        if (!this.validateData(false, false)) {
            return null;
        }
        this.savePin(previewObj);
        return previewObj;
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.updateAvailOptions();
    }

    private void updateAvailOptions() {
        boolean detEnabled = this.d_statementPnl.isDataValid(-1, -1, 1);
        this.d_inputTypePnl.d_detectorBtn.setEnabled(this.isEnabled() && detEnabled);
        if (this.isEnabled() && !detEnabled) {
            this.d_inputTypePnl.d_detectorBtn.setToolTipText(Intl.intl("No detectors or triggering devices are currently in the model."));
        } else {
            this.d_inputTypePnl.d_detectorBtn.setToolTipText(null);
        }
        boolean dbEnabled = this.d_statementPnl.isDataValid(-1, -1, 2);
        this.d_inputTypePnl.d_thermostatBtn.setEnabled(this.isEnabled() && dbEnabled);
        if (this.isEnabled() && !dbEnabled) {
            this.d_inputTypePnl.d_thermostatBtn.setToolTipText(Intl.intl("No device input for a deadband is currently in model."));
        } else {
            this.d_inputTypePnl.d_thermostatBtn.setToolTipText(null);
        }
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public void init(ControlBridge dataObj) {
        this.init(dataObj, null, null);
    }

    public void init(ControlBridge dataObj, Collection<String> sinkNames, ControlDesc.SinkType sinkType) {
        this.setEnabled(dataObj != null);
        if (dataObj != null) {
            this.load(dataObj, sinkNames, sinkType);
        }
        this.setModified(false);
    }

    private void load(ControlBridge dataObj, Collection<String> sinkNames, ControlDesc.SinkType sinkType) {
        if (sinkNames != null) {
            this.d_statementPnl.d_desc.setSinkNames(sinkNames);
        } else if (dataObj.getDomain() != null) {
            DepSnapshot deps = ((PyroMod)dataObj.getDomain()).getDependencies(dataObj);
            Set<Dependency> dependents = deps.getDependents(dataObj);
            this.d_originalSinks = new ArrayList<ISignalSink>(dependents.size());
            for (Dependency dependent : dependents) {
                if (!(dependent.source instanceof IInPin)) continue;
                this.d_originalSinks.add(((IInPin)dependent.source).getAttachedSink());
            }
            sinkType = ControlDesc.getSinkType(this.d_originalSinks);
            this.d_statementPnl.d_desc.setSinks(this.d_originalSinks);
        }
        this.setSinkType(sinkType);
        this.d_statementPnl.load(dataObj.getInputPin());
        this.d_actionPnl.setValue(((StatementPnl)this.d_statementPnl).d_desc.d_action);
        this.d_inputTypePnl.setValue(((StatementPnl)this.d_statementPnl).d_desc.d_input);
        this.updatePanels();
    }

    private void setSinkType(ControlDesc.SinkType sinkType) {
        this.d_statementPnl.setSinkType(sinkType);
        this.d_actionPnl.setSinkType(sinkType);
    }

    @Override
    public boolean isModified() {
        return super.isModified() || this.d_currentPopup != null;
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (this.d_currentPopup != null && !this.d_currentPopup.validateData(showWarn, allowModify)) {
            return false;
        }
        int type = this.d_inputTypePnl.getValue();
        if (type == 1 || type == 2) {
            ISignalSource src2;
            Collection<? extends ISignalSink> sinks = Collections.unmodifiableCollection(((StatementPnl)this.d_statementPnl).d_desc.d_dstObjs);
            List<Object> sources = null;
            if (type == 1) {
                sources = ((StatementPnl)this.d_statementPnl).d_desc.d_srcDetectors.stream().map(outPin -> outPin.getAttachedSource()).filter(src -> src instanceof ISignalSink).map(src -> (ISignalSink)((Object)src)).collect(Collectors.toList());
            } else if (type == 2 && ((StatementPnl)this.d_statementPnl).d_desc.d_srcMeasurer != null && (src2 = ((StatementPnl)this.d_statementPnl).d_desc.d_srcMeasurer.getAttachedSource()) instanceof ISignalSink) {
                sources = Arrays.asList((ISignalSink)((Object)src2));
            }
            if (sources == null) {
                sources = Collections.emptyList();
            }
            for (ISignalSink iSignalSink : sinks) {
                for (ISignalSink source : sources) {
                    if (!Util.containsCycle(iSignalSink, source)) continue;
                    if (showWarn) {
                        guiDialog.showInvalidEntryMessage(this, Intl.intl("Controls cannot create cyclic definitions."));
                    }
                    return false;
                }
            }
        }
        return super.validateData(showWarn, allowModify);
    }

    @Override
    public ControlBridge commit(final ControlBridge dataObj) {
        if (this.d_currentPopup != null) {
            this.d_currentPopup.commit();
            this.d_currentPopup.setVisible(false);
        }
        boolean reinit = false;
        LinkedIdentityHashSet<? extends ISignalSink> modifyObjs = Collections.EMPTY_SET;
        if (((StatementPnl)this.d_statementPnl).d_desc.d_dstObjNames == null) {
            modifyObjs = new LinkedIdentityHashSet<ISignalSink>(((StatementPnl)this.d_statementPnl).d_desc.d_dstObjs);
            ArrayList<ISignalSink> alreadyAssigned = new ArrayList<ISignalSink>();
            for (ISignalSink iSignalSink : modifyObjs) {
                ISignalSource src;
                if (iSignalSink.getInputPin().getConnections().isEmpty() || (src = iSignalSink.getInputPin().getConnectedSources().iterator().next()) == dataObj) continue;
                alreadyAssigned.add(iSignalSink);
            }
            if (!alreadyAssigned.isEmpty()) {
                String msg = String.format(Intl.intl("WARNING: Some of the selected activation objects already have\ndifferent controls assigned to them. Would to like to assign\n\"%s\" to them instead?"), dataObj.getName());
                int n = JOptionPane.showConfirmDialog(this, msg, Intl.intl("Reassign Activation Logic"), 1);
                if (n != 0 && n != 1) {
                    return dataObj;
                }
                if (n == 1) {
                    modifyObjs.removeAll(alreadyAssigned);
                    reinit = true;
                }
            }
        }
        final LinkedIdentityHashSet<? extends ISignalSink> modObjs = modifyObjs;
        AOneTimeTask t = new AOneTimeTask(){

            @Override
            public void run() {
                ControlPnl.this.savePin(dataObj);
                if (((StatementPnl)((ControlPnl)ControlPnl.this).d_statementPnl).d_desc.d_dstObjNames == null) {
                    for (ISignalSink originalSink : ControlPnl.this.d_originalSinks) {
                        if (modObjs.contains(originalSink)) continue;
                        originalSink.getInputPin().disconnectAll();
                        originalSink.changedEvt(new Object[0]);
                    }
                    for (ISignalSink sink : modObjs) {
                        sink.getInputPin().disconnectAll();
                        sink.getInputPin().connect(dataObj.getOutputPins().get(0));
                        sink.changedEvt(new Object[0]);
                    }
                }
            }
        };
        PyroSim.getApp().getMediator().getTaskManager().exec(t, Intl.intl("Edit Control"));
        this.setModified(false);
        if (reinit) {
            this.init(dataObj);
        }
        return dataObj;
    }

    private void savePin(ControlBridge dataObj) {
        IOutPin srcPin = this.d_statementPnl.save();
        dataObj.getInputPin().disconnectAll();
        if (srcPin != null) {
            dataObj.getInputPin().connect(srcPin);
            if (srcPin.getAttachedSource() instanceof IControl) {
                ((IControl)srcPin.getAttachedSource()).setName(dataObj.getName());
            }
        }
        dataObj.changedEvt(new Object[0]);
    }

    private void updatePanels() {
        this.d_actionPnl.setInput(this.d_inputTypePnl.getValue());
        this.d_statementPnl.setData(this.d_actionPnl.getValue(), this.d_inputTypePnl.getValue());
    }

    private static class MultiSelectHelperWindow<T>
    extends PopupWindow {
        private static final long serialVersionUID = -8784523385840655311L;
        private TableModel<T> d_tableModel;
        private guiTable d_table;
        private JButton d_okBtn;
        private JButton d_clearBtn;
        private JButton d_selAllBtn;
        private Callback<T> d_callback;

        public MultiSelectHelperWindow() {
        }

        public MultiSelectHelperWindow(Frame parent) {
            super(parent);
        }

        public MultiSelectHelperWindow(Window parent) {
            super(parent);
        }

        public boolean isEmpty() {
            return this.d_tableModel.getRowCount() == 0;
        }

        public void initAllObjs(Collection<? extends T> availObjs) {
            this.d_tableModel = new TableModel<T>(availObjs);
            if (this.d_tableModel.getRowCount() > 0) {
                this.d_table = new guiTable(this.d_tableModel, 0);
                guiTableEditor editor = new guiTableEditor(this.d_table, 0);
                this.d_table.setTableHeader(null);
                this.d_table.setShowVerticalLines(false);
                this.d_table.setColumnSelectionAllowed(false);
                this.d_table.setSelectionMode(0);
                TableCellRenderer rend = this.d_table.getCellRenderer(0, 0);
                Component comp = rend.getTableCellRendererComponent(this.d_table, Boolean.FALSE, false, false, 0, 0);
                int width = comp.getPreferredSize().width + 20;
                this.d_table.getColumnModel().getColumn(0).setMaxWidth(width);
                this.d_table.getColumnModel().getColumn(0).setMinWidth(width);
                this.d_table.setPreferredScrollableViewportSize(new Dimension(this.d_table.getPreferredSize().width, 100));
                this.d_okBtn = new JButton(Intl.intl("OK"));
                this.d_clearBtn = new JButton(Intl.intl("Clear"));
                this.d_clearBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        d_tableModel.clearSel();
                    }
                });
                this.d_selAllBtn = new JButton(Intl.intl("Select All"));
                this.d_selAllBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        d_tableModel.selectAll();
                    }
                });
                this.d_clearBtn.setPreferredSize(new Dimension(this.d_clearBtn.getPreferredSize().width, this.d_clearBtn.getPreferredSize().height - 4));
                this.d_selAllBtn.setPreferredSize(new Dimension(this.d_selAllBtn.getPreferredSize().width, this.d_selAllBtn.getPreferredSize().height - 4));
                final Comparator<Object> comparator = new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        return ControlDesc.getName(o1).compareToIgnoreCase(ControlDesc.getName(o2));
                    }
                };
                if (this.d_table.getRowCount() > 8) {
                    final guiTextField findFld = new guiTextField();
                    findFld.addKeyListener(new KeyAdapter(){

                        @Override
                        public void keyReleased(KeyEvent e) {
                            String toFind = findFld.getText();
                            if (e.getKeyCode() == 10) {
                                int selRow = d_table.getSelectedRow();
                                if (selRow >= 0) {
                                    boolean val = (Boolean)d_table.getValueAt(selRow, 0);
                                    d_table.setValueAt(!val, selRow, 0);
                                }
                                findFld.setSelectionStart(0);
                                findFld.setSelectionEnd(toFind.length());
                            } else {
                                int ix = d_tableModel.d_objCache.findGeneric(toFind, comparator);
                                if (ix < 0) {
                                    ix = -ix - 1;
                                }
                                if (ix >= d_table.getRowCount()) {
                                    ix = d_table.getRowCount() - 1;
                                }
                                d_table.setRowSelectionInterval(ix, ix);
                                Rectangle rect = d_table.getCellRect(ix, -1, true);
                                rect.height = ((MultiSelectHelperWindow)this).d_table.getVisibleRect().height;
                                d_table.scrollRectToVisible(rect);
                            }
                        }
                    });
                    guiPanel northPanel = new guiPanel(new BorderLayout());
                    northPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 6, 0));
                    northPanel.add(findFld);
                    this.add((Component)northPanel, "North");
                }
                final guiLabel numSelLbl = new guiLabel("");
                this.d_tableModel.addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent e) {
                        this.updateSelLabel(numSelLbl);
                    }
                });
                this.updateSelLabel(numSelLbl);
                guiPanel footerPnl = new guiPanel(new GridBagLayout());
                int row = 0;
                GridBagUtil.add(footerPnl, this.d_clearBtn, 0, ++row, 1, 1, 6, 0, 3, 6, 0, 0.0, 0.0, 17);
                GridBagUtil.add(footerPnl, this.d_selAllBtn, 1, row, 1, 1, 6, 0, 3, 0, 0, 0.0, 0.0, 17);
                GridBagUtil.add(footerPnl, numSelLbl, 0, ++row, 2, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
                GridBagUtil.add(footerPnl, this.d_okBtn, 0, ++row, 2, 1, 0, 0, 0, 0, 0, 1.0, 0.0, 13);
                this.add((Component)editor, "Center");
                this.add((Component)footerPnl, "South");
            } else {
                this.add((Component)new guiLabel(Intl.intl("There are currently no objects in the model.")), "Center");
            }
            this.pack();
        }

        private void updateSelLabel(guiLabel selLbl) {
            String tooltip = "";
            int m = 0;
            for (Integer ix : ((TableModel)this.d_tableModel).d_selObjs) {
                if (ix < 0) continue;
                Object obj = ((TableModel)this.d_tableModel).d_objCache.get(ix);
                if (m++ != 0) {
                    tooltip = tooltip + ", ";
                }
                tooltip = tooltip + ControlDesc.getName(obj);
                if (m != 10) continue;
                break;
            }
            if (m < ((TableModel)this.d_tableModel).d_selObjs.size()) {
                tooltip = tooltip + ", ...";
            }
            selLbl.setText(String.format(Intl.intl("Number selected: %d"), ((TableModel)this.d_tableModel).d_selObjs.size()));
            selLbl.setToolTipText(tooltip);
        }

        public void init(Point loc, Collection<? extends T> selObjs, final Callback<T> callback) {
            this.d_callback = callback;
            this.d_tableModel.load(selObjs);
            for (ActionListener list : this.d_okBtn.getActionListeners()) {
                this.d_okBtn.removeActionListener(list);
            }
            this.d_okBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    callback.select(d_tableModel.save());
                    this.setVisible(false);
                }
            });
            this.setLocation(loc);
            this.setVisible(true);
        }

        @Override
        public void commit() {
            this.d_callback.select(this.d_tableModel.save());
        }

        private static class TableModel<T>
        extends AbstractTableModel {
            private static final long serialVersionUID = 8101300018625206497L;
            private static final int COL_ENABLED = 0;
            private static final int COL_DETECTOR = 1;
            private static final int NUM_COLS = 2;
            private final SortCache<T> d_objCache;
            private final Set<Integer> d_selObjs;

            public TableModel(Collection<? extends T> availObjs) {
                this.d_objCache = new SortCache<T>(availObjs);
                this.d_selObjs = new TreeSet<Integer>();
            }

            public void selectAll() {
                for (int m = 0; m < this.d_objCache.size(); ++m) {
                    this.d_selObjs.add(m);
                }
                this.fireTableRowsUpdated(0, this.d_objCache.size() - 1);
            }

            public void clearSel() {
                this.d_selObjs.clear();
                this.fireTableRowsUpdated(0, this.d_objCache.size() - 1);
            }

            public void load(Collection<? extends T> sel) {
                this.d_selObjs.clear();
                for (T obj : sel) {
                    int ix = this.d_objCache.indexOf(obj);
                    this.d_selObjs.add(ix);
                }
                this.fireTableRowsUpdated(0, this.d_objCache.size() - 1);
            }

            public List<T> save() {
                ArrayList<T> result = new ArrayList<T>(this.d_selObjs.size());
                for (Integer ix : this.d_selObjs) {
                    if (ix == -1) continue;
                    result.add(this.d_objCache.get(ix));
                }
                return result;
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return this.d_objCache.size();
            }

            @Override
            public String getColumnName(int column) {
                return "";
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 0;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return Boolean.class;
                    }
                    case 1: {
                        return String.class;
                    }
                }
                return null;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        return this.d_selObjs.contains(rowIndex) ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 1: {
                        return ControlDesc.getName(this.d_objCache.get(rowIndex));
                    }
                }
                return null;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                if (aValue == null) {
                    return;
                }
                switch (columnIndex) {
                    case 0: {
                        if (((Boolean)aValue).booleanValue()) {
                            this.d_selObjs.add(rowIndex);
                            break;
                        }
                        this.d_selObjs.remove(rowIndex);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                this.fireTableChanged(new TableModelEvent(this, rowIndex));
            }
        }

        private static interface Callback<T> {
            public void select(List<T> var1);
        }
    }

    private static class ListHelperWindow
    extends PopupWindow {
        private static final long serialVersionUID = 4745659433631625480L;
        private Callback d_callback;
        private JList optionsList;
        private int[] itemVals;
        private int initialSel;

        public ListHelperWindow() {
        }

        public ListHelperWindow(Frame parent) {
            super(parent);
        }

        public ListHelperWindow(Window parent) {
            super(parent);
        }

        public void init(Point loc, boolean showSearchHelper, int initialSel, int[] itemVals, final String[] itemNames, Callback callback) {
            assert (itemVals.length == itemNames.length);
            this.d_callback = callback;
            this.itemVals = itemVals;
            this.initialSel = initialSel;
            this.optionsList = new JList<String>(itemNames);
            JScrollPane sp = new JScrollPane(this.optionsList);
            this.optionsList.setSelectionMode(0);
            int iniix = -1;
            for (int m = 0; m < itemVals.length; ++m) {
                if (initialSel != itemVals[m]) continue;
                iniix = m;
                break;
            }
            this.optionsList.setSelectedIndex(iniix);
            this.optionsList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() == 1) {
                        this.commitSelection();
                    }
                }
            });
            this.optionsList.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                        this.commitSelection();
                    }
                }
            });
            this.getContentPane().add((Component)sp, "Center");
            if (showSearchHelper && itemVals.length > 8) {
                final Comparator<String> comparator = new Comparator<String>(){

                    @Override
                    public int compare(String o1, String o2) {
                        return o1.compareToIgnoreCase(o2);
                    }
                };
                final guiTextField findFld = new guiTextField();
                findFld.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyReleased(KeyEvent e) {
                        if (e.getKeyCode() == 10) {
                            this.commitSelection();
                        } else {
                            String toFind = findFld.getText();
                            int ix = Arrays.binarySearch(itemNames, toFind, comparator);
                            if (ix < 0) {
                                ix = -ix - 1;
                            }
                            if (ix >= itemNames.length) {
                                ix = itemNames.length - 1;
                            }
                            optionsList.setSelectedIndex(ix);
                            Rectangle rect = optionsList.getCellBounds(ix, ix);
                            rect.height = ((ListHelperWindow)this).optionsList.getVisibleRect().height;
                            optionsList.scrollRectToVisible(rect);
                        }
                    }
                });
                guiPanel findPnl = new guiPanel(new BorderLayout());
                findPnl.add(findFld);
                findPnl.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
                this.add((Component)findPnl, "North");
            }
            this.requestFocus();
            this.pack();
            this.setLocation(loc);
            this.setVisible(true);
        }

        private void commitSelection() {
            this.commit();
            this.setVisible(false);
        }

        @Override
        public void commit() {
            int selix = this.optionsList.getSelectedIndex();
            int result = selix >= 0 ? this.itemVals[selix] : this.initialSel;
            this.d_callback.select(result);
        }

        public static interface Callback {
            public void select(int var1);
        }
    }

    private static class ValueFieldHelperWindow<T>
    extends PopupWindow {
        private static final long serialVersionUID = -1443765057610622078L;
        private ValueField<T> d_fld;
        private Callback<T> d_callback;

        public ValueFieldHelperWindow() {
        }

        public ValueFieldHelperWindow(Frame parent) {
            super(parent);
        }

        public ValueFieldHelperWindow(Window parent) {
            super(parent);
        }

        @Override
        public void commit() {
            this.d_callback.select(this.d_fld.getValue());
        }

        @Override
        public boolean validateData(boolean warn, boolean modify) {
            return this.d_fld.validateData(warn, modify);
        }

        public void init(Point loc, ValueField<T> fld, Callback<T> callback) {
            this.d_fld = fld;
            this.d_callback = callback;
            fld.setColumns(12);
            Consumer<EventObject> commit = e -> {
                callback.select(fld.getValue());
                this.setVisible(false);
            };
            Consumer<EventObject> cancel = e -> this.setVisible(false);
            fld.addValueListener(ValueField.VAL_COMMIT, e -> commit.accept(e));
            fld.setDefaultCommand(commit);
            fld.addValueListener(ValueField.VAL_CANCEL, e -> cancel.accept(e));
            this.getContentPane().add(fld, "Center");
            this.pack();
            this.setLocation(loc);
            this.setVisible(true);
        }

        public static interface Callback<T> {
            public void select(T var1);
        }
    }

    private static abstract class PopupWindow
    extends ResizableWindow
    implements Validateable {
        private static final long serialVersionUID = 8961210174042159198L;
        private MouseAdapter d_parentMouseListener;

        public PopupWindow() {
            this.init();
        }

        public PopupWindow(Frame parent) {
            super((Window)parent);
            this.init();
        }

        public PopupWindow(Window parent) {
            super(parent);
            this.init();
        }

        protected ControlPnl findPanel() {
            Container parent = this.getParent();
            return parent != null ? this.findPanel(parent) : null;
        }

        private ControlPnl findPanel(Container parent) {
            for (Component child : parent.getComponents()) {
                ControlPnl panel;
                if (child instanceof ControlPnl) {
                    return (ControlPnl)child;
                }
                if (!(child instanceof Container) || (panel = this.findPanel((Container)child)) == null) continue;
                return panel;
            }
            return null;
        }

        public abstract void commit();

        public boolean validateData() {
            return this.validateData(true, true);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            return true;
        }

        private List<Component> getParentComponents() {
            Container parentWindow = this.getParent();
            if (parentWindow != null) {
                ArrayList<Component> comps = new ArrayList<Component>();
                comps.add(parentWindow);
                this.getComponents(parentWindow, comps);
                return comps;
            }
            return Collections.EMPTY_LIST;
        }

        private void getComponents(Container parent, List<Component> children) {
            for (Component child : parent.getComponents()) {
                children.add(child);
                if (!(child instanceof Container)) continue;
                this.getComponents((Container)child, children);
            }
        }

        private void init() {
            this.d_parentMouseListener = new ParentMouseListener();
            ActionListener closeAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setVisible(false);
                }
            };
            this.getRootPane().registerKeyboardAction(closeAction, KeyStroke.getKeyStroke(27, 0), 1);
        }

        @Override
        public void setVisible(boolean b) {
            ControlPnl pnl = this.findPanel();
            if (b) {
                for (Component comp : this.getParentComponents()) {
                    comp.addMouseListener(this.d_parentMouseListener);
                }
                if (pnl != null) {
                    pnl.d_currentPopup = this;
                }
            }
            super.setVisible(b);
            if (!b) {
                if (pnl != null) {
                    pnl.d_currentPopup = null;
                }
                for (Component comp : this.getParentComponents()) {
                    comp.removeMouseListener(this.d_parentMouseListener);
                }
                this.dispose();
            }
        }

        private class ParentMouseListener
        extends MouseAdapter {
            private ParentMouseListener() {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getComponent() instanceof guiDialog.OkBtn || e.getComponent() instanceof guiDialog.ApplyBtn) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PopupWindow.this.setVisible(false);
                    }
                });
            }
        }
    }

    private static class StatementPnl
    extends guiPanel {
        private static final long serialVersionUID = -7029267888767815815L;
        private static final String CUSTOM_CARD = Intl.intl("Custom");
        private static final String TIME_CARD = Intl.intl("Time");
        private final ControlPnl d_ctrlPnl;
        private boolean d_modified = false;
        private final JEditorPane d_editor;
        private final JTextArea d_customEditor;
        private final DocumentListener d_customListener;
        private final JScrollPane d_customSP;
        private final TimeActivationPanel d_timePnl;
        private final guiPanel d_customPnl;
        private final guiCheckBox d_linkWithModelCB;
        private final ControlDesc d_desc;
        private ControlDesc.SinkType d_sinkType = ControlDesc.SinkType.ACTIVATE;
        private Set<ISignalSink> d_sinks = null;
        private Set<ILogicOutPin> d_logicPins = null;
        private SortCache<IDoubleOutPin> d_msrPins = null;
        private List<String> d_customCtrlNames = null;

        public StatementPnl(ControlPnl ctrlPnl, boolean displaySinks) {
            super(new GridBagLayout());
            this.d_ctrlPnl = ctrlPnl;
            this.d_desc = new ControlDesc(true, displaySinks);
            this.d_editor = new JEditorPane("text/html", "");
            this.d_editor.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    this.hyperlinkSelected(e);
                }
            });
            this.d_editor.setEditable(false);
            JScrollPane sp = new JScrollPane(this.d_editor);
            this.d_linkWithModelCB = new guiCheckBox("<html>" + Intl.intl("Synchronize entered controls with model<br>(PyroSim may slightly alter the controls).") + "</html>");
            this.d_customPnl = new guiPanel(new GridBagLayout());
            guiLabel customLbl = new guiLabel(Intl.intl("Enter FDS CTRL Records:"));
            this.d_customEditor = new JTextArea();
            this.d_customEditor.setEditable(true);
            this.d_customEditor.setFont(this.d_editor.getFont());
            this.d_customSP = new JScrollPane(this.d_customEditor);
            GridBagUtil.add(this.d_customPnl, this.d_linkWithModelCB, 0, 0, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this.d_customPnl, customLbl, 0, 1, 1, 1, 6, 0, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_customPnl, this.d_customSP, 0, 2, 1, 1, 6, 0, 6, 0, 1, 1.0, 1.0, 10);
            this.d_timePnl = new TimeActivationPanel();
            GridBagUtil.add(this, this.d_customPnl, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 0.75, 10);
            GridBagUtil.add(this, sp, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1.0, 0.25, 10);
            GridBagUtil.add(this, this.d_timePnl, 0, 2, 1, 1, 6, 0, 0, 0, 1, 1.0, 0.75, 10);
            sp.setPreferredSize(new Dimension(300, 150));
            this.d_customSP.setPreferredSize(new Dimension(200, 150));
            this.d_timePnl.setPreferredSize(new Dimension(200, 150));
            this.d_customListener = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changed();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changed();
                }

                private void changed() {
                    int search;
                    d_customCtrlNames = null;
                    List names = this.getCustomCtrlNames();
                    if (((StatementPnl)this).d_desc.d_customCtrlName != null && (search = theUtil.binarySearch(names, ((StatementPnl)this).d_desc.d_customCtrlName, StatementPnl.newNameComparator())) < 0) {
                        d_desc.setCustomCtrlName(null);
                        this.changed();
                    }
                    if (((StatementPnl)this).d_desc.d_customCtrlName == null && names.size() > 0) {
                        d_desc.setCustomCtrlName((String)names.iterator().next());
                        this.changed();
                    }
                    this.changed();
                }
            };
            this.d_customEditor.getDocument().addDocumentListener(this.d_customListener);
        }

        private static Comparator<String> newNameComparator() {
            return new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            };
        }

        private static boolean isValidCustomRec(FDSRecord rec) {
            return rec.getType().equals("CTRL") || rec.getType().equals("RAMP") || rec.getType().equals("TABL") || rec.getType().equals("DEVC") && "TIME".equals(rec.getString("QUANTITY"));
        }

        private void showSimplifiedWarnings(FDSWarningReport fullReport) {
            WarningReport<FDSParseWarning> simpleWarnings = new WarningReport<FDSParseWarning>(FDSParseWarning.class, new int[]{2, 0}, new String[]{Intl.intl("Line"), Intl.intl("Warning")}, 2);
            for (FDSParseWarning warning : fullReport.getWarnings()) {
                simpleWarnings.addWarning(warning);
            }
            WarningDlg dlg = WarningDlg.create(this, Intl.intl("FDS Warnings"), Intl.intl("The following table lists some problems reading the FDS controls."), simpleWarnings);
            dlg.doModal();
        }

        private IOutPin parseCustomControl(boolean showWarn) {
            if (this.d_desc.d_input != 3) {
                return null;
            }
            if (this.d_desc.d_customCtrlName == null) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(this, Intl.intl("At least one CTRL record with a valid ID must be specified."), Intl.intl("No CTRL Found"), 0);
                }
                return null;
            }
            if (!this.d_linkWithModelCB.isSelected()) {
                ManualCtrl ctrl = new ManualCtrl(this.d_customEditor.getText(), this.d_desc.d_customCtrlName);
                return ctrl.getOutputPins().get(0);
            }
            FDSWarningReport warnings = new FDSWarningReport();
            try {
                List<FDSParseRecord> recs = this.getCustomRecords(warnings);
                if (showWarn && !warnings.isEmpty()) {
                    this.showSimplifiedWarnings(warnings);
                }
                for (FDSParseRecord rec : recs) {
                    if (StatementPnl.isValidCustomRec(rec)) continue;
                    if (showWarn) {
                        JOptionPane.showMessageDialog(this, Intl.intl("Only enter records of type CTRL and RAMP.  You may additionally specify\nDEVC records if the QUANTITY is \"TIME\"."), Intl.intl("Invalid Custom Records"), 0);
                    }
                    return null;
                }
                FDS6Parser parser = new FDS6Parser();
                PyroMod tempMod = new PyroMod();
                FDSParseResult result = parser.parseRecords(recs, tempMod, PyroSim.getApp().getMediator());
                if (showWarn && !result.warningReport.isEmpty()) {
                    this.showSimplifiedWarnings(result.warningReport);
                }
                ControlBridge ctrlFound = null;
                for (ControlBridge ctrl : theUtil.filter(result.extractedObjs, ControlBridge.class)) {
                    if (!ctrl.getName().equals(this.d_desc.d_customCtrlName)) continue;
                    ctrlFound = ctrl;
                    break;
                }
                if (ctrlFound == null || ctrlFound.getInputPin().getConnections().isEmpty()) {
                    if (showWarn) {
                        JOptionPane.showMessageDialog(this, String.format(Intl.intl("The specified CTRL, \"%s\", is invalid."), this.d_desc.d_customCtrlName), Intl.intl("Specified CTRL Invalid"), 0);
                    }
                    return null;
                }
                return ctrlFound.getInputPin().getConnections().iterator().next();
            }
            catch (Exception e) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(this, e.getMessage(), Intl.intl("FDS Format Error"), 0);
                }
                return null;
            }
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (!this.d_desc.validateData(this, this.d_sinkType, showWarn, allowModify)) {
                return false;
            }
            if (this.d_desc.d_input == 3) {
                IOutPin pin = this.parseCustomControl(showWarn);
                return pin != null;
            }
            return true;
        }

        private void setSinkType(ControlDesc.SinkType sinkType) {
            this.d_sinkType = sinkType;
            this.d_timePnl.setSinkType(sinkType);
        }

        public void load(IInPin inPin) {
            AControl ctrl;
            ISignalSource src;
            this.d_desc.load(inPin);
            if (this.d_desc.d_action == 2 && this.d_desc.d_input == 0) {
                assert (inPin.getConnections().size() == 1);
                src = inPin.getConnectedSources().iterator().next();
                assert (src instanceof CustomCtrl);
                ctrl = (CustomCtrl)src;
                assert (((CustomCtrl)ctrl).getInputPin().getConnections().size() == 1);
                ISignalSource ctrlSrc = ((CustomCtrl)ctrl).getInputPin().getConnectedSources().iterator().next();
                assert (ctrlSrc instanceof Clock);
                this.d_timePnl.load((CustomCtrl)ctrl, false, new UnitDouble(0.0, SI.SECOND));
            }
            if (inPin.getConnections().size() == 1) {
                src = inPin.getConnectedSources().iterator().next();
                if (src instanceof ManualCtrl) {
                    this.d_linkWithModelCB.setSelected(false);
                    ctrl = (ManualCtrl)src;
                    this.d_desc.setCustomCtrlName(ctrl.getName());
                    this.d_customEditor.getDocument().removeDocumentListener(this.d_customListener);
                    this.d_customEditor.setText(((ManualCtrl)ctrl).getFDSText());
                    this.d_customEditor.getDocument().addDocumentListener(this.d_customListener);
                } else {
                    this.d_linkWithModelCB.setSelected(true);
                    FDS6Renderer rend = new FDS6Renderer(PyroSim.getApp().getMediator(), PyroSim.getApp().getFDSRenderProps(), FDSRenderer.RENDER_ORIGIN.DEFAULT);
                    FDSRecordCollector collector = new FDSRecordCollector(rend.getProps());
                    rend.renderObjects(collector, Arrays.asList(inPin.getAttachedSink()), Collections.EMPTY_MAP);
                    StringPrintWriter writer = new StringPrintWriter();
                    for (FDSRenderRecord rec : collector.getRecords()) {
                        if (!StatementPnl.isValidCustomRec(rec)) continue;
                        rec.renderRecord(writer, rend.getProps(), DefaultFieldRenderer.INSTANCE);
                    }
                    String rendered = writer.toString();
                    this.d_customEditor.setText(rendered);
                    String name = src instanceof INamed ? ((INamed)((Object)src)).getName() : null;
                    this.d_desc.setCustomCtrlName(name);
                }
            } else {
                this.d_linkWithModelCB.setSelected(false);
                this.d_customEditor.setText("");
                this.d_desc.setCustomCtrlName(null);
            }
        }

        public IOutPin save() {
            IOutPin opin = this.d_desc.save();
            if (opin != null) {
                return opin;
            }
            if (this.d_desc.d_input == 0 && this.d_desc.d_action == 2) {
                return this.d_timePnl.save();
            }
            if (this.d_desc.d_input == 3) {
                return this.parseCustomControl(false);
            }
            return null;
        }

        public boolean isDataValid(int objType, int action, int input) {
            if (input == 1) {
                return !this.getLogicPins().isEmpty();
            }
            if (input == 2) {
                return this.getMsrPins().size() > 0;
            }
            return true;
        }

        private void changed() {
            this.updateMessage();
            this.setModified(true);
        }

        private void setData(int action, int input) {
            this.d_desc.setData(action, input);
            this.d_customPnl.setVisible(input == 3);
            this.d_timePnl.setVisible(input == 0 && action == 2);
            this.changed();
            this.updateMessage();
        }

        @Override
        public boolean isModified() {
            return super.isModified() || this.d_modified;
        }

        @Override
        public void setModified(boolean modified) {
            this.d_modified = modified;
            super.setModified(modified);
        }

        private void updateMessage() {
            String msg = this.d_desc.formatMessage(this.d_sinkType);
            this.d_editor.setText(msg);
            this.d_editor.setEnabled(this.d_desc.d_input != 3 || !this.getCustomCtrlNames().isEmpty());
        }

        private void hyperlinkSelected(HyperlinkEvent evt) {
            if (!this.isEnabled()) {
                return;
            }
            String id = evt.getDescription();
            Rectangle caretLoc = null;
            if (evt.getSourceElement() == null) {
                return;
            }
            try {
                caretLoc = this.d_editor.modelToView(evt.getSourceElement().getStartOffset());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                Point loc = new Point(this.d_editor.getLocationOnScreen());
                loc.x += caretLoc.x;
                loc.y += caretLoc.y + caretLoc.height;
                if (id.equals("LOGIC")) {
                    this.selectLogic(loc);
                } else if (id.equals("ACTIVATE")) {
                    this.selectActivate(loc);
                } else if (id.equals("N")) {
                    this.selectN(loc);
                } else if (id.equals("T")) {
                    this.selectT(loc);
                } else if (id.equals("DBLOWERV")) {
                    this.selectDBBound(loc, true);
                } else if (id.equals("DBUPPERV")) {
                    this.selectDBBound(loc, false);
                } else if (id.equals("DBLOWERL")) {
                    this.selectDBLogic(loc, true);
                } else if (id.equals("DBUPPERL")) {
                    this.selectDBLogic(loc, false);
                } else if (id.equals("DETSOURCES")) {
                    this.selectDetectorSources(loc);
                } else if (id.equals("MSRSOURCES")) {
                    this.selectMeasurerSource(loc);
                } else if (id.equals("SINKS")) {
                    this.selectSinks(loc);
                } else if (id.equals("DELAY")) {
                    this.selectDelay(loc);
                } else if (id.equals("CUSTOMINPUT")) {
                    this.selectCustomInput(loc);
                }
            }
        }

        private Set<ISignalSink> getSinks() {
            if (this.d_sinks != null) {
                return this.d_sinks;
            }
            this.beginWaitCursor();
            PyroMod domain = PyroSim.getApp().getMediator();
            this.d_sinks = new TreeSet<ISignalSink>(new Comparator<ISignalSink>(){

                @Override
                public int compare(ISignalSink o1, ISignalSink o2) {
                    int compare = ControlDesc.getName(o1).compareToIgnoreCase(ControlDesc.getName(o2));
                    if (compare != 0) {
                        return compare;
                    }
                    return Integer.compare(System.identityHashCode(o1), System.identityHashCode(o2));
                }
            });
            for (ISignalSink sink : Hierarchy.flatten(domain.getMembers(), ISignalSink.class)) {
                if (sink instanceof IControl || sink instanceof IHvacObject || !(sink.getInputPin() instanceof ILogicInPin)) continue;
                this.d_sinks.add(sink);
            }
            this.endWaitCursor();
            return this.d_sinks;
        }

        private void selectSinks(Point loc) {
            if (this.d_desc.d_dstObjNames != null) {
                return;
            }
            Set<ISignalSink> sinks = this.getSinks();
            if (sinks.isEmpty()) {
                return;
            }
            MultiSelectHelperWindow wnd = this.createHelperWindow(MultiSelectHelperWindow.class);
            wnd.initAllObjs(sinks);
            wnd.init(loc, this.d_desc.d_dstObjs, new MultiSelectHelperWindow.Callback<ISignalSink>(){

                @Override
                public void select(List<ISignalSink> val) {
                    ControlDesc.SinkType sinkType = ControlDesc.getSinkType(val);
                    d_desc.setSinks(val);
                    d_ctrlPnl.setSinkType(sinkType);
                    this.changed();
                }
            });
        }

        private Set<ILogicOutPin> getLogicPins() {
            if (this.d_logicPins != null) {
                return this.d_logicPins;
            }
            this.beginWaitCursor();
            PyroMod domain = PyroSim.getApp().getMediator();
            this.d_logicPins = new TreeSet<ILogicOutPin>(new Comparator<ILogicOutPin>(){

                @Override
                public int compare(ILogicOutPin o1, ILogicOutPin o2) {
                    return ControlDesc.getName(o1).compareToIgnoreCase(ControlDesc.getName(o2));
                }
            });
            for (IDevice devc : domain.getDevices().flatten()) {
                if (!(devc instanceof ISignalSource)) continue;
                for (IOutPin iOutPin : ((ISignalSource)((Object)devc)).getOutputPins()) {
                    if (!(iOutPin instanceof ILogicOutPin)) continue;
                    this.d_logicPins.add((ILogicOutPin)iOutPin);
                }
            }
            this.endWaitCursor();
            return this.d_logicPins;
        }

        private void selectDetectorSources(Point loc) {
            Set<ILogicOutPin> logicPins = this.getLogicPins();
            if (logicPins.isEmpty()) {
                return;
            }
            MultiSelectHelperWindow wnd = this.createHelperWindow(MultiSelectHelperWindow.class);
            wnd.initAllObjs(logicPins);
            wnd.init(loc, this.d_desc.d_srcDetectors, new MultiSelectHelperWindow.Callback<ILogicOutPin>(){

                @Override
                public void select(List<ILogicOutPin> val) {
                    d_desc.setSources(val);
                    this.changed();
                }
            });
        }

        private SortCache<IDoubleOutPin> getMsrPins() {
            if (this.d_msrPins != null) {
                return this.d_msrPins;
            }
            this.beginWaitCursor();
            ArrayList<IDoubleOutPin> pins = new ArrayList<IDoubleOutPin>();
            PyroMod domain = PyroSim.getApp().getMediator();
            for (IDevice devc : domain.getDevices().flatten()) {
                if (!(devc instanceof ISignalSource)) continue;
                for (IOutPin iOutPin : ((ISignalSource)((Object)devc)).getOutputPins()) {
                    if (!(iOutPin instanceof IDoubleOutPin)) continue;
                    pins.add((IDoubleOutPin)iOutPin);
                }
            }
            this.d_msrPins = new SortCache<IDoubleOutPin>(pins, new Comparator<IDoubleOutPin>(){

                @Override
                public int compare(IDoubleOutPin o1, IDoubleOutPin o2) {
                    return ControlDesc.getName(o1).compareToIgnoreCase(ControlDesc.getName(o2));
                }
            });
            this.endWaitCursor();
            return this.d_msrPins;
        }

        private void selectMeasurerSource(Point loc) {
            final SortCache<IDoubleOutPin> msrPins = this.getMsrPins();
            if (msrPins.size() == 0) {
                return;
            }
            ListHelperWindow wnd = this.newListHelperWindow();
            int[] vals = new int[msrPins.size()];
            for (int m = 0; m < vals.length; ++m) {
                vals[m] = m;
            }
            String[] names = new String[msrPins.size()];
            for (int m = 0; m < names.length; ++m) {
                names[m] = ControlDesc.getName(msrPins.get(m));
            }
            int iniSel = this.d_desc.d_srcMeasurer == null ? -1 : msrPins.indexOf(this.d_desc.d_srcMeasurer);
            wnd.init(loc, true, iniSel, vals, names, new ListHelperWindow.Callback(){

                @Override
                public void select(int ix) {
                    IDoubleOutPin newPin = ix >= 0 ? (IDoubleOutPin)msrPins.get(ix) : null;
                    d_desc.setSourceMeasurer(newPin);
                    this.changed();
                }
            });
        }

        private List<FDSParseRecord> getCustomRecords(FDSWarningReport warnings) throws FDSParseException {
            return FDSGrammar.parse(this.d_customEditor.getText(), null, warnings, FDS6Const.getRecordSpecs(), "TAIL");
        }

        private List<String> getCustomCtrlNames() {
            if (this.d_customCtrlNames != null) {
                return this.d_customCtrlNames;
            }
            TreeSet<String> names = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
            try {
                FDSWarningReport warnings = new FDSWarningReport();
                ArrayList<String> allNames = new ArrayList<String>();
                HashSet refedNames = new HashSet();
                List<FDSParseRecord> records = this.getCustomRecords(warnings);
                for (FDSParseRecord rec : records) {
                    String id;
                    if (rec.getType().equals("CTRL")) {
                        List inputids;
                        id = rec.getString("ID");
                        if (id != null) {
                            allNames.add(id);
                        }
                        if ((inputids = rec.getList("INPUT_ID", true)) == null) continue;
                        refedNames.addAll(inputids);
                        continue;
                    }
                    if (!rec.getType().equals("DEVC") || !"TIME".equals(rec.getString("QUANTITY")) || (id = rec.getString("ID")) == null) continue;
                    allNames.add(id);
                }
                for (String name : allNames) {
                    if (refedNames.contains(name)) continue;
                    names.add(name);
                }
            }
            catch (Exception e) {
                return Collections.EMPTY_LIST;
            }
            this.d_customCtrlNames = new ArrayList<String>(names);
            return this.d_customCtrlNames;
        }

        private void selectCustomInput(Point loc) {
            List<String> ctrlNames = this.getCustomCtrlNames();
            final String[] names = ctrlNames.toArray(new String[ctrlNames.size()]);
            int[] vals = new int[ctrlNames.size()];
            int iniSel = -1;
            for (int m = 0; m < names.length; ++m) {
                vals[m] = m;
                if (!names[m].equals(this.d_desc.d_customCtrlName)) continue;
                iniSel = m;
            }
            ListHelperWindow wnd = this.newListHelperWindow();
            wnd.init(loc, true, iniSel, vals, names, new ListHelperWindow.Callback(){

                @Override
                public void select(int val) {
                    if (val == -1) {
                        d_desc.setCustomCtrlName(null);
                    } else {
                        d_desc.setCustomCtrlName(names[val]);
                    }
                    this.changed();
                }
            });
        }

        private void selectDelay(Point loc) {
            ValueFieldHelperWindow<UnitDouble> wnd = this.newVFHelperWindow();
            ValueField<UnitDouble> fld = ValueFields.udFld(this.d_desc.d_delay, UnitDoubleVR.above(0.0, SI.SECOND, true), UnitSystem.getSource(2));
            wnd.init(loc, fld, new ValueFieldHelperWindow.Callback<UnitDouble>(){

                @Override
                public void select(UnitDouble val) {
                    d_desc.setDelay(val);
                    this.changed();
                }
            });
        }

        private void selectDBLogic(Point loc, final boolean lower) {
            ListHelperWindow wnd = this.newListHelperWindow();
            String[] names = new String[]{this.d_sinkType.strings.on, this.d_sinkType.strings.off};
            int[] vals = new int[]{1, 0};
            boolean iniVal = lower ? !this.d_desc.d_dbUpper : this.d_desc.d_dbUpper;
            int iniSel = iniVal ? 1 : 0;
            wnd.init(loc, false, iniSel, vals, names, new ListHelperWindow.Callback(){

                @Override
                public void select(int val) {
                    boolean newval = val == 1;
                    d_desc.setDBLogic(newval, lower);
                    this.changed();
                }
            });
        }

        private void selectDBBound(Point loc, final boolean lower) {
            ValueFieldHelperWindow<UnitDouble> wnd = this.newVFHelperWindow();
            UnitDouble val = lower ? this.d_desc.d_dbRange[0] : this.d_desc.d_dbRange[1];
            ValueField<UnitDouble> fld = ValueFields.udFld(val, UnitSystem.getSource(this.d_desc.d_dbRangeType));
            wnd.init(loc, fld, new ValueFieldHelperWindow.Callback<UnitDouble>(){

                @Override
                public void select(UnitDouble val) {
                    d_desc.setDBBound(val, lower);
                    this.changed();
                }
            });
        }

        private void selectLogic(Point loc) {
            ListHelperWindow wnd = this.newListHelperWindow();
            String[] names = new String[]{Intl.intl("any"), Intl.intl("all"), Intl.intl("at least n"), Intl.intl("no more than n"), Intl.intl("exactly n")};
            int[] vals = new int[]{0, 1, 2, 3, 4};
            wnd.init(loc, false, this.d_desc.d_logicType, vals, names, new ListHelperWindow.Callback(){

                @Override
                public void select(int val) {
                    d_desc.setLogicType(val);
                    this.changed();
                }
            });
        }

        private void selectActivate(Point loc) {
            ListHelperWindow wnd = this.newListHelperWindow();
            String[] names = new String[]{Intl.intl("activate"), Intl.intl("deactivate")};
            int[] vals = new int[]{1, 0};
            wnd.init(loc, false, this.d_desc.d_sourceActivates ? 1 : 0, vals, names, new ListHelperWindow.Callback(){

                @Override
                public void select(int val) {
                    d_desc.setSourceActivates(val == 1);
                    this.changed();
                }
            });
        }

        private void selectN(Point loc) {
            ValueFieldHelperWindow<Integer> wnd = this.newVFHelperWindow();
            ValueField<Integer> fld = ValueFields.intFld(this.d_desc.d_n, IntVR.above(1, true));
            wnd.init(loc, fld, new ValueFieldHelperWindow.Callback<Integer>(){

                @Override
                public void select(Integer val) {
                    d_desc.setN(val);
                    this.changed();
                }
            });
        }

        private void selectT(Point loc) {
            ValueFieldHelperWindow<UnitDouble> wnd = this.newVFHelperWindow();
            ValueField<UnitDouble> fld = ValueFields.udFld(new UnitDouble(0.0, SI.SECOND), UnitSystem.getSource(2));
            fld.setNullAllowed(true);
            ValueFields.getFormat(fld).alias(null, ControlDesc.TBEGIN);
            fld.setValue(this.d_desc.d_t);
            wnd.init(loc, fld, new ValueFieldHelperWindow.Callback<UnitDouble>(){

                @Override
                public void select(UnitDouble val) {
                    d_desc.setT(val);
                    this.changed();
                }
            });
        }

        private <T> ValueFieldHelperWindow<T> newVFHelperWindow() {
            return this.createHelperWindow(ValueFieldHelperWindow.class);
        }

        private ListHelperWindow newListHelperWindow() {
            return this.createHelperWindow(ListHelperWindow.class);
        }

        private PopupWindow newHelperWindow() {
            return this.createHelperWindow(PopupWindow.class);
        }

        private <T extends PopupWindow> T createHelperWindow(Class<T> clazz) {
            Component parent = Utils.findParentWindow(this);
            try {
                if (parent instanceof Frame) {
                    return (T)((PopupWindow)clazz.getConstructor(Frame.class).newInstance((Frame)parent));
                }
                if (parent instanceof Window) {
                    return (T)((PopupWindow)clazz.getConstructor(Window.class).newInstance((Window)parent));
                }
                return (T)((PopupWindow)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    private static class TimeActivationPanel
    extends guiPanel {
        private static final long serialVersionUID = 7479791470275231189L;
        private final guiTable d_table;
        private ControlDesc.SinkType d_sinkType = ControlDesc.SinkType.ACTIVATE;

        public TimeActivationPanel() {
            Unit tunit = PyroSim.getApp().getUnitSystem().getTimeUnit();
            String[] columnHeaders = new String[]{String.format(Intl.intl("Time (%s)"), tunit), Intl.intl("Event")};
            Class[] columnClasses = new Class[]{UnitDouble.class, String.class};
            this.d_table = guiTableUtil.fixedColumnTable(columnHeaders, columnClasses);
            guiTableEditor editor = new guiTableEditor(this.d_table, 0);
            this.d_table.getColumnModel().getColumn(0).setCellEditor(new guiTable.UnitDoubleEditor(tunit));
            this.d_table.setColumnOptions(1, new Activation(true), new Activation(false));
            this.setLayout(new BorderLayout());
            this.add((Component)editor, "Center");
        }

        private Map<UnitDouble, Boolean> parseTimes() {
            TreeMap<UnitDouble, Boolean> timeMap = new TreeMap<UnitDouble, Boolean>();
            for (int m = 0; m < this.d_table.getRowCount(); ++m) {
                UnitDouble v = (UnitDouble)this.d_table.getValueAt(m, 0);
                Activation act = (Activation)this.d_table.getValueAt(m, 1);
                if (v == null || act == null) continue;
                timeMap.put(v, act.value);
            }
            return timeMap;
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!this.isVisible()) {
                return true;
            }
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            Map<UnitDouble, Boolean> timeMap = this.parseTimes();
            if (timeMap.isEmpty()) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(Utils.findParentWindow(this), Intl.intl("You must enter at least one timed event."), Intl.intl("Missing Time Events"), 0);
                }
                return false;
            }
            return true;
        }

        public void setSinkType(ControlDesc.SinkType sinkType) {
            this.d_sinkType = sinkType;
            this.repaint();
        }

        public void load(CustomCtrl ctrl, boolean invert, UnitDouble delay) {
            boolean lastState = ctrl.getInitialState() ^ invert;
            int row = 0;
            this.d_table.clearRows();
            for (UnitDouble val : ctrl.getTripValues()) {
                boolean currentState = !lastState;
                UnitDouble time = val.add(delay);
                this.d_table.getModel().setValueAt(time, row, 0);
                this.d_table.getModel().setValueAt(new Activation(currentState), row, 1);
                ++row;
                lastState = currentState;
            }
            this.d_table.repaint();
        }

        public ILogicOutPin save() {
            boolean initiallyOn;
            Map<UnitDouble, Boolean> timeMap = this.parseTimes();
            if (timeMap.isEmpty()) {
                return null;
            }
            Iterator<Map.Entry<UnitDouble, Boolean>> entryit = timeMap.entrySet().iterator();
            boolean lastActivate = entryit.next().getValue();
            while (entryit.hasNext()) {
                Map.Entry<UnitDouble, Boolean> next = entryit.next();
                if (next.getValue() == lastActivate) {
                    entryit.remove();
                    continue;
                }
                lastActivate = next.getValue();
            }
            boolean bl = initiallyOn = timeMap.values().iterator().next() == false;
            if (timeMap.size() == 1) {
                Timer timer = new Timer(timeMap.keySet().iterator().next(), initiallyOn);
                return (ILogicOutPin)timer.getOutputPins().get(0);
            }
            CustomCtrl ctrl = new CustomCtrl(initiallyOn, timeMap.keySet());
            Clock clock = Clock.INSTANCE;
            ctrl.getInputPin().connect(clock.getOutputPins().get(0));
            return (ILogicOutPin)ctrl.getOutputPins().get(0);
        }

        private class Activation {
            public final boolean value;

            public Activation(boolean value) {
                this.value = value;
            }

            public String toString() {
                return this.value ? ((TimeActivationPanel)TimeActivationPanel.this).d_sinkType.strings.activate : ((TimeActivationPanel)TimeActivationPanel.this).d_sinkType.strings.deactivate;
            }
        }
    }

    private static class InputPnl
    extends guiPanel {
        private static final long serialVersionUID = -6224895310993658138L;
        private guiRadioButton d_timeBtn = new guiRadioButton(Intl.intl("Time"));
        private guiRadioButton d_detectorBtn = new guiRadioButton(Intl.intl("Detector"));
        private guiRadioButton d_thermostatBtn = new guiRadioButton(Intl.intl("Deadband Control (e.g. Thermostat)"));
        private guiRadioButton d_customBtn = new guiRadioButton(Intl.intl("Custom"));

        public InputPnl() {
            super(new GridBagLayout());
            TitleSeparator ts = new TitleSeparator(Intl.intl("Input Type"));
            new guiButtonGroup(this.d_timeBtn, this.d_detectorBtn, this.d_thermostatBtn, this.d_customBtn);
            this.d_timeBtn.setSelected(true);
            int row = 0;
            GridBagUtil.add(this, ts, 0, ++row, 2, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this, this.d_timeBtn, 0, ++row, 2, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_detectorBtn, 0, ++row, 1, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_thermostatBtn, 0, ++row, 1, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_customBtn, 0, ++row, 1, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
        }

        public void addListener(ActionListener list) {
            this.d_timeBtn.addActionListener(list);
            this.d_detectorBtn.addActionListener(list);
            this.d_thermostatBtn.addActionListener(list);
            this.d_customBtn.addActionListener(list);
        }

        public void setValue(int value) {
            switch (value) {
                case 0: {
                    this.d_timeBtn.setSelected(true);
                    break;
                }
                case 1: {
                    this.d_detectorBtn.setSelected(true);
                    break;
                }
                case 2: {
                    this.d_thermostatBtn.setSelected(true);
                    break;
                }
                default: {
                    this.d_customBtn.setSelected(true);
                }
            }
        }

        public int getValue() {
            if (this.d_timeBtn.isSelected()) {
                return 0;
            }
            if (this.d_detectorBtn.isSelected()) {
                return 1;
            }
            if (this.d_thermostatBtn.isSelected()) {
                return 2;
            }
            return 3;
        }
    }

    private static class ActionPnl
    extends guiPanel {
        private static final long serialVersionUID = -3606489502740766100L;
        private guiRadioButton d_createBtn = new guiRadioButton();
        private guiRadioButton d_removeBtn = new guiRadioButton();
        private guiRadioButton d_multipleBtn = new guiRadioButton(Intl.intl("Multiple"));

        public ActionPnl() {
            super(new GridBagLayout());
            TitleSeparator ts = new TitleSeparator(Intl.intl("Action to Perform"));
            new guiButtonGroup(this.d_createBtn, this.d_removeBtn, this.d_multipleBtn);
            int row = 0;
            GridBagUtil.add(this, ts, 0, ++row, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this, this.d_createBtn, 0, ++row, 1, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_removeBtn, 0, ++row, 1, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_multipleBtn, 0, ++row, 1, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
        }

        public void setInput(int input) {
            this.setVisible(input != 3 && input != 2);
            if (this.isVisible()) {
                this.d_createBtn.setVisible(input == 0 || input == 1);
                this.d_removeBtn.setVisible(this.d_createBtn.isVisible());
                this.d_multipleBtn.setVisible(input == 0 || input == 2);
                if (!this.d_multipleBtn.isVisible() && this.d_multipleBtn.isSelected()) {
                    this.d_createBtn.setSelected(true);
                } else if (!this.d_createBtn.isVisible() && this.d_createBtn.isSelected()) {
                    this.d_multipleBtn.setSelected(true);
                } else if (!this.d_removeBtn.isVisible() && this.d_removeBtn.isSelected()) {
                    this.d_multipleBtn.setSelected(true);
                }
            }
        }

        public void addListener(ActionListener list) {
            this.d_createBtn.addActionListener(list);
            this.d_removeBtn.addActionListener(list);
            this.d_multipleBtn.addActionListener(list);
        }

        private void setSinkType(ControlDesc.SinkType sinkType) {
            this.d_createBtn.setText(sinkType.strings.activate);
            this.d_removeBtn.setText(sinkType.strings.deactivate);
        }

        public void setValue(int action) {
            switch (action) {
                case 0: {
                    this.d_createBtn.setSelected(true);
                    break;
                }
                case 1: {
                    this.d_removeBtn.setSelected(true);
                    break;
                }
                case 2: {
                    this.d_multipleBtn.setSelected(true);
                }
            }
        }

        public int getValue() {
            if (this.d_createBtn.isSelected()) {
                return 0;
            }
            if (this.d_removeBtn.isSelected()) {
                return 1;
            }
            if (this.d_multipleBtn.isSelected()) {
                return 2;
            }
            return -1;
        }
    }
}

