/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.controls;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.ControlMgr;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.RenameAction;
import pyrosim.gui.controls.ControlPnl;
import pyrosim.gui.controls.NewControlDlg;
import thunderheadeng.gui.guiAction;

public class ControlDlg
extends ManagerDlg<ControlBridge, ControlMgr> {
    private static final long serialVersionUID = 4918905546175464825L;
    private final ControlPnl d_controlPnl;
    private ControlMgr d_mgr;
    private final Action[] d_actions;
    private final Action d_new = new NewAction();
    private final Action d_rename = new RenameAction<ControlBridge, ControlMgr>(this, Intl.intl("control"));
    private final Action d_delete = new ManagerDlg.DeleteAction(this);

    public ControlDlg(JFrame owner) {
        super(owner, Intl.intl("Activation Controls"), false);
        this.d_actions = new Action[]{this.d_new, this.d_rename, this.d_delete};
        this.d_controlPnl = new ControlPnl();
        this.setResizable(true);
    }

    private void updateActions() {
        int selIx = this.getList().getSelectedIx();
        this.d_new.setEnabled(this.d_mgr != null);
        this.d_rename.setEnabled(this.d_mgr != null && selIx > -1);
        this.d_delete.setEnabled(this.d_mgr != null && selIx > -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        super.valueChanged(evt);
        this.updateActions();
    }

    public void init(ControlMgr mgr, ControlBridge init) {
        this.d_mgr = mgr;
        ((RenameAction)this.d_rename).init(mgr);
        super.init(this.d_mgr, this.d_controlPnl, this.d_actions, init);
        this.updateActions();
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = 5944064610703301296L;

        public NewAction() {
            super(Intl.intl("New") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            NewControlDlg dlg;
            if (!ControlDlg.this.preSave()) {
                return;
            }
            int selIx = ControlDlg.this.getList().getSelectedIx();
            ControlBridge ctrl = null;
            if (selIx >= 0) {
                ctrl = (ControlBridge)ControlDlg.this.getList().getItem(selIx);
            }
            if ((dlg = new NewControlDlg(ControlDlg.this.d_mgr)).doModal() == 1) {
                ctrl = new ControlBridge(dlg.getName());
                PyroMod domain = (PyroMod)ControlDlg.this.d_mgr.getDomain();
                AddTask t = new AddTask((IPyroObject)ControlDlg.this.d_mgr, new IPyroObject[]{ctrl});
                SelectTask wrapper = new SelectTask(domain, ctrl);
                wrapper.addTask(t);
                domain.getTaskManager().exec(wrapper, Intl.intl("New Control"));
                ControlDlg.this.getList().updateModelView(ControlDlg.this.d_mgr);
                ControlDlg.this.getList().select(ctrl);
                ControlDlg.this.d_controlPnl.getEditorPanel().setModified(false);
                ControlDlg.this.updateActions();
            }
        }
    }
}

