/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.comboboxes;

import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.gui.comboboxes.PyroComboBox;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;

public class SurfaceComboBox
extends PyroComboBox<Surface> {
    private static final long serialVersionUID = 7715103452632457968L;

    public SurfaceComboBox(SurfaceManager surfMgr, Surface defaultSurf) {
        super((IPyroObject)surfMgr, defaultSurf, Surface.class);
    }

    @Override
    protected ListCellRenderer createRenderer() {
        return new MaterialCellRenderer();
    }

    private class MaterialCellRenderer
    extends PyroComboBox.UniqueObjCBRenderer {
        private static final long serialVersionUID = 816828011858960319L;
        private Font d_predefFont = new Font("Sans Serif", 0, 11);
        private Font d_normalFont = new Font("Sans Serif", 1, 11);

        private MaterialCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            Surface surf = (Surface)value;
            if (surf == null) {
                return this;
            }
            if (surf.isPredefined()) {
                this.setFont(this.d_predefFont);
            } else {
                this.setFont(this.d_normalFont);
            }
            TVEntryPoint<Surface> ep = TVEntryPoints.ep(surf);
            if (ep != null) {
                Icon[] icons = ep.getIcons(PyroSim.getApp().getMediator(), surf);
                this.setIcon(icons[0]);
                this.setDisabledIcon(icons[1]);
            }
            this.setEnabled(SurfaceComboBox.this.isEnabled());
            return this;
        }
    }
}

