/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.appearance;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.appearance.Material;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.appearance.MaterialDlg;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;
import thunderheadeng.util.ObservableProxy;

public class MaterialBtn
extends JButton
implements Modifiable,
IObservable,
ActionListener {
    private static final long serialVersionUID = 8564764994813162520L;
    private final boolean d_allowNull;
    private final ObservableProxy d_helper;
    private boolean d_modified;
    private WeakReference<Material> d_material;
    private boolean d_multiple;

    public MaterialBtn(boolean allowNull) {
        super(Intl.intl("<multiple>"));
        Insets margin = this.getMargin();
        this.setMargin(new Insets(margin.top, 3, margin.bottom, 3));
        this.setPreferredSize(this.getPreferredSize());
        this.setText("");
        this.d_allowNull = allowNull;
        PyroGuiUtil.initButton((AbstractButton)this, (Material)null);
        this.d_helper = new ObservableProxy(this);
        this.d_modified = false;
        this.d_material = new WeakReference<Object>(null);
        this.d_multiple = false;
        this.addActionListener(this);
    }

    @Override
    public void addObserver(IObserver observer, boolean weakRef) {
        this.d_helper.addObserver(observer, weakRef);
    }

    @Override
    public void deleteObserver(IObserver observer) {
        this.d_helper.deleteObserver(observer);
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    @Override
    public void setModified(boolean modified) {
        if (this.d_modified == modified) {
            return;
        }
        this.d_modified = modified;
        if (this.d_modified) {
            this.d_helper.setChanged(true);
        }
    }

    public Material getMaterial() {
        return (Material)this.d_material.get();
    }

    public void setMaterial(Material tex) {
        this.set(tex, false);
    }

    public boolean isMultiple() {
        return this.d_multiple;
    }

    public void setMultiple() {
        this.set(null, true);
    }

    private void set(Material tex, boolean multiple) {
        if (!this.isDifferent(tex, multiple)) {
            return;
        }
        this.d_material = new WeakReference<Material>(tex);
        this.d_multiple = multiple;
        this.updateInfo();
        this.setModified(false);
        this.repaint();
    }

    private boolean isDifferent(Material tex, boolean multiple) {
        if (multiple) {
            return !this.d_multiple;
        }
        return this.d_multiple || this.getMaterial() != tex;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Material newTex;
        PyroMod md = PyroSim.getApp().getMediator();
        Material oldTex = (Material)this.d_material.get();
        MaterialDlg dlg = new MaterialDlg(PyroSim.getApp().getActiveFrame(), Intl.intl("Pick an Appearance"), md.getAppearances(), oldTex, this.d_allowNull);
        if (dlg.doModal() == 1 && this.isDifferent(newTex = dlg.getSelectedEntry(), false)) {
            this.setMaterial(newTex);
            this.setModified(true);
        }
    }

    protected void updateInfo() {
        if (this.isMultiple()) {
            this.setText(Intl.intl("<multiple>"));
            this.setToolTipText(null);
        } else {
            this.setText("");
            Material tex = (Material)this.d_material.get();
            PyroGuiUtil.initButton((AbstractButton)this, tex);
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.d_multiple) {
            return;
        }
        if (g == null) {
            return;
        }
        Graphics scratchGraphics = g.create();
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        int inset = Math.min(insets.left, insets.bottom);
        scratchGraphics.setClip(inset, inset, size.width - inset * 2, size.height - inset * 2);
        PyroGuiUtil.paintComponent((Component)this, scratchGraphics, this.getMaterial());
        scratchGraphics.dispose();
    }
}

