/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Window;
import java.util.Collection;
import java.util.HashSet;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.GeomLocator;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.Vent;
import pyrosim.geom.Geometry;
import pyrosim.gui.actions.ARunFDSValidation;
import pyrosim.io.fds.EnabledFilter;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.units.UnitDouble;

public class VentCollapseValidation
extends ARunFDSValidation {
    public VentCollapseValidation(PyroSim app, PyroMod mod) {
        super(app, mod);
    }

    @Override
    public Collection<IPyroObject> validateModel() {
        GeomLocator geomfinder = this.d_pyroMod.getGeomLocator();
        HashSet<IPyroObject> warnFor = new HashSet<IPyroObject>();
        Collection<Vent> vents = this.d_pyroMod.getObstructions().flatten(Vent.class, new EnabledFilter());
        for (Vent v : vents) {
            AABoxTest test = new AABoxTest(v.getBounds(), 1.0E-5);
            CollResult findResult = new CollResult(Grid.class, new EnabledFilter());
            geomfinder.find(test, findResult, true);
            boolean collapse = findResult.coll.size() > 0;
            for (Grid m : findResult.coll) {
                UnitDouble[] xps = m.getXLinePositions();
                UnitDouble[] yps = m.getYLinePositions();
                UnitDouble[] zps = m.getZLinePositions();
                AABox aa = v.getBounds();
                double minX = aa.getMinX();
                double maxX = aa.getMaxX();
                double minY = aa.getMinY();
                double maxY = aa.getMaxY();
                double minZ = aa.getMinZ();
                double maxZ = aa.getMaxZ();
                double nminX = 0.0;
                double nmaxX = 0.0;
                double nminY = 0.0;
                double nmaxY = 0.0;
                double nminZ = 0.0;
                double nmaxZ = 0.0;
                switch (v.getVentGeom().d_plane) {
                    case 0: {
                        nminY = this.getSnapMin(minY, yps);
                        nmaxY = this.getSnapMax(maxY, yps);
                        nminZ = this.getSnapMin(minZ, zps);
                        nmaxZ = this.getSnapMax(maxZ, zps);
                        collapse &= nmaxY - nminY < 1.0E-9 || nmaxZ - nminZ < 1.0E-9;
                        break;
                    }
                    case 1: {
                        nminX = this.getSnapMin(minX, xps);
                        nmaxX = this.getSnapMax(maxX, xps);
                        nminZ = this.getSnapMin(minZ, zps);
                        nmaxZ = this.getSnapMax(maxZ, zps);
                        collapse &= nmaxX - nminX < 1.0E-9 || nmaxZ - nminZ < 1.0E-9;
                        break;
                    }
                    case 2: {
                        nminY = this.getSnapMin(minY, yps);
                        nmaxY = this.getSnapMax(maxY, yps);
                        nminX = this.getSnapMin(minX, xps);
                        nmaxX = this.getSnapMax(maxX, xps);
                        collapse &= nmaxX - nminX < 1.0E-9 || nmaxY - nminY < 1.0E-9;
                    }
                }
            }
            if (!collapse) continue;
            warnFor.add(v);
        }
        return warnFor;
    }

    private double getSnapMin(double min, UnitDouble[] ps) {
        double result = ps[0].get(Geometry.LU);
        if (min < ps[0].get(Geometry.LU)) {
            return result;
        }
        for (int i = 0; i < ps.length - 1; ++i) {
            if (!(min >= ps[i].get(Geometry.LU)) || !(min < ps[i + 1].get(Geometry.LU))) continue;
            if (min < (ps[i + 1].get(Geometry.LU) + ps[i].get(Geometry.LU)) / 2.0) {
                result = ps[i].get(Geometry.LU);
                break;
            }
            result = ps[i + 1].get(Geometry.LU);
            break;
        }
        return result;
    }

    private double getSnapMax(double max, UnitDouble[] ps) {
        double result = ps[ps.length - 1].get(Geometry.LU);
        if (max >= ps[ps.length - 1].get(Geometry.LU)) {
            return result;
        }
        for (int i = ps.length - 1; i > 0; --i) {
            if (!(max >= ps[i - 1].get(Geometry.LU)) || !(max < ps[i].get(Geometry.LU))) continue;
            if (max < (ps[i - 1].get(Geometry.LU) + ps[i].get(Geometry.LU)) / 2.0) {
                result = ps[i - 1].get(Geometry.LU);
                break;
            }
            result = ps[i].get(Geometry.LU);
            break;
        }
        return result;
    }

    @Override
    public ARunFDSValidation.Prompt getPrompt(Window owner, int issueSize) {
        String instructions = String.format(Intl.intl("The model contains %d vents that will be collapsed to a point or\nline in FDS.\n\nClick OK to select the vents that will collapse.\n\nClick Ignore to continue.\n"), issueSize);
        ARunFDSValidation.Prompt p = new ARunFDSValidation.Prompt(owner, instructions);
        p.overrideButtonDesc(8, Intl.intl("Ignore"));
        return p;
    }

    @Override
    public String getValidationDescription() {
        return Intl.intl("Vent Collapse Validation");
    }
}

