/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JWindow;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.metal.MetalBorders;

public class ResizableWindow
extends JWindow {
    private static final long serialVersionUID = -2161231002898733963L;
    private static final int RZ_NORTH = 1;
    private static final int RZ_WEST = 2;
    private static final int RZ_SOUTH = 4;
    private static final int RZ_EAST = 8;

    public ResizableWindow() {
        this((Window)null);
    }

    public ResizableWindow(Window parent) {
        super(parent);
        Border border = UIManager.getBorder("InternalFrame.border");
        if (border == null) {
            border = new MetalBorders.InternalFrameBorder();
        }
        this.getRootPane().setBorder(border);
        ResizeListener mouseList = new ResizeListener();
        this.addMouseListener(mouseList);
        this.addMouseMotionListener(mouseList);
    }

    @Override
    public Cursor getCursor() {
        int cursor;
        Point cursorLoc = MouseInfo.getPointerInfo().getLocation();
        Point windowLoc = this.getLocation();
        cursorLoc = (Point)cursorLoc.clone();
        cursorLoc.x -= windowLoc.x;
        cursorLoc.y -= windowLoc.y;
        int resize = this.getResize(cursorLoc);
        switch (resize) {
            case 3: {
                cursor = 6;
                break;
            }
            case 6: {
                cursor = 4;
                break;
            }
            case 12: {
                cursor = 5;
                break;
            }
            case 9: {
                cursor = 7;
                break;
            }
            case 2: {
                cursor = 10;
                break;
            }
            case 4: {
                cursor = 9;
                break;
            }
            case 8: {
                cursor = 11;
                break;
            }
            case 1: {
                cursor = 8;
                break;
            }
            default: {
                cursor = 0;
            }
        }
        return Cursor.getPredefinedCursor(cursor);
    }

    private int getResize(Point mloc) {
        Dimension windowSize = this.getSize();
        Border border = this.getRootPane().getBorder();
        Insets binsets = border.getBorderInsets(this);
        int resize = 0;
        if (mloc.getX() <= (double)binsets.left && mloc.getX() >= 0.0) {
            resize |= 2;
        } else if (mloc.getX() >= (double)(windowSize.width - binsets.right) && mloc.getX() <= (double)windowSize.width) {
            resize |= 8;
        }
        if (mloc.getY() <= (double)binsets.top && mloc.getY() >= 0.0) {
            resize |= 1;
        } else if (mloc.getY() >= (double)(windowSize.height - binsets.bottom) && mloc.getY() <= (double)windowSize.height) {
            resize |= 4;
        }
        return resize;
    }

    private class ResizeListener
    extends MouseAdapter {
        private int d_resizeFlags = 0;
        private Point d_resizeLoc = null;
        private Rectangle d_originalBounds = null;

        private ResizeListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            ResizableWindow.this.setCursor(ResizableWindow.this.getCursor());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!this.isClicked()) {
                ResizableWindow.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1) {
                this.d_resizeFlags = ResizableWindow.this.getResize(e.getPoint());
                if (this.d_resizeFlags != 0) {
                    this.d_originalBounds = (Rectangle)ResizableWindow.this.getBounds().clone();
                    this.d_resizeLoc = e.getLocationOnScreen();
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.getButton() == 1) {
                this.d_resizeFlags = 0;
                this.d_originalBounds = null;
                this.d_resizeLoc = null;
            }
        }

        private boolean testFlag(int flags, int flag) {
            return (flags & flag) == flag;
        }

        private boolean isClicked() {
            return this.d_originalBounds != null;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.d_originalBounds != null && this.d_resizeFlags != 0) {
                Insets binsets = ResizableWindow.this.getRootPane().getBorder().getBorderInsets(ResizableWindow.this);
                int minWidth = binsets.left + binsets.right;
                int minHeight = binsets.bottom + binsets.top;
                int x1 = this.d_originalBounds.x;
                int x2 = this.d_originalBounds.x + this.d_originalBounds.width;
                int y1 = this.d_originalBounds.y;
                int y2 = this.d_originalBounds.y + this.d_originalBounds.height;
                Point newpt = e.getLocationOnScreen();
                int dx = newpt.x - this.d_resizeLoc.x;
                int dy = newpt.y - this.d_resizeLoc.y;
                if (this.testFlag(this.d_resizeFlags, 1) && y2 - (y1 += dy) < minHeight) {
                    y1 = y2 - minHeight;
                }
                if (this.testFlag(this.d_resizeFlags, 4) && (y2 += dy) - y1 < minHeight) {
                    y2 = y1 + minHeight;
                }
                if (this.testFlag(this.d_resizeFlags, 2) && x2 - (x1 += dx) < minWidth) {
                    x1 = x2 - minWidth;
                }
                if (this.testFlag(this.d_resizeFlags, 8) && (x2 += dx) - x1 < minWidth) {
                    x2 = x1 + minWidth;
                }
                ResizableWindow.this.setBounds(new Rectangle(x1, y1, x2 - x1, y2 - y1));
            }
        }
    }
}

