/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import pyrosim.Intl;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.PyroSimLM;
import pyrosim.gui.PyroGuiUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.VersionUtil;

public class PyroCheckForUpdatesDlg
extends VersionUtil.ACheckForUpdatesDlg {
    private static final long serialVersionUID = 7623903220813997016L;
    private final VersionUtil.URLVersionSource d_versionSource;

    public PyroCheckForUpdatesDlg(PyroSim app, boolean isCheckOnStart, VersionUtil.URLVersionSource versionSource) {
        super((Window)app.getMainFrame(), Intl.intl("Check For Updates"), versionSource, isCheckOnStart);
        this.d_skipUpdateButton.addActionListener(new SkipUpdate(app, this));
        this.d_versionSource = versionSource;
    }

    @Override
    protected void init(boolean isCheckOnStart, VersionUtil.IVersionSource versionSource) {
        this.d_updates = this.buildPanel(VersionUtil.getVersionSupplier(PyroSimLM.getInstance()), "2021.2.0512", versionSource);
        this.d_checkOnStartCB.setSelected(isCheckOnStart);
        guiPanel c = this.getDialogPane();
        c.setLayout(new GridBagLayout());
        guiLabel labelImg = new guiLabel(PyroGuiUtil.loadPyroSimIcon("PyroSplash2.jpg"));
        GridBagUtil.add(c, labelImg, 0, 0, 1, 1, 0, 0, 0, 18, 0, 0.0, 0.0, 18);
        GridBagUtil.add(c, this.d_updates, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0.0, 0.0, 18);
        GridBagUtil.addGlue(c);
        this.getContentPane().remove(this.getButtonPanel());
        guiPanel southPnl = new guiPanel(new GridBagLayout());
        GridBagUtil.add(southPnl, this.d_checkOnStartCB, 0, 0, 1, 1, 6, 12, 0, 12, 0, 0.0, 0.0);
        GridBagUtil.add(southPnl, Box.createGlue(), 1, 0, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0);
        GridBagUtil.add(southPnl, this.getButtonPanel(), 2, 0, 1, 1, 0, 12, 0, 0, 0, 0.0, 0.0);
        this.getContentPane().add((Component)southPnl, "South");
        this.pack();
    }

    private class SkipUpdateDialog
    extends guiDialog {
        private static final long serialVersionUID = 1L;

        public SkipUpdateDialog(Window owner) {
            super(owner, Intl.intl("Skip Update"), 9);
            String headVersion = VersionUtil.getHeadVersionString(VersionUtil.getVersionSupplier(PyroSimLM.getInstance()), PyroCheckForUpdatesDlg.this.d_versionSource);
            GridBagHelper gb = new GridBagHelper(this.getDialogPane());
            gb.addRow(new guiLabel(String.format(Intl.intl("You will not be notified again about the %s release."), headVersion)), 0);
            gb.finalizeRows();
        }
    }

    public class SkipUpdate
    implements ActionListener {
        private final PyroSim d_app;
        private final guiDialog d_parent;

        public SkipUpdate(PyroSim app, guiDialog parent) {
            this.d_app = app;
            this.d_parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SkipUpdateDialog dialog = new SkipUpdateDialog(this.d_app.getMainFrame());
            if (dialog.doModal() == 1) {
                PyroSim.setPref(PyroPrefs.SKIP_UPDATE, true, false);
                PyroSim.setPref(PyroPrefs.SKIP_UPDATE_VERSION, VersionUtil.getHeadVersionString(VersionUtil.getVersionSupplier(PyroSimLM.getInstance()), PyroCheckForUpdatesDlg.this.d_versionSource), false);
                this.d_parent.setVisible(false);
            }
        }
    }
}

