/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacAircoil;
import pyrosim.domain.hvac.HvacFan;
import pyrosim.domain.hvac.HvacFilter;
import pyrosim.domain.hvac.HvacLeak;
import pyrosim.domain.hvac.IHvacObject;
import pyrosim.domain.variant.Variant;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.TimeFunctionEditor;
import pyrosim.gui.VariantEditor;
import pyrosim.gui.comboboxes.PyroComboBox;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.AOneTimeTask;

public class HvacEditor
extends guiPanel
implements IEditor<IHvacObject> {
    private static final long serialVersionUID = -6076515160878952939L;
    private IEditor<IHvacObject> d_aircoilEditor;
    private IEditor<IHvacObject> d_fanEditor;
    private IEditor<IHvacObject> d_filterEditor;
    private IEditor<IHvacObject> d_leakEditor;
    private IEditor<IHvacObject> d_currentEditor;

    public HvacEditor(PyroMod mod, UnitSystem usys) {
        this.d_aircoilEditor = new AircoilEditor(mod, usys);
        this.d_fanEditor = new FanEditor(mod, usys);
        this.d_filterEditor = new FilterEditor(mod, usys);
        this.d_leakEditor = new LeakEditor(mod);
        this.d_currentEditor = this.d_fanEditor;
        this.setLayout(new CardLayout());
        this.add((Component)this.d_aircoilEditor.getEditorPanel(), "AIRCOIL");
        this.add((Component)this.d_fanEditor.getEditorPanel(), "FAN");
        this.add((Component)this.d_filterEditor.getEditorPanel(), "FILTER");
        this.add((Component)this.d_leakEditor.getEditorPanel(), "LEAK");
        ((CardLayout)this.getLayout()).next(this);
        this.setModified(false);
        this.setEnabled(false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.d_aircoilEditor.getEditorPanel().setEnabled(enabled);
        this.d_fanEditor.getEditorPanel().setEnabled(enabled);
        this.d_filterEditor.getEditorPanel().setEnabled(enabled);
        this.d_leakEditor.getEditorPanel().setEnabled(enabled);
    }

    @Override
    public void init(IHvacObject dataObj) {
        this.setEnabled(dataObj != null);
        if (dataObj == null) {
            return;
        }
        this.d_currentEditor = null;
        if (dataObj instanceof HvacAircoil) {
            this.d_currentEditor = this.d_aircoilEditor;
            ((CardLayout)this.getLayout()).show(this, "AIRCOIL");
        } else if (dataObj instanceof HvacFan) {
            this.d_currentEditor = this.d_fanEditor;
            ((CardLayout)this.getLayout()).show(this, "FAN");
        } else if (dataObj instanceof HvacFilter) {
            this.d_currentEditor = this.d_filterEditor;
            ((CardLayout)this.getLayout()).show(this, "FILTER");
        } else if (dataObj instanceof HvacLeak) {
            this.d_currentEditor = this.d_leakEditor;
            ((CardLayout)this.getLayout()).show(this, "LEAK");
        } else assert (false);
        this.d_currentEditor.init(dataObj);
        this.setModified(false);
    }

    @Override
    public IHvacObject preview(IHvacObject previewObj) {
        return this.d_currentEditor.preview(previewObj);
    }

    @Override
    public IHvacObject commit(IHvacObject dataObj) {
        IHvacObject result = this.d_currentEditor.commit(dataObj);
        this.setModified(false);
        return result;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    private static class FilterEditor
    extends AHvacEditor {
        private static final long serialVersionUID = 1946930149280272514L;
        private final guiTextField d_idTF;
        private final guiTextField d_fyi;
        private final guiRadioButton d_lossRB;
        private final guiRadioButton d_rampRB;
        private final ValueField<UnitDouble> d_cleanLoss;
        private final ValueField<UnitDouble> d_loss;
        private guiTableEditor d_tableEditor;
        private guiTable d_table;
        private final VariantEditor d_ramp;
        private final CustomFDSPanel d_customPnl;
        private PyroMod d_domain;

        public FilterEditor(PyroMod pymod, UnitSystem usys) {
            this.d_domain = pymod;
            this.d_customPnl = new CustomFDSPanel(7);
            this.setLayout(new MigLayout("insets 0", "[25][grow]", "[]6[]10[grow]"));
            JTabbedPane tabs = new JTabbedPane();
            guiPanel props = new guiPanel();
            props.setLayout(new MigLayout("insets 12", "", "[]5[]5[]5[]5[]10[]10[]"));
            tabs.addTab(Intl.intl("Properties"), props);
            tabs.addTab(Intl.intl("Advanced"), this.d_customPnl);
            guiLabel id = new guiLabel(Intl.intl("Filter Id: "));
            guiLabel fyi = new guiLabel(Intl.intl("Description: "));
            this.d_idTF = new guiTextField();
            this.d_idTF.setEditable(false);
            this.d_fyi = new guiTextField();
            this.d_fyi.setToolTipText("FYI");
            this.add((Component)id, "growx 0");
            this.add((Component)this.d_idTF, "shrink 0, growx, span");
            this.add((Component)fyi, "grow 0");
            this.add((Component)this.d_fyi, "shrink 0, growx, span");
            this.add((Component)tabs, "span, growx, growy");
            this.d_lossRB = new guiRadioButton(Intl.intl("Linear"));
            this.d_rampRB = new guiRadioButton(Intl.intl("Custom"));
            new guiButtonGroup(this.d_lossRB, this.d_rampRB);
            guiPanel lossPnl = new guiPanel();
            lossPnl.setLayout(new MigLayout("insets 0 8 0 0"));
            guiLabel cleanLoss = new guiLabel(Intl.intl("Clean Loss: "));
            guiLabel loss = new guiLabel(Intl.intl("Loss: "));
            this.d_cleanLoss = ValueFields.udFld(UnitSystem.getSource(28));
            this.d_loss = ValueFields.udFld(UnitSystem.getSource(28));
            String[] columnHeaders = new String[]{Intl.intl("Species"), Intl.intl("Efficiency"), Intl.intl("Initial Loading"), Intl.intl("Loading Multiplier")};
            this.d_tableEditor = new guiTableEditor(guiTableUtil.fixedColumnTable(columnHeaders, new Class[]{String.class, UnitDouble.class, UnitDouble.class, UnitDouble.class}), 0);
            this.d_table = this.d_tableEditor.getTable();
            guiTable.UnitDoubleEditor loadEditor = new guiTable.UnitDoubleEditor(PyroSim.getApp().getUnitSystem().getMass());
            guiTable.UnitDoubleEditor multEditor = new guiTable.UnitDoubleEditor(PyroSim.getApp().getUnitSystem().getUnitlessUnit());
            this.d_table.getColumnModel().getColumn(1).setCellEditor(multEditor);
            this.d_table.getColumnModel().getColumn(2).setCellEditor(loadEditor);
            this.d_table.getColumnModel().getColumn(3).setCellEditor(multEditor);
            this.d_table.setNullValuesAllowed(false);
            this.d_table.autoSizeColumns(120);
            TableColumn specColumn = this.d_table.getColumnModel().getColumn(0);
            guiComboBox cb = new guiComboBox();
            ExSpecList specs = pymod.getExSpecList();
            for (ExSpec s : specs.getMembers(ExSpec.class)) {
                cb.addItem((String)s.getName());
            }
            specColumn.setCellEditor(new DefaultCellEditor(cb));
            lossPnl.add(cleanLoss);
            lossPnl.add(this.d_cleanLoss, "wrap");
            lossPnl.add(loss);
            lossPnl.add(this.d_loss, "wrap");
            LinkStatus.link((AbstractButton)this.d_lossRB, lossPnl);
            guiPanel rampPnl = new guiPanel();
            rampPnl.setLayout(new MigLayout("insets 0 8 0 0"));
            this.d_ramp = new VariantEditor(Intl.intl("Loss"), Intl.intl("Pressure Drop"), HvacFilter.FUNC_PROF, false);
            rampPnl.add(this.d_ramp.getLabel());
            rampPnl.add((Component)this.d_ramp.getEditor(), "wrap");
            LinkStatus.link((AbstractButton)this.d_rampRB, rampPnl);
            props.add((Component)new guiLabel(Intl.intl("Flow Loss Model")), "split 2, span");
            props.add((Component)new JSeparator(), "wrap, growx");
            props.add((Component)this.d_lossRB, "wrap");
            props.add((Component)lossPnl, "gapleft 10, wrap");
            props.add((Component)this.d_rampRB, "wrap");
            props.add((Component)rampPnl, "gapleft 10, wrap");
            props.add((Component)new guiLabel(Intl.intl("Species Filtration")), "split 2, span");
            props.add((Component)new JSeparator(), "wrap, growx");
            props.add((Component)this.d_tableEditor, "gapleft 10");
        }

        @Override
        public void init(IHvacObject dataObj) {
            if (dataObj != null) {
                HvacFilter filter = (HvacFilter)dataObj;
                this.d_idTF.setText(dataObj.getName());
                this.d_fyi.setText(dataObj.getDesc());
                this.d_ramp.init(filter.getCustomLoss(), true);
                this.d_cleanLoss.setValue((UnitDouble)dataObj.getProp("CLEAN_LOSS"));
                List loss = (List)dataObj.getProp("LOSS");
                if (!loss.isEmpty()) {
                    this.d_loss.setValue(loss.get(0));
                } else {
                    this.d_loss.setValue(new UnitDouble(0.0, Unit.ONE));
                }
                List spec_id = (List)dataObj.getProp("SPEC_ID");
                List efficiency = (List)dataObj.getProp("EFFICIENCY");
                List loading = (List)dataObj.getProp("LOADING");
                List loadingMult = (List)dataObj.getProp("LOADING_MULTIPLIER");
                guiDefaultTableModel mod = (guiDefaultTableModel)this.d_table.getModel();
                mod.setNumRows(spec_id.size());
                if (!spec_id.isEmpty()) {
                    for (int i = 0; i < spec_id.size(); ++i) {
                        mod.setValueAt(((ExSpec)spec_id.get(i)).getName(), i, 0);
                        mod.setValueAt(efficiency.get(i), i, 1);
                        mod.setValueAt(loading.get(i), i, 2);
                        mod.setValueAt(loadingMult.get(i), i, 3);
                    }
                }
                switch ((HvacFilter.LossModel)((Object)dataObj.getProp("opt_loss_ramp"))) {
                    case CUSTOM: {
                        this.d_rampRB.setSelected(true);
                        break;
                    }
                    case LINEAR: {
                        this.d_lossRB.setSelected(true);
                    }
                }
                this.d_customPnl.clear();
                this.d_customPnl.load(Collections.singleton(filter), new CustomFDSPanel.AdvPropWrapper<Boolean>(filter.isForceWrite(), 1));
            }
        }

        @Override
        public boolean isModified() {
            return super.isModified();
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (this.d_rampRB.isSelected() && !this.d_ramp.validateData(showWarn, allowModify)) {
                return false;
            }
            ExSpecList exSpecs = this.d_domain.getExSpecList();
            for (int i = 0; i < this.d_table.getRowCount(); ++i) {
                String specName;
                ExSpec spec;
                if (this.d_table.getValueAt(i, 0) == null || (spec = exSpecs.find(specName = this.d_table.getValueAt(i, 0).toString(), ExSpec.class, true)) != null) continue;
                this.d_table.flagInvalidCell(i, 0, showWarn, allowModify, String.format(Intl.intl("Unknown species: %s"), specName));
                return false;
            }
            return true;
        }

        @Override
        protected void save(IHvacObject dataObj, boolean preview) {
            String fyi = this.d_fyi.getText();
            dataObj.setDesc(fyi);
            ExSpecList exSpecs = this.d_domain.getExSpecList();
            ArrayList<ExSpec> specList = new ArrayList<ExSpec>();
            ArrayList<UnitDouble> efficiency = new ArrayList<UnitDouble>();
            ArrayList<UnitDouble> loading = new ArrayList<UnitDouble>();
            ArrayList<UnitDouble> loadingMult = new ArrayList<UnitDouble>();
            for (int i = 0; i < this.d_table.getRowCount(); ++i) {
                String specName;
                ExSpec spec;
                if (this.d_table.getValueAt(i, 0) == null || (spec = exSpecs.find(specName = this.d_table.getValueAt(i, 0).toString(), ExSpec.class, true)) == null) continue;
                specList.add(spec);
                efficiency.add((UnitDouble)this.d_table.getValueAt(i, 1));
                loading.add((UnitDouble)this.d_table.getValueAt(i, 2));
                loadingMult.add((UnitDouble)this.d_table.getValueAt(i, 3));
            }
            dataObj.setProp("SPEC_ID", specList);
            dataObj.setProp("EFFICIENCY", efficiency);
            dataObj.setProp("LOADING", loading);
            dataObj.setProp("LOADING_MULTIPLIER", loadingMult);
            if (this.d_lossRB.isSelected()) {
                dataObj.setProp("opt_loss_ramp", (Object)HvacFilter.LossModel.LINEAR);
                dataObj.setProp("LOSS", Arrays.asList((UnitDouble)this.d_loss.getValue()));
                dataObj.setProp("CLEAN_LOSS", this.d_cleanLoss.getValue());
            }
            if (this.d_rampRB.isSelected()) {
                dataObj.setProp("opt_loss_ramp", (Object)HvacFilter.LossModel.CUSTOM);
                ((HvacFilter)dataObj).setCustomLoss(this.d_ramp.getValue());
            }
            this.d_customPnl.save(Collections.singleton((HvacFilter)dataObj));
        }

        @Override
        public IHvacObject commit(final IHvacObject dataObj) {
            AOneTimeTask t = new AOneTimeTask(){

                @Override
                public void run() {
                    this.save(dataObj, false);
                }
            };
            PyroSim.getApp().getMediator().getTaskManager().exec(t, Intl.intl("Edit HVAC Filter"));
            this.setModified(false);
            return dataObj;
        }

        @Override
        public guiPanel getEditorPanel() {
            return this;
        }
    }

    private static class LeakEditor
    extends AHvacEditor {
        private static final long serialVersionUID = 1L;
        private final guiTextField d_id;
        private final guiTextField d_fyi;
        private final guiComboBox<Vent> d_vent1Editor;
        private final guiComboBox<Vent> d_vent2Editor;
        private final ValueField<UnitDouble> d_leakArea;
        private final ValueField<UnitDouble> d_loss;
        private final guiCheckBox d_enthalpy;
        private final CustomFDSPanel d_customPnl;
        private PyroMod d_domain;

        public LeakEditor(PyroMod pymod) {
            this.d_domain = pymod;
            this.d_customPnl = new CustomFDSPanel(7);
            this.setLayout(new MigLayout("insets 0", "[25][grow]", "[]6[]10[grow]"));
            JTabbedPane tabs = new JTabbedPane();
            guiPanel props = new guiPanel(new GridBagLayout());
            tabs.addTab(Intl.intl("Properties"), props);
            tabs.addTab(Intl.intl("Advanced"), this.d_customPnl);
            guiLabel id = new guiLabel(Intl.intl("Leak Id: "));
            this.d_id = new guiTextField();
            this.d_id.setEditable(false);
            guiLabel fyi = new guiLabel(Intl.intl("Description: "));
            this.d_fyi = new guiTextField();
            this.d_fyi.setToolTipText("FYI");
            this.add((Component)id, "growx 0");
            this.add((Component)this.d_id, "shrink 0, growx, span");
            this.add((Component)fyi, "growx 0");
            this.add((Component)this.d_fyi, "shrink 0, growx, span");
            this.add((Component)tabs, "span, growx, growy");
            String emptySel = Intl.intl("Ambient");
            guiLabel v1Lbl = new guiLabel(Intl.intl("Vent 1: "));
            this.d_vent1Editor = new PyroComboBox<Vent>((IPyroObject)this.d_domain.getObstructions(), (Vent)((Object)emptySel), Vent.class);
            guiLabel v2Lbl = new guiLabel(Intl.intl("Vent 2: "));
            this.d_vent2Editor = new PyroComboBox<Vent>((IPyroObject)this.d_domain.getObstructions(), (Vent)((Object)emptySel), Vent.class);
            guiLabel leakLbl = new guiLabel(Intl.intl("Leak Area: "));
            this.d_leakArea = ValueFields.udFld(SIUS.getSource(79), UnitDoubleVR.above(0.0, SI.METER.multiply(SI.METER), true));
            guiLabel lossLbl = new guiLabel(Intl.intl("Flow Loss: "));
            this.d_loss = ValueFields.udFld(UnitSystem.getSource(28));
            this.d_enthalpy = new guiCheckBox(Intl.intl("Enable Leak Enthalpy"));
            GridBagHelper gbh = new GridBagHelper(props, true);
            gbh.addRow(v1Lbl, this.d_vent1Editor);
            gbh.addRow(v2Lbl, this.d_vent2Editor);
            gbh.addRow(leakLbl, this.d_leakArea);
            gbh.addRow(lossLbl, this.d_loss);
            gbh.addRow(this.d_enthalpy);
            gbh.finalizeRows();
        }

        @Override
        public void init(IHvacObject dataObj) {
            if (dataObj != null) {
                HvacLeak leak = (HvacLeak)dataObj;
                this.d_id.setText(dataObj.getName());
                this.d_fyi.setText(dataObj.getDesc());
                assert (dataObj instanceof HvacLeak);
                this.d_vent1Editor.setSelectedItem(leak.getVent1());
                this.d_vent2Editor.setSelectedItem(leak.getVent2());
                this.d_leakArea.setValue(leak.getLeakArea());
                this.d_loss.setValue(leak.getLoss());
                this.d_enthalpy.setSelected(leak.isEnthalpyCalc());
                this.d_customPnl.clear();
                this.d_customPnl.load(Collections.singleton(leak), new CustomFDSPanel.AdvPropWrapper<Boolean>(leak.isForceWrite(), 1));
            }
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            return super.validateData(showWarn, allowModify);
        }

        @Override
        protected void save(IHvacObject dataObj, boolean preview) {
            HvacLeak leakObj = (HvacLeak)dataObj;
            String fyi = this.d_fyi.getText();
            leakObj.setDesc(fyi);
            leakObj.setVent1(this.d_vent1Editor.getSelectedItem());
            leakObj.setVent2(this.d_vent2Editor.getSelectedItem());
            leakObj.setLeakArea((UnitDouble)this.d_leakArea.getValue());
            leakObj.setLoss((UnitDouble)this.d_loss.getValue());
            leakObj.setEnthalpy(this.d_enthalpy.isSelected());
            this.d_customPnl.save(Collections.singleton(leakObj));
        }

        @Override
        public IHvacObject commit(final IHvacObject dataObj) {
            AOneTimeTask t = new AOneTimeTask(){

                @Override
                public void run() {
                    this.save(dataObj, false);
                }
            };
            ((PyroMod)dataObj.getDomain()).getTaskManager().exec(t, Intl.intl("Edit HVAC Leak"));
            this.setModified(false);
            return dataObj;
        }

        @Override
        public guiPanel getEditorPanel() {
            return this;
        }
    }

    private static class FanEditor
    extends AHvacEditor {
        private static final long serialVersionUID = 3387938989345252781L;
        private final guiTextField d_idTF;
        private final guiTextField d_fyi;
        private final CustomFDSPanel d_customPnl = new CustomFDSPanel(7);
        private final ValueField<UnitDouble> d_maxFlowFld;
        private final ValueField<UnitDouble> d_maxPressureFld;
        private final ValueField<UnitDouble> d_volFlowFld;
        private final ValueField<UnitDouble> d_lossFld;
        private final guiRadioButton d_quadBtn;
        private final guiRadioButton d_flowBtn;
        private final guiRadioButton d_rampBtn;
        private TimeFunctionEditor d_tauFan;
        private VariantEditor d_pressureFlowRamp;

        public FanEditor(PyroMod mod, UnitSystem usys) {
            this.setLayout(new MigLayout("insets 0", "[25][grow]", "[]6[]10[grow]"));
            JTabbedPane tabs = new JTabbedPane();
            guiPanel props = new guiPanel();
            props.setLayout(new MigLayout("insets 12", "[][grow]", "[]10[]5[]5[]5[]5[]5[]5[]5[]5[]"));
            tabs.addTab(Intl.intl("Properties"), props);
            tabs.addTab(Intl.intl("Advanced"), this.d_customPnl);
            guiLabel id = new guiLabel(Intl.intl("Fan Id: "));
            this.d_idTF = new guiTextField();
            this.d_idTF.setEditable(false);
            guiLabel fyi = new guiLabel(Intl.intl("Description: "));
            this.d_fyi = new guiTextField();
            this.d_fyi.setToolTipText("FYI");
            this.add((Component)id, "growx 0");
            this.add((Component)this.d_idTF, "shrink 0, growx, span");
            this.add((Component)fyi, "growx 0");
            this.add((Component)this.d_fyi, "shrink 0, growx, span");
            this.add((Component)tabs, "span, growx, growy");
            this.d_quadBtn = new guiRadioButton(Intl.intl("Quadratic"));
            this.d_flowBtn = new guiRadioButton(Intl.intl("Constant Flow"));
            this.d_rampBtn = new guiRadioButton(Intl.intl("Defined Ramp"));
            new guiButtonGroup(this.d_quadBtn, this.d_flowBtn, this.d_rampBtn);
            guiLabel maxFlowRate = new guiLabel(Intl.intl("Maximum Flow Rate: "));
            guiLabel maxPressure = new guiLabel(Intl.intl("Maximum Pressure: "));
            this.d_maxFlowFld = ValueFields.udFld(UnitSystem.getSource(24));
            this.d_maxPressureFld = ValueFields.udFld(UnitSystem.getSource(7));
            LinkStatus.link((AbstractButton)this.d_quadBtn, maxFlowRate, this.d_maxFlowFld, maxPressure, this.d_maxPressureFld);
            guiLabel volFlow = new guiLabel(Intl.intl("Volume Flow Rate: "));
            this.d_volFlowFld = ValueFields.udFld(UnitSystem.getSource(24));
            LinkStatus.link((AbstractButton)this.d_flowBtn, volFlow, this.d_volFlowFld);
            this.d_pressureFlowRamp = new VariantEditor(Intl.intl("Fan Curve"), Intl.intl("Pressure Drop"), HvacFan.PRESSUREFLOW_PROFILE, false);
            LinkStatus.link((AbstractButton)this.d_rampBtn, this.d_pressureFlowRamp.getLabel(), this.d_pressureFlowRamp.getCombo(), this.d_pressureFlowRamp.getEditor());
            guiLabel loss = new guiLabel(Intl.intl("Flow Loss: "));
            this.d_lossFld = ValueFields.udFld(UnitSystem.getSource(28));
            this.d_tauFan = new TimeFunctionEditor(Intl.intl("Initial Ramp up time"), 13);
            props.add((Component)loss, "split 2, span");
            props.add(this.d_lossFld, "wrap");
            props.add((Component)new guiLabel(Intl.intl("Fan Model")), "split 2, span");
            props.add((Component)new JSeparator(), "growx, wrap");
            props.add((Component)this.d_tauFan.getLabel(), "gapleft 10");
            props.add((Component)this.d_tauFan.getCombo(), "split 2, span");
            props.add((Component)this.d_tauFan.getEditor(), "wrap");
            props.add((Component)this.d_quadBtn, "gapleft 10, span, wrap");
            props.add((Component)maxFlowRate, "gapleft 28");
            props.add(this.d_maxFlowFld, "wrap");
            props.add((Component)maxPressure, "gapleft 28");
            props.add(this.d_maxPressureFld, "wrap");
            props.add((Component)this.d_flowBtn, "gapleft 10, span, wrap");
            props.add((Component)volFlow, "gapleft 28");
            props.add(this.d_volFlowFld, "wrap");
            props.add((Component)this.d_rampBtn, "gapleft 10, span, wrap");
            props.add((Component)this.d_pressureFlowRamp.getLabel(), "gapleft 28");
            props.add((Component)this.d_pressureFlowRamp.getEditor(), "span, wrap");
        }

        @Override
        public void init(IHvacObject dataObj) {
            if (dataObj != null) {
                HvacFan fan = (HvacFan)dataObj;
                this.d_idTF.setText(dataObj.getName());
                this.d_fyi.setText(dataObj.getDesc());
                this.d_tauFan.loadFunction(fan.getTauFunc());
                this.d_pressureFlowRamp.init(fan.getPressureFlow(), true);
                this.d_maxFlowFld.setValue((UnitDouble)dataObj.getProp("MAX_FLOW"));
                this.d_maxPressureFld.setValue((UnitDouble)dataObj.getProp("MAX_PRESSURE"));
                this.d_volFlowFld.setValue((UnitDouble)dataObj.getProp("VOLUME_FLOW"));
                if (dataObj.getProp("opt_fan_model").equals(HvacFan.FAN_MODEL_QUADRATIC)) {
                    this.d_quadBtn.setSelected(true);
                } else if (dataObj.getProp("opt_fan_model").equals(HvacFan.FAN_MODEL_PRESDROP)) {
                    this.d_rampBtn.setSelected(true);
                } else if (dataObj.getProp("opt_fan_model").equals(HvacFan.FAN_MODEL_VOLFLOW)) {
                    this.d_flowBtn.setSelected(true);
                }
                List loss = (List)dataObj.getProp("LOSS");
                if (!loss.isEmpty()) {
                    this.d_lossFld.setValue((UnitDouble)loss.get(0));
                }
                this.d_customPnl.clear();
                this.d_customPnl.load(Collections.singleton(fan), new CustomFDSPanel.AdvPropWrapper<Boolean>(fan.isForceWrite(), 1));
            }
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            return !this.d_rampBtn.isSelected() || this.d_pressureFlowRamp.validateData(showWarn, allowModify);
        }

        @Override
        protected void save(IHvacObject dataObj, boolean preview) {
            HvacFan fanObj = (HvacFan)dataObj;
            fanObj.setProp("LOSS", Arrays.asList((UnitDouble)this.d_lossFld.getValue()));
            String fyi = this.d_fyi.getText();
            fanObj.setDesc(fyi);
            TimeFunction<?> tauFunc = this.d_tauFan.saveFunction();
            fanObj.setTauFunc(tauFunc);
            if (this.d_quadBtn.isSelected()) {
                fanObj.setProp("opt_fan_model", HvacFan.FAN_MODEL_QUADRATIC);
                fanObj.setProp("MAX_FLOW", this.d_maxFlowFld.getValue());
                fanObj.setProp("MAX_PRESSURE", this.d_maxPressureFld.getValue());
            }
            if (this.d_flowBtn.isSelected()) {
                fanObj.setProp("opt_fan_model", HvacFan.FAN_MODEL_VOLFLOW);
                fanObj.setProp("VOLUME_FLOW", this.d_volFlowFld.getValue());
            }
            if (this.d_rampBtn.isSelected()) {
                fanObj.setProp("opt_fan_model", HvacFan.FAN_MODEL_PRESDROP);
                Variant rampFunc = this.d_pressureFlowRamp.getValue();
                fanObj.setPressureFlow(rampFunc);
            }
            this.d_customPnl.save(Collections.singleton(fanObj));
        }

        @Override
        public IHvacObject commit(final IHvacObject dataObj) {
            AOneTimeTask t = new AOneTimeTask(){

                @Override
                public void run() {
                    this.save(dataObj, false);
                }
            };
            ((PyroMod)dataObj.getDomain()).getTaskManager().exec(t, Intl.intl("Edit HVAC Fan"));
            this.setModified(false);
            return dataObj;
        }

        @Override
        public guiPanel getEditorPanel() {
            return this;
        }
    }

    private static class AircoilEditor
    extends AHvacEditor {
        private static final long serialVersionUID = 7453401206554491498L;
        private final guiTextField d_id;
        private final guiTextField d_fyi;
        private final CustomFDSPanel d_customPnl = new CustomFDSPanel(7);
        private TimeFunctionEditor d_heatRate;
        private final ValueField<UnitDouble> d_heatRateFld;
        private final ValueField<UnitDouble> d_coolCpFld;
        private final ValueField<UnitDouble> d_coolMassFlowRateFld;
        private final ValueField<UnitDouble> d_coolTempFld;
        private final ValueField<UnitDouble> d_efficiencyFld;
        private final guiRadioButton d_directBtn;
        private final guiRadioButton d_coolantBtn;

        public AircoilEditor(PyroMod mod, UnitSystem usys) {
            this.setLayout(new MigLayout("insets 0", "[25][grow]", "[]6[]10[grow]"));
            JTabbedPane tabPane = new JTabbedPane();
            guiPanel props = new guiPanel();
            props.setLayout(new MigLayout("insets 12", "[][grow]", "[]10[][][][]"));
            tabPane.addTab(Intl.intl("Properties"), props);
            tabPane.addTab(Intl.intl("Advanced"), this.d_customPnl);
            guiLabel id = new guiLabel(Intl.intl("Aircoil Id: "));
            guiLabel fyi = new guiLabel(Intl.intl("Description: "));
            this.d_id = new guiTextField();
            this.d_id.setEditable(false);
            this.d_fyi = new guiTextField();
            this.d_fyi.setToolTipText("FYI");
            this.add((Component)id, "growx 0");
            this.add((Component)this.d_id, "shrink 0, growx, span");
            this.add((Component)fyi, "growx 0");
            this.add((Component)this.d_fyi, "shrink 0, growx, span");
            this.add((Component)tabPane, "span, growx, growy");
            this.d_directBtn = new guiRadioButton(Intl.intl("Direct"));
            this.d_coolantBtn = new guiRadioButton(Intl.intl("Coolant Properties"));
            new guiButtonGroup(this.d_directBtn, this.d_coolantBtn);
            guiPanel dirPanel = new guiPanel();
            dirPanel.setLayout(new MigLayout("insets 0 8 0 0"));
            guiLabel heatExRate = new guiLabel(Intl.intl("Heat Exchange Rate: "));
            this.d_heatRate = new TimeFunctionEditor(Intl.intl("Ramp-Up Time"), 29);
            this.d_heatRateFld = ValueFields.udFld(UnitSystem.getSource(78));
            dirPanel.add(heatExRate);
            dirPanel.add(this.d_heatRateFld, "span, wrap");
            dirPanel.add(this.d_heatRate.getLabel());
            dirPanel.add(this.d_heatRate.getCombo());
            dirPanel.add(this.d_heatRate.getEditor());
            LinkStatus.link((AbstractButton)this.d_directBtn, dirPanel);
            guiPanel coolPanel = new guiPanel();
            coolPanel.setLayout(new MigLayout("insets 0 8 0 0, wrap 2"));
            guiLabel coolCp = new guiLabel(Intl.intl("Coolant Specific Heat: "));
            guiLabel coolMdot = new guiLabel(Intl.intl("Coolant Mass Flow Rate: "));
            guiLabel coolTemp = new guiLabel(Intl.intl("Coolant Temperature: "));
            guiLabel efficiency = new guiLabel(Intl.intl("Heat Exchanger Efficiency: "));
            this.d_coolCpFld = ValueFields.udFld(UnitSystem.getSource(11));
            this.d_coolMassFlowRateFld = ValueFields.udFld(UnitSystem.getSource(38));
            this.d_coolTempFld = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_efficiencyFld = ValueFields.udFld(UnitSystem.getSource(28));
            coolPanel.add(coolCp);
            coolPanel.add(this.d_coolCpFld);
            coolPanel.add(coolMdot);
            coolPanel.add(this.d_coolMassFlowRateFld);
            coolPanel.add(coolTemp);
            coolPanel.add(this.d_coolTempFld);
            coolPanel.add(efficiency);
            coolPanel.add(this.d_efficiencyFld);
            LinkStatus.link((AbstractButton)this.d_coolantBtn, coolPanel);
            props.add(new guiLabel(Intl.intl("Heat Transfer Model")));
            props.add((Component)new JSeparator(), "wrap, growx");
            props.add((Component)this.d_directBtn, "span 2, wrap");
            props.add((Component)dirPanel, "span, gapleft 10, wrap");
            props.add((Component)this.d_coolantBtn, "span 2, wrap");
            props.add((Component)coolPanel, "span, gapleft 10, wrap");
        }

        @Override
        public void init(IHvacObject dataObj) {
            if (dataObj != null) {
                HvacAircoil aircoil = (HvacAircoil)dataObj;
                this.d_id.setText(dataObj.getName());
                this.d_fyi.setText(dataObj.getDesc());
                this.d_heatRateFld.setValue(aircoil.getFixedQ().val);
                this.d_heatRate.loadFunction(aircoil.getFixedQ().func);
                this.d_coolCpFld.setValue((UnitDouble)dataObj.getProp("COOLANT_SPECIFIC_HEAT"));
                this.d_coolMassFlowRateFld.setValue((UnitDouble)dataObj.getProp("COOLANT_MASS_FLOW"));
                this.d_coolTempFld.setValue((UnitDouble)dataObj.getProp("COOLANT_TEMPERATURE"));
                this.d_efficiencyFld.setValue((UnitDouble)dataObj.getProp("EFFICIENCY"));
                HvacAircoil.Model model = (HvacAircoil.Model)((Object)dataObj.getProp("opt_aircoil_model"));
                switch (model) {
                    case COOLANT: {
                        this.d_coolantBtn.setSelected(true);
                        break;
                    }
                    case FIXEDQ: {
                        this.d_directBtn.setSelected(true);
                    }
                }
                this.d_customPnl.clear();
                this.d_customPnl.load(Collections.singleton(aircoil), new CustomFDSPanel.AdvPropWrapper<Boolean>(aircoil.isForceWrite(), 1));
            }
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            return super.validateData(showWarn, allowModify) && this.d_heatRate.validateData(showWarn, allowModify);
        }

        @Override
        protected void save(IHvacObject dataObj, boolean preview) {
            HvacAircoil aircoil = (HvacAircoil)dataObj;
            aircoil.changedEvt(new Object[0]);
            aircoil.setDesc(this.d_fyi.getText());
            if (this.d_directBtn.isSelected()) {
                UnitDouble fixedQVal = (UnitDouble)this.d_heatRateFld.getValue();
                TimeFunction<?> func = this.d_heatRate.saveFunction();
                aircoil.setFixedQ(new TimeBasedValue<UnitDouble>(fixedQVal, func));
                aircoil.setProp("opt_aircoil_model", (Object)HvacAircoil.Model.FIXEDQ);
            } else if (this.d_coolantBtn.isSelected()) {
                aircoil.setProp("COOLANT_SPECIFIC_HEAT", this.d_coolCpFld.getValue());
                aircoil.setProp("COOLANT_MASS_FLOW", this.d_coolMassFlowRateFld.getValue());
                aircoil.setProp("COOLANT_TEMPERATURE", this.d_coolTempFld.getValue());
                aircoil.setProp("EFFICIENCY", this.d_efficiencyFld.getValue());
                aircoil.setProp("opt_aircoil_model", (Object)HvacAircoil.Model.COOLANT);
            }
            this.d_customPnl.save(Collections.singleton(aircoil));
        }

        @Override
        public IHvacObject commit(final IHvacObject dataObj) {
            AOneTimeTask t = new AOneTimeTask(){

                @Override
                public void run() {
                    this.save(dataObj, false);
                }
            };
            PyroSim.getApp().getMediator().getTaskManager().exec(t, Intl.intl("Edit HVAC Aircoil"));
            this.setModified(false);
            return dataObj;
        }

        @Override
        public guiPanel getEditorPanel() {
            return this;
        }
    }

    public static abstract class AHvacEditor
    extends guiPanel
    implements IEditor<IHvacObject> {
        private static final long serialVersionUID = 5816966357452647969L;

        protected abstract void save(IHvacObject var1, boolean var2);

        @Override
        public IHvacObject preview(IHvacObject previewObj) {
            if (!this.validateData(false, false)) {
                return null;
            }
            this.save(previewObj, true);
            return previewObj;
        }
    }
}

