/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.ExSpecEditor;
import pyrosim.gui.ExSpecNewDlg;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.RenameAction;
import pyrosim.util.Util;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiAction;

public class ExSpecManagerDlg
extends ManagerDlg<ExSpec, ExSpecList> {
    private static final long serialVersionUID = 7991146854485689613L;
    private final IEditor d_editor = new ExSpecEditor(this);
    private final Action[] d_actions = new Action[]{new NewAction(), new ManagerDlg.LibraryAction(this, ExSpec.class), new RenameAction<ExSpec, ExSpecList>(this, Intl.intl("extra species")), new ManagerDlg.DeleteAction(this)};
    private ExSpecList d_mgr;

    public ExSpecManagerDlg(JFrame owner) {
        super(owner, Intl.intl("Edit Species"), true);
        this.setRenderer(new ExSpecListCellRen());
        this.updateActions();
    }

    public void updateActions() {
        this.d_actions[0].setEnabled(this.d_mgr != null);
        this.d_actions[2].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1);
        this.d_actions[3].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        super.valueChanged(evt);
        this.updateActions();
    }

    public void init(ExSpecList mgr, ExSpec init) {
        this.d_mgr = mgr;
        ((RenameAction)this.d_actions[2]).init(mgr);
        super.init(this.d_mgr, this.d_editor, this.d_actions, init);
        this.updateActions();
    }

    private class ExSpecListCellRen
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 4749567436250904536L;
        private Font d_italic = new Font("SansSerif", 2, 11);
        private Font d_plain = new Font("SansSerif", 0, 11);
        private Font d_bold = new Font("SansSerif", 1, 11);
        private Font d_boldItalic = new Font("SansSerif", 3, 11);

        private ExSpecListCellRen() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            boolean shouldBold;
            Component c = super.getListCellRendererComponent((JList<?>)list, Util.getName((ExSpec)value), index, isSelected, cellHasFocus);
            c.setEnabled(((ExSpec)value).isEnabled());
            boolean bl = shouldBold = ((ExSpec)value).getType() == 0;
            if (index == ExSpecManagerDlg.this.d_edix && ExSpecManagerDlg.this.d_editor.isModified()) {
                if (shouldBold) {
                    c.setFont(this.d_boldItalic);
                } else {
                    c.setFont(this.d_italic);
                }
            } else if (shouldBold) {
                c.setFont(this.d_bold);
            } else {
                c.setFont(this.d_plain);
            }
            return c;
        }
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = -1252470174172443054L;

        public NewAction() {
            super(Intl.intl("New"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExSpec rec;
            if (!ExSpecManagerDlg.this.preSave()) {
                return;
            }
            PyroMod domain = (PyroMod)ExSpecManagerDlg.this.d_mgr.getDomain();
            ExSpecNewDlg dlg = new ExSpecNewDlg(ExSpecManagerDlg.this, (PyroMod)ExSpecManagerDlg.this.d_mgr.getDomain());
            if (dlg.doModal() != 1) {
                return;
            }
            if (dlg.isPredefined()) {
                String id = dlg.getSpeciesPredef();
                rec = new ExSpec(ExSpecList.PREDEFINED.get(id));
                assert (rec != null);
            } else if (dlg.isCustom()) {
                rec = dlg.isPrimitive() ? new ExSpec(dlg.getSpeciesCustom(), 1) : new ExSpec(dlg.getSpeciesCustom(), 2);
            } else {
                rec = null;
                assert (false);
            }
            AddTask t = new AddTask((IPyroObject)ExSpecManagerDlg.this.d_mgr, new IPyroObject[]{rec});
            SelectTask wrapper = new SelectTask(domain, rec);
            wrapper.addTask(t);
            domain.getTaskManager().exec(wrapper, Intl.intl("New Extra Species"));
            ExSpecManagerDlg.this.getList().updateModelView(ExSpecManagerDlg.this.d_mgr);
            ExSpecManagerDlg.this.getList().select(rec);
            ExSpecManagerDlg.this.d_editor.getEditorPanel().setModified(false);
            ExSpecManagerDlg.this.updateActions();
        }
    }
}

