/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.geom.rasterization;

import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3i;
import javax.vecmath.Vector3d;
import pyrosim.geom.rasterization.IRaster3D;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexPolygon;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class Raster3D_V2
implements IRaster3D {
    private static final double EPSILON = 1.0E-9;
    private static final Vector3d XPOS = new Vector3d(1.0, 0.0, 0.0);
    private static final Vector3d YPOS = new Vector3d(0.0, 1.0, 0.0);
    private static final Vector3d ZPOS = new Vector3d(0.0, 0.0, 1.0);
    private static final Matrix3i s_xyLWXform = new Matrix3i(1, 0, 0, 0, 1, 0, 0, 0, 1);
    private static final Matrix3i s_xzLWXform = new Matrix3i(1, 0, 0, 0, 0, 1, 0, 1, 0);
    private static final Matrix3i s_yzLWXform = new Matrix3i(0, 0, 1, 1, 0, 0, 0, 1, 0);
    private ConvexVolume d_rastVolume;
    private double[] d_xDiv;
    private double[] d_yDiv;
    private double[] d_zDiv;
    private int d_currGroup;
    private final Map<Point3i, Integer> d_cells;
    private final CellList d_xyCells = new CellList(Dir.Z);
    private final CellList d_xzCells = new CellList(Dir.Y);
    private final CellList d_yzCells = new CellList(Dir.X);
    private static final Point3i[] s_cellAdjCell = new Point3i[]{new Point3i(-1, -1, -1), new Point3i(-1, 0, -1), new Point3i(-1, 1, -1), new Point3i(0, -1, -1), new Point3i(0, 0, -1), new Point3i(0, 1, -1), new Point3i(1, -1, -1), new Point3i(1, 0, -1), new Point3i(1, 1, -1), new Point3i(-1, -1, 0), new Point3i(-1, 0, 0), new Point3i(-1, 1, 0), new Point3i(0, -1, 0), new Point3i(0, 1, 0), new Point3i(1, -1, 0), new Point3i(1, 0, 0), new Point3i(1, 1, 0), new Point3i(-1, -1, 1), new Point3i(-1, 0, 1), new Point3i(-1, 1, 1), new Point3i(0, -1, 1), new Point3i(0, 0, 1), new Point3i(0, 1, 1), new Point3i(1, -1, 1), new Point3i(1, 0, 1), new Point3i(1, 1, 1)};
    private static final Point3i[] s_cellAdjXY = new Point3i[]{new Point3i(-1, -1, 0), new Point3i(-1, 0, 0), new Point3i(-1, 1, 0), new Point3i(0, -1, 0), new Point3i(0, 1, 0), new Point3i(1, -1, 0), new Point3i(1, 0, 0), new Point3i(1, 1, 0), new Point3i(-1, -1, 1), new Point3i(-1, 0, 1), new Point3i(-1, 1, 1), new Point3i(0, -1, 1), new Point3i(0, 1, 1), new Point3i(1, -1, 1), new Point3i(1, 0, 1), new Point3i(1, 1, 1)};
    private static final Point3i[] s_cellAdjXZ = new Point3i[]{new Point3i(-1, 0, -1), new Point3i(0, 0, -1), new Point3i(1, 0, -1), new Point3i(-1, 0, 0), new Point3i(1, 0, 0), new Point3i(-1, 0, 1), new Point3i(0, 0, 1), new Point3i(1, 0, 1), new Point3i(-1, 1, -1), new Point3i(0, 1, -1), new Point3i(1, 1, -1), new Point3i(-1, 1, 0), new Point3i(1, 1, 0), new Point3i(-1, 1, 1), new Point3i(0, 1, 1), new Point3i(1, 1, 1)};
    private static final Point3i[] s_cellAdjYZ = new Point3i[]{new Point3i(0, -1, -1), new Point3i(0, 0, -1), new Point3i(0, 1, -1), new Point3i(0, -1, 0), new Point3i(0, 1, 0), new Point3i(0, -1, 1), new Point3i(0, 0, 1), new Point3i(0, 1, 1), new Point3i(1, -1, -1), new Point3i(1, 0, -1), new Point3i(1, 1, -1), new Point3i(1, -1, 0), new Point3i(1, 1, 0), new Point3i(1, -1, 1), new Point3i(1, 0, 1), new Point3i(1, 1, 1)};
    private static final Point3i[] s_xyAdjCell = Raster3D_V2.calcCellAdj(null);
    private static final Point3i[] s_xyAdjXY = Raster3D_V2.calcXYAdj(null);
    private static final Point3i[] s_xyAdjXZ = Raster3D_V2.calcXZAdj(null);
    private static final Point3i[] s_xyAdjYZ = Raster3D_V2.calcYZAdj(null);
    private static final Point3i[] s_xzAdjCell = Raster3D_V2.calcCellAdj(s_xzLWXform);
    private static final Point3i[] s_xzAdjXY = Raster3D_V2.calcXZAdj(s_xzLWXform);
    private static final Point3i[] s_xzAdjXZ = Raster3D_V2.calcXYAdj(s_xzLWXform);
    private static final Point3i[] s_xzAdjYZ = Raster3D_V2.calcYZAdj(s_xzLWXform);
    private static final Point3i[] s_yzAdjCell = Raster3D_V2.calcCellAdj(s_yzLWXform);
    private static final Point3i[] s_yzAdjXY = Raster3D_V2.calcXZAdj(s_yzLWXform);
    private static final Point3i[] s_yzAdjXZ = Raster3D_V2.calcYZAdj(s_yzLWXform);
    private static final Point3i[] s_yzAdjYZ = Raster3D_V2.calcXYAdj(s_yzLWXform);

    public Raster3D_V2(double[] xDiv, double[] yDiv, double[] zDiv) {
        this(xDiv, yDiv, zDiv, 0);
    }

    public Raster3D_V2(double[] xDiv, double[] yDiv, double[] zDiv, int defaultGroup) {
        assert (xDiv.length > 0 && yDiv.length > 0 && zDiv.length > 0);
        this.setCurrentGroup(defaultGroup);
        this.d_cells = new HashMap<Point3i, Integer>();
        this.setDivisions(xDiv, yDiv, zDiv);
    }

    private static double[] getCenters(double[] div) {
        double[] centers = new double[div.length - 1];
        for (int m = 0; m < centers.length; ++m) {
            centers[m] = (div[m] + div[m + 1]) * 0.5;
        }
        return centers;
    }

    @Override
    public void setDivisions(double[] xDiv, double[] yDiv, double[] zDiv) {
        this.clear();
        if (xDiv == null || yDiv == null || zDiv == null) {
            return;
        }
        this.d_xDiv = xDiv;
        this.d_yDiv = yDiv;
        this.d_zDiv = zDiv;
        double minx = this.d_xDiv[0];
        double maxx = this.d_xDiv[this.d_xDiv.length - 1];
        double miny = this.d_yDiv[0];
        double maxy = this.d_yDiv[this.d_yDiv.length - 1];
        double minz = this.d_zDiv[0];
        double maxz = this.d_zDiv[this.d_zDiv.length - 1];
        assert (minx <= maxx && miny <= maxy && minz <= maxz) : "Inside out raster error";
        Point3d mmm = new Point3d(minx, miny, minz);
        Point3d mmM = new Point3d(minx, miny, maxz);
        Point3d mMm = new Point3d(minx, maxy, minz);
        Point3d mMM = new Point3d(minx, maxy, maxz);
        Point3d Mmm = new Point3d(maxx, miny, minz);
        Point3d MmM = new Point3d(maxx, miny, maxz);
        Point3d MMm = new Point3d(maxx, maxy, minz);
        Point3d MMM = new Point3d(maxx, maxy, maxz);
        ConvexPolygon[] faces = new ConvexPolygon[]{new ConvexPolygon(true, mmm, mMm, mMM, mmM), new ConvexPolygon(true, Mmm, MmM, MMM, MMm), new ConvexPolygon(true, mmm, mmM, MmM, Mmm), new ConvexPolygon(true, MMm, MMM, mMM, mMm), new ConvexPolygon(true, mmm, Mmm, MMm, mMm), new ConvexPolygon(true, mmM, mMM, MMM, MmM)};
        this.d_rastVolume = new ConvexVolume(faces);
    }

    @Override
    public double[] getXDiv() {
        return this.d_xDiv;
    }

    @Override
    public double[] getYDiv() {
        return this.d_yDiv;
    }

    @Override
    public double[] getZDiv() {
        return this.d_zDiv;
    }

    public void setCurrentGroup(int group) {
        this.d_currGroup = group;
    }

    @Override
    public void clear() {
        this.d_cells.clear();
        this.d_xyCells.clear();
        this.d_xzCells.clear();
        this.d_yzCells.clear();
    }

    @Override
    public boolean merge(IRaster3D rast) {
        if (!(rast instanceof Raster3D_V2)) {
            return false;
        }
        Raster3D_V2 r = (Raster3D_V2)rast;
        this.d_cells.putAll(r.d_cells);
        this.d_xyCells.merge(r.d_xyCells);
        this.d_yzCells.merge(r.d_yzCells);
        this.d_xzCells.merge(r.d_xzCells);
        return true;
    }

    @Override
    public void finalizeData() {
        this.removeInternalFaces();
    }

    @Override
    public IRaster3D.CellListing[] getListings(boolean separate) {
        IRaster3D.CellListing listing;
        if (this.d_cells.isEmpty() && this.d_xyCells.d_cells.isEmpty() && this.d_xzCells.d_cells.isEmpty() && this.d_yzCells.d_cells.isEmpty()) {
            return new IRaster3D.CellListing[0];
        }
        if (!separate) {
            IRaster3D.CellListing listing2 = new IRaster3D.CellListing();
            listing2.cell = this.getCellListings();
            listing2.xy = this.d_xyCells.getCellListings();
            listing2.xz = this.d_xzCells.getCellListings();
            listing2.yz = this.d_yzCells.getCellListings();
            return new IRaster3D.CellListing[]{listing2};
        }
        ArrayList<IRaster3D.CellListing> listings = new ArrayList<IRaster3D.CellListing>();
        HashSet<Point3i> closedCells = new HashSet<Point3i>();
        HashSet<Point3i> closedXY = new HashSet<Point3i>();
        HashSet<Point3i> closedXZ = new HashSet<Point3i>();
        HashSet<Point3i> closedYZ = new HashSet<Point3i>();
        for (Point3i cell : this.d_cells.keySet()) {
            listing = this.getTouchingCells(cell, null, null, null, closedCells, closedXY, closedXZ, closedYZ);
            if (listing == null) continue;
            listings.add(listing);
        }
        for (Point3i cell : this.d_xyCells.d_cells.keySet()) {
            listing = this.getTouchingCells(null, cell, null, null, closedCells, closedXY, closedXZ, closedYZ);
            if (listing == null) continue;
            listings.add(listing);
        }
        for (Point3i cell : this.d_xzCells.d_cells.keySet()) {
            listing = this.getTouchingCells(null, null, cell, null, closedCells, closedXY, closedXZ, closedYZ);
            if (listing == null) continue;
            listings.add(listing);
        }
        for (Point3i cell : this.d_yzCells.d_cells.keySet()) {
            listing = this.getTouchingCells(null, null, null, cell, closedCells, closedXY, closedXZ, closedYZ);
            if (listing == null) continue;
            listings.add(listing);
        }
        return listings.toArray(new IRaster3D.CellListing[listings.size()]);
    }

    private static Point3i[] calcCellAdj(Matrix3i xform) {
        return Raster3D_V2.xform(xform, new Point3i(-1, -1, -1), new Point3i(-1, 0, -1), new Point3i(-1, 1, -1), new Point3i(0, -1, -1), new Point3i(0, 1, -1), new Point3i(1, -1, -1), new Point3i(1, 0, -1), new Point3i(1, 1, -1), new Point3i(-1, -1, 0), new Point3i(-1, 0, 0), new Point3i(-1, 1, 0), new Point3i(0, -1, 0), new Point3i(0, 1, 0), new Point3i(1, -1, 0), new Point3i(1, 0, 0), new Point3i(1, 1, 0));
    }

    private static Point3i[] calcXYAdj(Matrix3i xform) {
        return Raster3D_V2.xform(xform, new Point3i(-1, -1, 0), new Point3i(-1, 0, 0), new Point3i(-1, 1, 0), new Point3i(0, -1, 0), new Point3i(0, 1, 0), new Point3i(1, -1, 0), new Point3i(1, 0, 0), new Point3i(1, 1, 0));
    }

    private static Point3i[] calcXZAdj(Matrix3i xform) {
        return Raster3D_V2.xform(xform, new Point3i(-1, 0, -1), new Point3i(0, 0, -1), new Point3i(1, 0, -1), new Point3i(-1, 0, 0), new Point3i(0, 0, 0), new Point3i(1, 0, 0), new Point3i(-1, 1, -1), new Point3i(0, 1, -1), new Point3i(1, 1, -1), new Point3i(-1, 1, 0), new Point3i(0, 1, 0), new Point3i(1, 1, 0));
    }

    private static Point3i[] calcYZAdj(Matrix3i xform) {
        return Raster3D_V2.xform(xform, new Point3i(0, -1, -1), new Point3i(0, 0, -1), new Point3i(0, 1, -1), new Point3i(0, -1, 0), new Point3i(0, 0, 0), new Point3i(0, 1, 0), new Point3i(1, -1, -1), new Point3i(1, 0, -1), new Point3i(1, 1, -1), new Point3i(1, -1, 0), new Point3i(1, 0, 0), new Point3i(1, 1, 0));
    }

    private static Point3i[] xform(Matrix3i xform, Point3i ... arr) {
        if (xform == null) {
            return arr;
        }
        for (int m = 0; m < arr.length; ++m) {
            arr[m] = xform.transform(arr[m]);
        }
        return arr;
    }

    private IRaster3D.CellListing getTouchingCells(Point3i cellSeed, Point3i xySeed, Point3i xzSeed, Point3i yzSeed, Set<Point3i> closedCells, Set<Point3i> closedXY, Set<Point3i> closedXZ, Set<Point3i> closedYZ) {
        ArrayDeque<Point3i> openCells = new ArrayDeque<Point3i>();
        ArrayDeque<Point3i> openXY = new ArrayDeque<Point3i>();
        ArrayDeque<Point3i> openXZ = new ArrayDeque<Point3i>();
        ArrayDeque<Point3i> openYZ = new ArrayDeque<Point3i>();
        if (cellSeed != null) {
            if (!closedCells.add(cellSeed)) {
                return null;
            }
            openCells.push(cellSeed);
        } else if (xySeed != null) {
            if (!closedXY.add(xySeed)) {
                return null;
            }
            openXY.push(xySeed);
        } else if (xzSeed != null) {
            if (!closedXZ.add(xzSeed)) {
                return null;
            }
            openXZ.push(xzSeed);
        } else if (yzSeed != null) {
            if (!closedYZ.add(yzSeed)) {
                return null;
            }
            openYZ.push(yzSeed);
        } else assert (false);
        ArrayList<Point3i> cellResult = new ArrayList<Point3i>();
        ArrayList<Point3i> xyResult = new ArrayList<Point3i>();
        ArrayList<Point3i> xzResult = new ArrayList<Point3i>();
        ArrayList<Point3i> yzResult = new ArrayList<Point3i>();
        Point3i tempLoc = new Point3i();
        while (!(openCells.isEmpty() && openXY.isEmpty() && openXZ.isEmpty() && openYZ.isEmpty())) {
            Point3i[] yzAdj;
            Point3i[] xzAdj;
            Point3i[] xyAdj;
            Point3i[] cellAdj;
            Point3i curr;
            if (!openCells.isEmpty()) {
                curr = (Point3i)openCells.pop();
                cellResult.add(curr);
                cellAdj = s_cellAdjCell;
                xyAdj = s_cellAdjXY;
                xzAdj = s_cellAdjXZ;
                yzAdj = s_cellAdjYZ;
            } else if (!openXY.isEmpty()) {
                curr = (Point3i)openXY.pop();
                xyResult.add(curr);
                cellAdj = s_xyAdjCell;
                xyAdj = s_xyAdjXY;
                xzAdj = s_xyAdjXZ;
                yzAdj = s_xyAdjYZ;
            } else if (!openXZ.isEmpty()) {
                curr = (Point3i)openXZ.pop();
                xzResult.add(curr);
                cellAdj = s_xzAdjCell;
                xyAdj = s_xzAdjXY;
                xzAdj = s_xzAdjXZ;
                yzAdj = s_xzAdjYZ;
            } else {
                curr = (Point3i)openYZ.pop();
                yzResult.add(curr);
                cellAdj = s_yzAdjCell;
                xyAdj = s_yzAdjXY;
                xzAdj = s_yzAdjXZ;
                yzAdj = s_yzAdjYZ;
            }
            Raster3D_V2.addAdjCells(curr, cellAdj, closedCells, openCells, this.d_cells, tempLoc);
            Raster3D_V2.addAdjCells(curr, xyAdj, closedXY, openXY, this.d_xyCells.d_cells, tempLoc);
            Raster3D_V2.addAdjCells(curr, xzAdj, closedXZ, openXZ, this.d_xzCells.d_cells, tempLoc);
            Raster3D_V2.addAdjCells(curr, yzAdj, closedYZ, openYZ, this.d_yzCells.d_cells, tempLoc);
        }
        if (cellResult.isEmpty() && xyResult.isEmpty() && xzResult.isEmpty() && yzResult.isEmpty()) {
            return null;
        }
        IRaster3D.CellListing listing = new IRaster3D.CellListing();
        listing.cell = this.getCellListings(cellResult);
        listing.xy = this.d_xyCells.getCellListings(xyResult);
        listing.xz = this.d_xzCells.getCellListings(xzResult);
        listing.yz = this.d_yzCells.getCellListings(yzResult);
        if (listing.cell.length == 0 && listing.xy.length == 0 && listing.xz.length == 0 && listing.yz.length == 0) {
            return null;
        }
        return listing;
    }

    private static void addAdjCells(Point3i cell, Point3i[] cellAdj, Set<Point3i> closed, Deque<Point3i> open, Map<Point3i, ?> raster, Point3i tempLoc) {
        for (Point3i adj : cellAdj) {
            tempLoc.add(cell, adj);
            if (!raster.containsKey(tempLoc) || closed.contains(tempLoc)) continue;
            Point3i np = new Point3i(tempLoc);
            closed.add(np);
            open.push(np);
        }
    }

    private Pair<Point3i, int[]>[] getCellListings() {
        return this.getCellListings(this.d_cells.keySet());
    }

    private Pair<Point3i, int[]>[] getCellListings(Collection<Point3i> cells) {
        Point3i tempp = new Point3i();
        ArrayList<Pair<Point3i, int[]>> listing = new ArrayList<Pair<Point3i, int[]>>(cells.size());
        for (Point3i loc : cells) {
            int id = this.d_cells.get(loc);
            tempp.set(loc);
            Cell minz = (Cell)this.d_xyCells.d_cells.get(tempp);
            Cell miny = (Cell)this.d_xzCells.d_cells.get(tempp);
            Cell minx = (Cell)this.d_yzCells.d_cells.get(tempp);
            tempp.set(loc.x, loc.y, loc.z + 1);
            Cell maxz = (Cell)this.d_xyCells.d_cells.get(tempp);
            tempp.set(loc.x, loc.y + 1, loc.z);
            Cell maxy = (Cell)this.d_xzCells.d_cells.get(tempp);
            tempp.set(loc.x + 1, loc.y, loc.z);
            Cell maxx = (Cell)this.d_yzCells.d_cells.get(tempp);
            int minxid = minx != null ? minx.minid : id;
            int maxxid = maxx != null ? maxx.maxid : id;
            int minyid = miny != null ? miny.minid : id;
            int maxyid = maxy != null ? maxy.maxid : id;
            int minzid = minz != null ? minz.minid : id;
            int maxzid = maxz != null ? maxz.maxid : id;
            int[] ids = new int[]{minxid, maxxid, minyid, maxyid, minzid, maxzid};
            if (Raster3D_V2.areAllSame(ids)) {
                ids = new int[]{minxid};
            }
            listing.add(new Pair<Point3i, int[]>(loc, ids));
        }
        return listing.toArray(new Pair[listing.size()]);
    }

    private static boolean areAllSame(int[] vals) {
        int v = vals[0];
        for (int m = 1; m < vals.length; ++m) {
            if (vals[m] == v) continue;
            return false;
        }
        return true;
    }

    private void addCell(Point3i cellIx, Integer id) {
        this.d_cells.put(new Point3i(cellIx), id);
    }

    @Override
    public void rasterizeShell(boolean thicken, int internalId, int[] groups, Point3d[][] polys) {
        Thickener thickener = new Thickener(thicken, internalId, groups, polys);
        for (int m = 0; m < groups.length; ++m) {
            Collection<Edgei> collapsed = this.rasterizeSimplePolygon(2, groups[m], polys[m]);
            thickener.addCollapsedEdges(m, collapsed);
        }
        thickener.finish(this);
    }

    public Collection<Edgei> rasterizeSimplePolygon(int count, int group, Point3d ... poly) {
        this.setCurrentGroup(group);
        Point3d[] clippedPoly = this.clipPoly(poly);
        clippedPoly = Raster3D_V2.deleteAdjacentDuplicates(1.0E-9, clippedPoly);
        if (clippedPoly.length < 3) {
            return Collections.emptyList();
        }
        return this.rasterizeClippedPoly(count, clippedPoly);
    }

    private Point3i getRoundedIx(Point3d p) {
        return new Point3i(Raster3D_V2.getRoundedCoord(this.d_xDiv, p.x), Raster3D_V2.getRoundedCoord(this.d_yDiv, p.y), Raster3D_V2.getRoundedCoord(this.d_zDiv, p.z));
    }

    private static int getRoundedCoord(double[] arr, double val) {
        int ix = Arrays.binarySearch(arr, val);
        if (ix < 0) {
            if ((ix = -(ix + 1)) == 0) {
                return 0;
            }
            if (ix == arr.length) {
                return arr.length - 1;
            }
            double lower = arr[ix - 1];
            double upper = arr[ix];
            return theUtil.le(val - lower, upper - val, 1.0E-9) ? ix - 1 : ix;
        }
        return ix;
    }

    private static int compareNorm(int v1, int v2) {
        if (v1 < v2) {
            return -1;
        }
        if (v1 > v2) {
            return 1;
        }
        return 0;
    }

    private void rasterizeLineSeg(Point3d p1, Point3d p2, Point3i p1i, Point3i p2i, Point3i[] testIncs, Point3d testPoint, Point3i nextCell, ScanLineBoundsAdder boundsAdder) {
        if (p2.x < p1.x || p2.x == p1.x && p2.y < p1.y || p2.x == p1.x && p2.y == p1.y && p2.z < p1.z) {
            Point3d temp = p1;
            p1 = p2;
            p2 = temp;
            Point3i temp2 = p1i;
            p1i = p2i;
            p2i = temp2;
        }
        this.rasterizeLineSeg(p1, p2, p1i, p2i, testIncs, nextCell, testPoint, boundsAdder);
    }

    private void rasterizeLineSeg(Point3d p1, Point3d p2, Point3i p1i, Point3i p2i, Point3i[] testIncs, Point3i tempP3i, Point3d tempP3d, ScanLineBoundsAdder boundsAdder) {
        int xdir = Raster3D_V2.compareNorm(p2i.x, p1i.x);
        int ydir = Raster3D_V2.compareNorm(p2i.y, p1i.y);
        int zdir = Raster3D_V2.compareNorm(p2i.z, p1i.z);
        Point3i curr = p1i;
        Point3i next = tempP3i;
        next.set(curr);
        while (!curr.equals(p2i)) {
            boolean canChangez;
            boolean canChangex = curr.x != p2i.x;
            boolean canChangey = curr.y != p2i.y;
            boolean bl = canChangez = curr.z != p2i.z;
            if (canChangex && !canChangey && !canChangez) {
                next.x += xdir;
            } else if (!canChangex && canChangey && !canChangez) {
                next.y += ydir;
            } else if (!canChangex && !canChangey && canChangez) {
                next.z += zdir;
            } else {
                boolean checkYZ;
                boolean checkXY = canChangex && canChangey;
                boolean checkXZ = canChangex && !canChangey && canChangez;
                boolean bl2 = checkYZ = !canChangex && canChangey && canChangez;
                if (checkXY) {
                    double distxXY = Inter2D.distSqToNearestPtOnLine2(p1.x, p1.y, p2.x, p2.y, this.d_xDiv[curr.x + xdir], this.d_yDiv[curr.y]);
                    double distyXY = Inter2D.distSqToNearestPtOnLine2(p1.x, p1.y, p2.x, p2.y, this.d_xDiv[curr.x], this.d_yDiv[curr.y + ydir]);
                    if (canChangez) {
                        checkXZ = theUtil.le(distxXY, distyXY, 1.0E-12);
                        checkYZ = !checkXZ;
                    } else if (theUtil.le(distxXY, distyXY, 1.0E-12)) {
                        next.x += xdir;
                    } else {
                        next.y += ydir;
                    }
                }
                if (checkXZ) {
                    double distzXZ;
                    double distxXZ = Inter2D.distSqToNearestPtOnLine2(p1.x, p1.z, p2.x, p2.z, this.d_xDiv[curr.x + xdir], this.d_zDiv[curr.z]);
                    if (theUtil.le(distxXZ, distzXZ = Inter2D.distSqToNearestPtOnLine2(p1.x, p1.z, p2.x, p2.z, this.d_xDiv[curr.x], this.d_zDiv[curr.z + zdir]), 1.0E-12)) {
                        next.x += xdir;
                    } else {
                        next.z += zdir;
                    }
                }
                if (checkYZ) {
                    double distzYZ;
                    double distyYZ = Inter2D.distSqToNearestPtOnLine2(p1.y, p1.z, p2.y, p2.z, this.d_yDiv[curr.y + ydir], this.d_zDiv[curr.z]);
                    if (theUtil.le(distyYZ, distzYZ = Inter2D.distSqToNearestPtOnLine2(p1.y, p1.z, p2.y, p2.z, this.d_yDiv[curr.y], this.d_zDiv[curr.z + zdir]), 1.0E-12)) {
                        next.y += ydir;
                    } else {
                        next.z += zdir;
                    }
                }
            }
            if (boundsAdder != null) {
                boundsAdder.add(curr, next);
            }
            curr = new Point3i(next);
        }
    }

    private Collection<Edgei> rasterizeClippedPoly(int count, Point3d ... points) {
        Point3i min = new Point3i(this.d_xDiv.length - 1, this.d_yDiv.length - 1, this.d_zDiv.length - 1);
        Point3i max = new Point3i(0, 0, 0);
        Point3i[] ipoints = new Point3i[points.length];
        for (int m = 0; m < points.length; ++m) {
            Point3i rp;
            ipoints[m] = rp = this.getRoundedIx(points[m]);
            if (rp.x < min.x) {
                min.x = rp.x;
            }
            if (rp.x > max.x) {
                max.x = rp.x;
            }
            if (rp.y < min.y) {
                min.y = rp.y;
            }
            if (rp.y > max.y) {
                max.y = rp.y;
            }
            if (rp.z < min.z) {
                min.z = rp.z;
            }
            if (rp.z <= max.z) continue;
            max.z = rp.z;
        }
        Point3i[] testIncs = new Point3i[]{new Point3i(), new Point3i(), new Point3i()};
        Point3i tempP3i = new Point3i();
        Point3d tempP3d = new Point3d();
        Plane3d plane = new Plane3d(true, points);
        ScanLineBoundsAdder scanBoundsAdder = new ScanLineBoundsAdder(plane, min, max);
        for (int m = 0; m < points.length; ++m) {
            int m2 = (m + 1) % points.length;
            Point3d p1 = points[m];
            Point3d p2 = points[m2];
            Point3i p1i = ipoints[m];
            Point3i p2i = ipoints[m2];
            this.rasterizeLineSeg(p1, p2, p1i, p2i, testIncs, tempP3d, tempP3i, scanBoundsAdder);
        }
        scanBoundsAdder.sortScans();
        if (scanBoundsAdder.d_planeAlign == 0) {
            Raster3D_V2.rasterizeLocalPoly(count, this.d_currGroup, this.d_xDiv, this.d_yDiv, this.d_zDiv, plane, min.x, max.x, min.y, max.y, scanBoundsAdder.xScanBounds, scanBoundsAdder.yScanBounds, this.d_xyCells, this.d_xzCells, this.d_yzCells, s_xyLWXform, new Matrix3d(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0));
        } else if (scanBoundsAdder.d_planeAlign == 1) {
            Raster3D_V2.rasterizeLocalPoly(count, this.d_currGroup, this.d_xDiv, this.d_zDiv, this.d_yDiv, plane, min.x, max.x, min.z, max.z, scanBoundsAdder.xScanBounds, scanBoundsAdder.yScanBounds, this.d_xzCells, this.d_xyCells, this.d_yzCells, s_xzLWXform, new Matrix3d(1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0));
        } else {
            Raster3D_V2.rasterizeLocalPoly(count, this.d_currGroup, this.d_yDiv, this.d_zDiv, this.d_xDiv, plane, min.y, max.y, min.z, max.z, scanBoundsAdder.xScanBounds, scanBoundsAdder.yScanBounds, this.d_yzCells, this.d_xyCells, this.d_xzCells, s_yzLWXform, new Matrix3d(0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0));
        }
        return scanBoundsAdder.getCollapsedEdges();
    }

    private static void rasterizeLocalPoly(int count, int currGroup, double[] xDiv, double[] yDiv, double[] zDiv, Plane3d plane, int bminx, int bmaxx, int bminy, int bmaxy, List<int[]>[] xScanBounds, List<int[]>[] yScanBounds, CellList xyCells, CellList xzCells, CellList yzCells, Matrix3i lwXformi, Matrix3d lwXformd) {
        int maxz;
        int minz;
        int[] s2;
        int[] s1;
        int o;
        List<int[]> scans;
        int m;
        Point3d tempP3d = new Point3d();
        Point3d tempP3d2 = new Point3d();
        Point3i[] testIncs = new Point3i[]{new Point3i(), new Point3i()};
        int[][] zRestrictions = new int[bmaxx - bminx + 2][bmaxy - bminy + 2];
        for (m = 0; m < zRestrictions.length; ++m) {
            Arrays.fill(zRestrictions[m], -1);
        }
        for (m = 0; m < yScanBounds.length; ++m) {
            scans = yScanBounds[m];
            if (scans == null) continue;
            int y = m + bminy;
            assert (scans.size() % 2 == 0);
            o = 0;
            while (o + 1 < scans.size()) {
                int n;
                s1 = scans.get(o);
                s2 = scans.get(o + 1);
                int minx = s1[0];
                minz = s1[1];
                int maxx = s2[0];
                maxz = s2[1];
                int zdir = Raster3D_V2.compareNorm(maxz, minz);
                if (minx != maxx && zdir == 0) {
                    for (n = minx; n < maxx; ++n) {
                        xyCells.addCell(count, lwXformi.transform(new Point3i(n, y, minz)), currGroup, plane);
                        zRestrictions[n - bminx + 1][y - bminy + 1] = minz;
                    }
                } else if (minx == maxx && zdir != 0) {
                    for (n = minz; n != maxz; n += zdir) {
                        yzCells.addCell(count, lwXformi.transform(new Point3i(minx, y, Math.min(n, n + zdir))), currGroup, plane);
                    }
                } else if (minx != maxx || zdir != 0) {
                    int closestFace;
                    testIncs[0].set(1, 0, 0);
                    testIncs[1].set(0, 0, zdir);
                    tempP3d.y = (yDiv[y] + yDiv[y + 1]) * 0.5;
                    int currx = minx;
                    for (int currz = minz; currx != maxx || currz != maxz; currx += testIncs[closestFace].x, currz += testIncs[closestFace].z) {
                        closestFace = -1;
                        double closestDist = Double.MAX_VALUE;
                        for (int n2 = 0; n2 < 2; ++n2) {
                            Point3i inc = testIncs[n2];
                            int nextx = currx + inc.x;
                            int nextz = currz + inc.z;
                            if (inc.x != 0 && currx == maxx || inc.z != 0 && currz == maxz) continue;
                            tempP3d.x = xDiv[nextx];
                            tempP3d.z = zDiv[nextz];
                            lwXformd.transform(tempP3d, tempP3d2);
                            double dist = plane.distance(tempP3d2);
                            if (!theUtil.lt(dist, closestDist, 1.0E-12)) continue;
                            closestFace = n2;
                            closestDist = dist;
                        }
                        assert (closestDist != Double.MAX_VALUE);
                        if (closestFace == 0) {
                            xyCells.addCell(count, lwXformi.transform(new Point3i(currx, y, currz)), currGroup, plane);
                            zRestrictions[currx - bminx + 1][y - bminy + 1] = currz;
                            continue;
                        }
                        yzCells.addCell(count, lwXformi.transform(new Point3i(currx, y, Math.min(currz, currz + testIncs[closestFace].z))), currGroup, plane);
                    }
                }
                o += 2;
            }
        }
        for (m = 0; m < xScanBounds.length; ++m) {
            scans = xScanBounds[m];
            if (scans == null) continue;
            int x = m + bminx;
            assert (scans.size() % 2 == 0);
            o = 0;
            while (o + 1 < scans.size()) {
                s1 = scans.get(o);
                s2 = scans.get(o + 1);
                int miny = s1[0];
                minz = s1[1];
                int maxy = s2[0];
                maxz = s2[1];
                int curry = miny;
                int currz = minz;
                while (curry != maxy || currz != maxz) {
                    int desiredZ = curry == maxy ? maxz : zRestrictions[x - bminx + 1][curry - bminy + 1];
                    int dir = Raster3D_V2.compareNorm(desiredZ, currz);
                    assert (desiredZ >= 0);
                    if (dir == 0) {
                        ++curry;
                        continue;
                    }
                    xzCells.addCell(count, lwXformi.transform(new Point3i(x, curry, Math.min(currz, currz + dir))), currGroup, plane);
                    currz += dir;
                }
                o += 2;
            }
        }
    }

    private void getCellBounds(AABox bounds, Point3i cellIx) {
        bounds.addPoint(this.d_xDiv[cellIx.x], this.d_yDiv[cellIx.y], this.d_zDiv[cellIx.z]);
        bounds.addPoint(this.d_xDiv[cellIx.x + 1], this.d_yDiv[cellIx.y + 1], this.d_zDiv[cellIx.z + 1]);
    }

    private int[] getFaceBounds() {
        int[] bounds = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE};
        this.d_xyCells.getBounds(bounds);
        this.d_yzCells.getBounds(bounds);
        this.d_xzCells.getBounds(bounds);
        return bounds;
    }

    private void thicken(int fillGroup, GetThickenId getThickenId) {
        int[] faceBounds = this.getFaceBounds();
        this.thicken(fillGroup, getThickenId, new int[]{0, 1, 2}, this.d_zDiv.length, this.d_xyCells, this.d_xzCells, this.d_yzCells, new int[]{faceBounds[0], faceBounds[1]}, new int[]{faceBounds[2], faceBounds[3]}, new int[]{faceBounds[4], faceBounds[5]});
        this.thicken(fillGroup, getThickenId, new int[]{0, 2, 1}, this.d_yDiv.length, this.d_xzCells, this.d_xyCells, this.d_yzCells, new int[]{faceBounds[0], faceBounds[1]}, new int[]{faceBounds[4], faceBounds[5]}, new int[]{faceBounds[2], faceBounds[3]});
        this.thicken(fillGroup, getThickenId, new int[]{1, 2, 0}, this.d_xDiv.length, this.d_yzCells, this.d_xyCells, this.d_xzCells, new int[]{faceBounds[2], faceBounds[3]}, new int[]{faceBounds[4], faceBounds[5]}, new int[]{faceBounds[0], faceBounds[1]});
        this.removeInternalFaces();
    }

    private void thicken(int internalID, GetThickenId getThickenId, int[] swizzle, int numZDivs, CellList xylist, CellList xzlist, CellList yzlist, int[] xbounds, int[] ybounds, int[] zbounds) {
        Integer id = internalID;
        int[] vals = new int[3];
        Point3i tempp = new Point3i();
        Point3i tempp1 = new Point3i();
        Point3i tempp2 = new Point3i();
        Point3i tempp3 = new Point3i();
        Point3i tempp4 = new Point3i();
        Edgei testEdge = new Edgei(new Point3i(), new Point3i());
        QuadFunction<Point3i, Point3i, Vector3d, Integer, IntSupplier> getIdFunc = (e1, e2, normal, backupId) -> () -> {
            testEdge.set((Point3i)e1, (Point3i)e2);
            return getThickenId.get(testEdge, (Vector3d)normal, (int)backupId);
        };
        for (int z = zbounds[0]; z <= zbounds[1]; ++z) {
            for (int y = ybounds[0]; y <= ybounds[1]; ++y) {
                for (int x = xbounds[0]; x <= xbounds[1]; ++x) {
                    int thickenID;
                    int thickenDir;
                    Raster3D_V2.swizzle(swizzle, x, y, z, vals, tempp);
                    Cell cell = (Cell)xylist.d_cells.get(tempp);
                    if (cell == null || cell.count % 2 != 0) continue;
                    boolean filledAbove = this.d_cells.containsKey(tempp);
                    Raster3D_V2.swizzle(swizzle, x, y, z - 1, vals, tempp);
                    boolean filledBelow = this.d_cells.containsKey(tempp);
                    if (filledAbove || filledBelow) continue;
                    if (z == 0) {
                        thickenDir = 1;
                        thickenID = cell.maxid;
                    } else if (z == numZDivs - 1) {
                        thickenDir = -1;
                        thickenID = cell.minid;
                    } else if (cell.maxdist >= 0.0 && cell.mindist >= 0.0) {
                        thickenDir = 1;
                        thickenID = cell.maxid;
                    } else if (cell.maxdist <= 0.0 && cell.mindist <= 0.0) {
                        thickenDir = -1;
                        thickenID = cell.minid;
                    } else {
                        thickenDir = Math.abs(cell.maxdist) >= Math.abs(cell.mindist) ? 1 : -1;
                        thickenID = thickenDir == 1 ? cell.maxid : cell.minid;
                    }
                    cell.addPhantom();
                    Raster3D_V2.swizzle(swizzle, x, y, z + thickenDir, vals, tempp);
                    xylist.addPhantom(tempp, () -> thickenID);
                    int zloc = thickenDir < 0 ? z + thickenDir : z;
                    Raster3D_V2.swizzle(swizzle, x, y, z, vals, tempp1);
                    Raster3D_V2.swizzle(swizzle, x + 1, y, z, vals, tempp2);
                    Raster3D_V2.swizzle(swizzle, x + 1, y + 1, z, vals, tempp3);
                    Raster3D_V2.swizzle(swizzle, x, y + 1, z, vals, tempp4);
                    Raster3D_V2.swizzle(swizzle, x, y, zloc, vals, tempp);
                    xzlist.addPhantom(tempp, getIdFunc.apply(tempp1, tempp2, xzlist.d_dir, thickenID));
                    yzlist.addPhantom(tempp, getIdFunc.apply(tempp4, tempp1, yzlist.d_dir, thickenID));
                    Raster3D_V2.swizzle(swizzle, x + 1, y, zloc, vals, tempp);
                    yzlist.addPhantom(tempp, getIdFunc.apply(tempp2, tempp3, yzlist.d_dir, thickenID));
                    Raster3D_V2.swizzle(swizzle, x, y + 1, zloc, vals, tempp);
                    xzlist.addPhantom(tempp, getIdFunc.apply(tempp3, tempp4, xzlist.d_dir, thickenID));
                    Integer fillId = cell.maxid == cell.minid ? cell.maxid : id;
                    Raster3D_V2.swizzle(swizzle, x, y, zloc, vals, tempp);
                    this.addCell(tempp, fillId);
                }
            }
        }
    }

    private static void swizzle(int[] swizzle, int lx, int ly, int lz, int[] result, Point3i p) {
        Raster3D_V2.swizzle(swizzle, lx, ly, lz, result);
        p.set(result);
    }

    private static void swizzle(int[] swizzle, int lx, int ly, int lz, int[] result) {
        result[swizzle[0]] = lx;
        result[swizzle[1]] = ly;
        result[swizzle[2]] = lz;
    }

    public void fill(int internalID) {
        Integer id = internalID;
        Point3i tempp = new Point3i();
        int[] faceBounds = this.getFaceBounds();
        for (int y = faceBounds[2]; y <= faceBounds[3]; ++y) {
            for (int x = faceBounds[0]; x <= faceBounds[1]; ++x) {
                int prevz = -1;
                for (int z = faceBounds[4]; z <= faceBounds[5]; ++z) {
                    tempp.set(x, y, z);
                    Cell cell = (Cell)this.d_xyCells.d_cells.get(tempp);
                    if (cell == null || cell.count % 2 == 0) continue;
                    if (prevz == -1) {
                        prevz = z;
                        continue;
                    }
                    for (int m = prevz; m < z; ++m) {
                        this.d_cells.put(new Point3i(x, y, m), id);
                    }
                    prevz = -1;
                }
            }
        }
    }

    public void removeInternalFaces() {
        this.removeInternalFaces(this.d_xyCells, new int[]{0, 0, 1});
        this.removeInternalFaces(this.d_xzCells, new int[]{0, 1, 0});
        this.removeInternalFaces(this.d_yzCells, new int[]{1, 0, 0});
    }

    private void removeInternalFaces(CellList xyCells, int[] zdir) {
        Point3i tempp = new Point3i();
        Iterator it = xyCells.d_cells.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Point3i loc = (Point3i)entry.getKey();
            boolean above = this.d_cells.containsKey(loc);
            tempp.set(loc.x - zdir[0], loc.y - zdir[1], loc.z - zdir[2]);
            boolean below = this.d_cells.containsKey(tempp);
            if (!above || !below) continue;
            it.remove();
        }
    }

    @Override
    public void rasterizeSolid(boolean thicken, int fillGroup, int[] faceGroups, Point3d[][] polyPoints) {
        Pair<Point3d[][], int[]> clipped = this.clipVolume(polyPoints, faceGroups, fillGroup);
        if (clipped == null) {
            return;
        }
        polyPoints = (Point3d[][])clipped.v1;
        faceGroups = (int[])clipped.v2;
        Thickener thickener = new Thickener(thicken, fillGroup, faceGroups, polyPoints);
        for (int m = 0; m < polyPoints.length; ++m) {
            this.setCurrentGroup(faceGroups[m]);
            Collection<Edgei> pCollapsedEdges = this.rasterizeClippedPoly(1, polyPoints[m]);
            thickener.addCollapsedEdges(m, pCollapsedEdges);
        }
        this.fill(fillGroup);
        this.removeInternalFaces();
        thickener.finish(this);
    }

    private static Integer getUnusedId(int[] ffaceGroups, int fillId) {
        HashSet<Integer> usedGroups = new HashSet<Integer>();
        for (int faceGroup : ffaceGroups) {
            usedGroups.add(faceGroup);
        }
        Random rand = new Random();
        for (int m = 0; m < 10; ++m) {
            Integer id = rand.nextInt();
            if (usedGroups.contains(id)) continue;
            return id;
        }
        System.err.println(Raster3D_V2.class.getSimpleName() + ": Using slow search for unused group ID");
        Integer m = Integer.MIN_VALUE;
        while (m < Integer.MAX_VALUE) {
            if (!usedGroups.contains(m)) {
                return m;
            }
            m = m + 1;
        }
        assert (false);
        System.err.println(Raster3D_V2.class.getSimpleName() + ": Could not determine unused ID");
        return fillId;
    }

    private Pair<Point3d[][], int[]> clipVolume(Point3d[][] volume, int[] groups, int innerGroup) {
        Random rand = new Random(1L);
        Point3d[][] origVol = volume;
        Plane3d[] facePlanes = null;
        for (ConvexPolygon gridFace : this.d_rastVolume.d_polys) {
            ArrayList<Integer> newGroups = new ArrayList<Integer>(groups.length);
            ArrayList<Point3d[]> clippedVolFaces = new ArrayList<Point3d[]>(volume.length);
            ArrayList<Point3d> isectPoints = new ArrayList<Point3d>();
            for (int m = 0; m < volume.length; ++m) {
                Point3d[] volFace = volume[m];
                volFace = Raster3D_V2.clipPolyToPoly(isectPoints, gridFace, volFace);
                if ((volFace = Raster3D_V2.deleteAdjacentDuplicates(1.0E-9, volFace)).length < 3) continue;
                clippedVolFaces.add(volFace);
                newGroups.add(groups[m]);
            }
            if (isectPoints.isEmpty() && volume.length == clippedVolFaces.size()) {
                if (!clippedVolFaces.isEmpty()) continue;
                return new Pair<Point3d[][], int[]>(new Point3d[0][0], new int[0]);
            }
            if (!isectPoints.isEmpty()) {
                assert (isectPoints.size() % 2 == 0);
                ArrayList<LineSeg3D> edges = new ArrayList<LineSeg3D>(isectPoints.size() / 2);
                int m = 0;
                while (m + 1 < isectPoints.size()) {
                    Point3d p1 = (Point3d)isectPoints.get(m);
                    Point3d p2 = (Point3d)isectPoints.get(m + 1);
                    edges.add(new LineSeg3D(p1, p2));
                    m += 2;
                }
                Model model = new Model();
                model.addFace(0, gridFace.d_plane, edges);
                if (facePlanes == null && !model.getFaces().isEmpty()) {
                    ArrayList<Plane3d> validPlanes = new ArrayList<Plane3d>(origVol.length);
                    ArrayList<Point3d[]> validFaces = new ArrayList<Point3d[]>(origVol.length);
                    for (int m2 = 0; m2 < origVol.length; ++m2) {
                        Plane3d plane = Util3D.simplePolygonPlane(Arrays.asList(origVol[m2]), true);
                        if (plane == null) continue;
                        validPlanes.add(plane);
                        validFaces.add(origVol[m2]);
                    }
                    facePlanes = validPlanes.toArray(new Plane3d[validPlanes.size()]);
                    origVol = (Point3d[][])validFaces.toArray((T[])new Point3d[validFaces.size()][]);
                }
                for (Face face : model.getFaces()) {
                    Point3d[] fp;
                    if (!Raster3D_V2.faceInSolid(model, face, origVol, facePlanes, rand) || (fp = Raster3D_V2.toPointFace(face)).length < 3) continue;
                    clippedVolFaces.add(fp);
                    newGroups.add(innerGroup);
                }
            }
            volume = (Point3d[][])clippedVolFaces.toArray((T[])new Point3d[clippedVolFaces.size()][]);
            groups = theUtil.toIntArray(newGroups);
        }
        return new Pair<Point3d[][], int[]>(volume, groups);
    }

    private static Point3d[] toPointFace(Face face) {
        ArrayList<Point3d> points = new ArrayList<Point3d>();
        for (FaceLoop loop : face.edgeLoops) {
            for (EdgeUse eu : loop.edges) {
                points.add(eu.v1().loc);
            }
            if (loop.edges.isEmpty()) continue;
            points.add(loop.edges.get((int)0).v1().loc);
        }
        Point3d[] pts = points.toArray(new Point3d[points.size()]);
        pts = Raster3D_V2.deleteAdjacentDuplicates(1.0E-9, pts);
        return pts;
    }

    private static boolean faceInSolid(Model faceModel, Face face, Point3d[][] solid, Plane3d[] solidFacePlanes, Random rand) {
        Point3d p = faceModel.findPointInFace(face);
        if (p == null) {
            return false;
        }
        Vector3d testvec = Raster3D_V2.newRandomVec3D(rand);
        int numIsects = 0;
        for (int m = 0; m < solid.length; ++m) {
            Point3d[] solidFace = solid[m];
            double isect = Raster3D_V2.isect(p, testvec, solidFace, solidFacePlanes[m], rand);
            if (Double.isNaN(isect)) continue;
            Point3d isectPoint = Util3D.linePoint(p, testvec, isect);
            if (isectPoint.epsilonEquals(p, 1.0E-6)) {
                return true;
            }
            ++numIsects;
        }
        return numIsects % 2 != 0;
    }

    private static double isect(Point3d lp, Vector3d ldir, Point3d[] face, Plane3d facePlane, Random rand) {
        double isect = Inter3D.linePlaneIntersectionT(lp, ldir, facePlane, 1.0E-6);
        if (Double.isNaN(isect) || theUtil.lt0(isect, 1.0E-6)) {
            return Double.NaN;
        }
        Point3d p = Util3D.linePoint(lp, ldir, isect);
        return Raster3D_V2.pointInFace(p, face, facePlane, rand) ? isect : Double.NaN;
    }

    private static boolean pointInFace(Point3d p, Point3d[] face, Plane3d plane, Random rand) {
        Vector3d faceNorm = plane.getNormal();
        Vector3d testVec = Raster3D_V2.newRandomVec3D(rand);
        testVec.normalize();
        for (int m = 0; m < 3 && testVec.equals(faceNorm); ++m) {
            testVec = Raster3D_V2.newRandomVec3D(rand);
            testVec.normalize();
        }
        Point3d projp = plane.projectOntoPlane(Util3D.add(p, (Tuple3d)testVec));
        testVec.sub(projp, p);
        testVec.normalize();
        int isects = 0;
        double[] st = new double[2];
        for (int m = 0; m < face.length; ++m) {
            Point3d p1 = face[m];
            Point3d p2 = face[(m + 1) % face.length];
            if (!Inter3D.copLineLineSeg(p, testVec, p1, p2, st, 1.0E-6, 1.0E-6) || !theUtil.ge0(st[0], 1.0E-6)) continue;
            if (theUtil.eq0(st[0], 1.0E-6)) {
                return true;
            }
            ++isects;
        }
        return isects % 2 != 0;
    }

    private static double randomVecComp(Random rand) {
        return rand.nextDouble() * 2.0 - 1.0;
    }

    private static Vector3d newRandomVec3D(Random rand) {
        return new Vector3d(Raster3D_V2.randomVecComp(rand), Raster3D_V2.randomVecComp(rand), Raster3D_V2.randomVecComp(rand));
    }

    private Point3d[] clipPoly(Point3d ... poly) {
        Point3d[] result = poly;
        for (ConvexPolygon clipPoly : this.d_rastVolume.d_polys) {
            result = Raster3D_V2.clipPolyToPoly(null, clipPoly, result);
        }
        return result;
    }

    private static Point3d[] clipPolyToPoly(List<Point3d> isectPoints, ConvexPolygon clipPoly, Point3d ... poly) {
        LinkedList<Point3d> result = new LinkedList<Point3d>();
        for (int m = 0; m < poly.length; ++m) {
            Point3d intersection;
            Point3d p1 = poly[m];
            Point3d p2 = poly[(m + 1) % poly.length];
            boolean p1Pos = theUtil.ge0(clipPoly.d_plane.dot(p1), 1.0E-6);
            boolean p2Pos = theUtil.ge0(clipPoly.d_plane.dot(p2), 1.0E-6);
            if (p1Pos) {
                result.add(p1);
            }
            if (p1Pos && p2Pos || !p1Pos && !p2Pos || !Inter3D.linePlaneIntersection(intersection = new Point3d(), p1, p2, clipPoly.d_plane, 0.0)) continue;
            result.add(intersection);
            if (isectPoints == null) continue;
            isectPoints.add(intersection);
        }
        return result.toArray(new Point3d[result.size()]);
    }

    private static <T> T[] deleteAdjacentDuplicates(Class<T> type, T ... points) {
        if (points.length <= 1) {
            return points;
        }
        ArrayList<T> uniquePoints = new ArrayList<T>(points.length);
        for (int m = 0; m < points.length; ++m) {
            T currPoint = points[m];
            T nextPoint = points[(m + 1) % points.length];
            if (currPoint.equals(nextPoint)) continue;
            uniquePoints.add(currPoint);
        }
        if (uniquePoints.size() != points.length) {
            Object[] arr = (Object[])Array.newInstance(type, uniquePoints.size());
            return uniquePoints.toArray(arr);
        }
        return points;
    }

    private static Point3d[] deleteAdjacentDuplicates(double tol, Point3d ... points) {
        if (points.length <= 1) {
            return points;
        }
        ArrayList<Point3d> uniquePoints = new ArrayList<Point3d>(points.length);
        for (int m = 0; m < points.length; ++m) {
            Point3d currPoint = points[m];
            Point3d nextPoint = points[(m + 1) % points.length];
            if (currPoint.epsilonEquals(nextPoint, tol)) continue;
            uniquePoints.add(currPoint);
        }
        if (uniquePoints.size() != points.length) {
            return uniquePoints.toArray(new Point3d[uniquePoints.size()]);
        }
        return points;
    }

    private static class Cell {
        public int minid;
        public int maxid;
        public double mindist;
        public double maxdist;
        public int count;

        public Cell(int count, int id, double dist) {
            this.minid = this.maxid = id;
            this.mindist = this.maxdist = dist;
            this.count = count;
        }

        public void add(int count, int id, double dist) {
            if (dist >= this.maxdist) {
                this.maxdist = dist;
                this.maxid = id;
            } else if (dist < this.mindist) {
                this.mindist = dist;
                this.minid = id;
            }
            this.count += count;
        }

        public void addPhantom() {
            ++this.count;
        }

        public void merge(Cell cell) {
            if (cell.maxdist >= this.maxdist) {
                this.maxdist = cell.maxdist;
                this.maxid = cell.maxid;
            }
            if (cell.mindist <= this.mindist) {
                this.mindist = cell.mindist;
                this.minid = cell.minid;
            }
            this.count += cell.count;
        }
    }

    public class CellList {
        private final int[] d_adds;
        private final Vector3d d_dir;
        private Map<Point3i, Cell> d_cells;

        public CellList(Dir dir) {
            switch (dir) {
                case X: {
                    this.d_dir = new Vector3d(1.0, 0.0, 0.0);
                    this.d_adds = new int[]{0, 1, 1};
                    break;
                }
                case Y: {
                    this.d_dir = new Vector3d(0.0, 1.0, 0.0);
                    this.d_adds = new int[]{1, 0, 1};
                    break;
                }
                default: {
                    this.d_dir = new Vector3d(0.0, 0.0, 1.0);
                    this.d_adds = new int[]{1, 1, 0};
                }
            }
            this.d_cells = new LinkedHashMap<Point3i, Cell>();
        }

        public void clear() {
            this.d_cells.clear();
        }

        public Pair<Point3i, int[]>[] getCellListings() {
            return this.getCellListings(this.d_cells.keySet());
        }

        public Pair<Point3i, int[]>[] getCellListings(Collection<Point3i> cells) {
            Point3i dir = new Point3i((int)this.d_dir.x, (int)this.d_dir.y, (int)this.d_dir.z);
            Point3i tempp = new Point3i();
            ArrayList<Pair<Point3i, int[]>> listings = new ArrayList<Pair<Point3i, int[]>>();
            for (Point3i loc : cells) {
                boolean above = Raster3D_V2.this.d_cells.containsKey(loc);
                tempp.sub(loc, dir);
                boolean below = Raster3D_V2.this.d_cells.containsKey(tempp);
                if (above || below) continue;
                Cell cell = this.d_cells.get(loc);
                listings.add(new Pair<Point3i, int[]>(loc, new int[]{cell.minid, cell.maxid}));
            }
            return listings.toArray(new Pair[listings.size()]);
        }

        private double calcDist(Point3i cellIx, Plane3d plane) {
            AABox bounds = this.getBounds(cellIx);
            Point3d center = bounds.getCenter();
            double isect = Inter3D.linePlaneIntersectionT(center, this.d_dir, plane, 1.0E-6);
            return Double.isNaN(isect) ? 0.0 : isect;
        }

        public AABox getBounds(Point3i cellIx) {
            double x1 = Raster3D_V2.this.d_xDiv[cellIx.x];
            double y1 = Raster3D_V2.this.d_yDiv[cellIx.y];
            double z1 = Raster3D_V2.this.d_zDiv[cellIx.z];
            double x2 = Raster3D_V2.this.d_xDiv[cellIx.x + this.d_adds[0]];
            double y2 = Raster3D_V2.this.d_yDiv[cellIx.y + this.d_adds[1]];
            double z2 = Raster3D_V2.this.d_zDiv[cellIx.z + this.d_adds[2]];
            return new AABox(x1, y1, z1, x2, y2, z2);
        }

        public void getAdjacentCells(Point3i cellIx, Consumer<Point3i> result) {
            if (cellIx.x < Raster3D_V2.this.d_xDiv.length && cellIx.y < Raster3D_V2.this.d_yDiv.length && cellIx.z < Raster3D_V2.this.d_zDiv.length) {
                result.accept(cellIx);
            }
            int belowx = cellIx.x - (int)this.d_dir.x;
            int belowy = cellIx.y - (int)this.d_dir.y;
            int belowz = cellIx.z - (int)this.d_dir.z;
            if (belowx >= 0 && belowy >= 0 && belowz >= 0) {
                result.accept(new Point3i(belowx, belowy, belowz));
            }
        }

        public void addCell(int count, Point3i cellIx, int group, Plane3d plane) {
            double dist = this.calcDist(cellIx, plane);
            Cell cell = this.d_cells.get(cellIx);
            if (cell == null) {
                cell = new Cell(count, group, dist);
                this.d_cells.put(new Point3i(cellIx), cell);
            } else {
                cell.add(count, group, dist);
            }
        }

        public void addPhantom(Point3i cellIx, IntSupplier group) {
            Cell cell = this.d_cells.get(cellIx);
            if (cell == null) {
                cell = new Cell(1, group.getAsInt(), 0.0);
                this.d_cells.put(new Point3i(cellIx), cell);
            } else {
                cell.addPhantom();
            }
        }

        public void getBounds(int[] bounds) {
            for (Point3i cellix : this.d_cells.keySet()) {
                if (cellix.x < bounds[0]) {
                    bounds[0] = cellix.x;
                }
                if (cellix.x > bounds[1]) {
                    bounds[1] = cellix.x;
                }
                if (cellix.y < bounds[2]) {
                    bounds[2] = cellix.y;
                }
                if (cellix.y > bounds[3]) {
                    bounds[3] = cellix.y;
                }
                if (cellix.z < bounds[4]) {
                    bounds[4] = cellix.z;
                }
                if (cellix.z <= bounds[5]) continue;
                bounds[5] = cellix.z;
            }
        }

        public void merge(CellList list) {
            for (Map.Entry<Point3i, Cell> entry : list.d_cells.entrySet()) {
                Point3i loc = entry.getKey();
                Cell cell = entry.getValue();
                Cell existing = this.d_cells.get(loc);
                if (existing == null) {
                    this.d_cells.put(loc, cell);
                    continue;
                }
                existing.merge(cell);
            }
        }
    }

    private static class ConvexVolume {
        public final ConvexPolygon[] d_polys;

        public ConvexVolume(ConvexPolygon[] polys) {
            this.d_polys = polys;
        }
    }

    private static class Thickener {
        private final boolean thicken;
        private final boolean uniformGroups;
        private final Map<Edgei, List<Integer>> collapsedEdges = new HashMap<Edgei, List<Integer>>();
        private final Function<Edgei, List<Integer>> newList = e -> new ArrayList(2);
        private final Point3d[][] polyPoints;
        private final int[] faceGroups;
        private final int fillGroup;

        public Thickener(boolean thickenEnabled, int fillGroup, int[] faceGroups, Point3d[][] polyPoints) {
            this.thicken = thickenEnabled;
            this.uniformGroups = theUtil.isUniform(faceGroups);
            this.polyPoints = polyPoints;
            this.faceGroups = faceGroups;
            this.fillGroup = fillGroup;
        }

        public void addCollapsedEdges(int faceIx, Collection<Edgei> pCollapsedEdges) {
            if (!this.uniformGroups && this.thicken) {
                for (Edgei e : pCollapsedEdges) {
                    this.collapsedEdges.computeIfAbsent(e, this.newList).add(faceIx);
                }
            }
        }

        public void finish(Raster3D_V2 raster) {
            if (this.thicken) {
                GetThickenId getThickenId;
                int[] ambiguousThicken = new int[]{0};
                if (this.uniformGroups) {
                    getThickenId = (e, normal, id) -> id;
                } else {
                    Point3d[][] fpoints = this.polyPoints;
                    HashMap faceNormals = new HashMap();
                    Function<Integer, Vector3d> computeFaceNormal = i -> {
                        Point3d[] face = fpoints[i];
                        return Util3D.simplePolygonNormal(Arrays.asList(face), true);
                    };
                    int[] fgroups = this.faceGroups;
                    getThickenId = (e, enormal, backupId) -> {
                        List collapsedFaces = this.collapsedEdges.getOrDefault(e, Collections.emptyList());
                        if (collapsedFaces.isEmpty()) {
                            nArray[0] = ambiguousThicken[0] + 1;
                            return backupId;
                        }
                        int faceIx = (Integer)collapsedFaces.get(0);
                        if (collapsedFaces.size() > 1) {
                            double maxdot = Double.NEGATIVE_INFINITY;
                            for (Integer fix : collapsedFaces) {
                                double dot;
                                Vector3d fnormal = (Vector3d)faceNormals.computeIfAbsent(fix, computeFaceNormal);
                                if (fnormal == null || !((dot = Math.abs(fnormal.dot(enormal))) > maxdot)) continue;
                                maxdot = dot;
                                faceIx = fix;
                            }
                        }
                        return fgroups[faceIx];
                    };
                }
                raster.thicken(this.fillGroup, getThickenId);
            }
        }
    }

    private class FillRange {
        public int localx;
        public int localy;
        public int localZBegin;
        public int localZEnd;

        public FillRange(int x, int y, int zBegin, int zEnd) {
            this.localx = x;
            this.localy = y;
            this.localZBegin = zBegin;
            this.localZEnd = zEnd;
        }
    }

    private static interface QuadFunction<T1, T2, T3, T4, R> {
        public R apply(T1 var1, T2 var2, T3 var3, T4 var4);
    }

    private static interface GetThickenId {
        public int get(Edgei var1, Vector3d var2, int var3);
    }

    private static class Matrix3i {
        private int m00;
        private int m01;
        private int m02;
        private int m10;
        private int m11;
        private int m12;
        private int m20;
        private int m21;
        private int m22;

        public Matrix3i(int m00, int m01, int m02, int m10, int m11, int m12, int m20, int m21, int m22) {
            this.m00 = m00;
            this.m01 = m01;
            this.m02 = m02;
            this.m10 = m10;
            this.m11 = m11;
            this.m12 = m12;
            this.m20 = m20;
            this.m21 = m21;
            this.m22 = m22;
        }

        public <T extends Tuple3i> T transform(T t) {
            int x = this.m00 * t.x + this.m01 * t.y + this.m02 * t.z;
            int y = this.m10 * t.x + this.m11 * t.y + this.m12 * t.z;
            int z = this.m20 * t.x + this.m21 * t.y + this.m22 * t.z;
            t.set(x, y, z);
            return t;
        }
    }

    private class ScanLineBoundsAdder {
        private final Plane3d d_plane;
        private final int d_planeAlign;
        private final Point3i d_min;
        private final Point3i d_max;
        private final List<int[]>[] xScanBounds;
        private final List<int[]>[] yScanBounds;
        private final Map<Edgei, Integer> d_edgeCounts;
        private final BiFunction<Integer, Integer, Integer> s_isum = Integer::sum;
        private final Comparator<int[]> d_comp = new Comparator<int[]>(){

            @Override
            public int compare(int[] o1, int[] o2) {
                return o1[0] - o2[0];
            }
        };

        public ScanLineBoundsAdder(Plane3d plane, Point3i min, Point3i max) {
            int align;
            this.d_plane = plane;
            this.d_min = min;
            this.d_max = max;
            int dx = max.x - min.x;
            int dy = max.y - min.y;
            int dz = max.z - min.z;
            if (dz <= dx && dz <= dy) {
                align = 0;
                this.xScanBounds = new ArrayList[dx];
                this.yScanBounds = new ArrayList[dy];
            } else if (dy <= dx && dy <= dz) {
                align = 1;
                this.xScanBounds = new ArrayList[dx];
                this.yScanBounds = new ArrayList[dz];
            } else {
                align = 2;
                this.xScanBounds = new ArrayList[dy];
                this.yScanBounds = new ArrayList[dz];
            }
            this.d_planeAlign = align;
            this.d_edgeCounts = new HashMap<Edgei, Integer>();
        }

        public Collection<Edgei> getCollapsedEdges() {
            return this.d_edgeCounts.entrySet().stream().filter(e -> (Integer)e.getValue() % 2 == 0).map(e -> (Edgei)e.getKey()).collect(Collectors.toList());
        }

        public void add(Point3i p1, Point3i p2) {
            int lmy;
            int lmx;
            int ly2;
            int lx2;
            int lz1;
            int ly1;
            int lx1;
            switch (this.d_planeAlign) {
                case 0: {
                    lx1 = p1.x;
                    ly1 = p1.y;
                    lz1 = p1.z;
                    lx2 = p2.x;
                    ly2 = p2.y;
                    lmx = this.d_min.x;
                    lmy = this.d_min.y;
                    break;
                }
                case 1: {
                    lx1 = p1.x;
                    ly1 = p1.z;
                    lz1 = p1.y;
                    lx2 = p2.x;
                    ly2 = p2.z;
                    lmx = this.d_min.x;
                    lmy = this.d_min.z;
                    break;
                }
                default: {
                    lx1 = p1.y;
                    ly1 = p1.z;
                    lz1 = p1.x;
                    lx2 = p2.y;
                    ly2 = p2.z;
                    lmx = this.d_min.y;
                    lmy = this.d_min.z;
                }
            }
            if (ly1 != ly2) {
                int div = Math.min(ly1, ly2) - lmy;
                List<int[]> bounds = this.yScanBounds[div];
                if (bounds == null) {
                    this.yScanBounds[div] = bounds = new ArrayList<int[]>(2);
                }
                bounds.add(new int[]{lx1, lz1});
            } else if (lx1 != lx2) {
                int div = Math.min(lx1, lx2) - lmx;
                List<int[]> bounds = this.xScanBounds[div];
                if (bounds == null) {
                    this.xScanBounds[div] = bounds = new ArrayList<int[]>(2);
                }
                bounds.add(new int[]{ly1, lz1});
            }
            this.d_edgeCounts.merge(new Edgei(new Point3i(p1), new Point3i(p2)), 1, this.s_isum);
        }

        public void sortScans() {
            this.sortScans(this.xScanBounds);
            this.sortScans(this.yScanBounds);
        }

        private void sortScans(List<int[]>[] scanBounds) {
            for (int m = 0; m < scanBounds.length; ++m) {
                List<int[]> scan = scanBounds[m];
                if (scan == null) continue;
                int[][] vals = (int[][])scan.toArray((T[])new int[scan.size()][]);
                Arrays.sort(vals, this.d_comp);
                ArrayList<int[]> newList = new ArrayList<int[]>(vals.length);
                for (int n = 0; n < vals.length; ++n) {
                    newList.add(vals[n]);
                }
                scanBounds[m] = newList;
            }
        }
    }

    private static class Edgei {
        public final Point3i e1;
        public final Point3i e2;

        public Edgei(Point3i e1, Point3i e2) {
            this.e1 = e1;
            this.e2 = e2;
        }

        public void set(Point3i e1, Point3i e2) {
            this.e1.set(e1);
            this.e2.set(e2);
        }

        public int hashCode() {
            return 0xFA83F ^ this.e1.hashCode() + this.e2.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Edgei)) {
                return false;
            }
            Edgei e = (Edgei)obj;
            return this.e1.equals(e.e1) && this.e2.equals(e.e2) || this.e1.equals(e.e2) && this.e2.equals(e.e1);
        }

        public String toString() {
            return String.format("(%d,%d,%d)->(%d,%d,%d)", this.e1.x, this.e1.y, this.e1.z, this.e2.x, this.e2.y, this.e2.z);
        }
    }

    private static enum Dir {
        X,
        Y,
        Z;

    }
}

