/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.zones;

import java.awt.Color;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.NamedPyroObject;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.BlockGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.UnitAABox;

public class Zone
extends NamedPyroObject
implements IPyroGeomSrc {
    static final long serialVersionUID = 1L;
    public static final Color DEF_COLOR = new Color(0.8f, 0.1f, 0.1f, 0.4f);
    private UnitAABox d_box;
    private boolean d_visible;
    private Color d_color;

    public Zone(String name, UnitAABox bounds) {
        super(name);
        this.d_box = bounds;
        this.d_visible = true;
        this.d_color = DEF_COLOR;
    }

    public boolean isOuter() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Zone)) {
            return false;
        }
        Zone zone = (Zone)obj;
        return this.getName().equals(zone.getName()) && this.d_box.equals(zone.d_box) && this.d_color.equals(zone.d_color) && this.isOuter() == zone.isOuter();
    }

    @Override
    public Object clone() {
        Zone clone = (Zone)super.clone();
        return clone;
    }

    public void getBounds(AABox bounds) {
        bounds.add(this.d_box.getValue(Geometry.LU));
    }

    public UnitAABox getBox() {
        return this.d_box;
    }

    public void setBox(UnitAABox box) {
        if (!this.d_box.equals(box)) {
            this.d_box = box;
            this.changedEvt(new Object[0]);
        }
    }

    public Color getColor() {
        return this.d_color;
    }

    public void setColor(Color color) {
        if (!this.d_color.equals(color)) {
            this.d_color = color;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getZoneGeom());
    }

    public IGeom getZoneGeom() {
        return new BlockGeom(this.d_box.getMin(Geometry.LU), this.d_box.getMax(Geometry.LU), 0);
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof AABoxGeom) {
            AABoxGeom bg = (AABoxGeom)geom;
            this.d_box = new UnitAABox(bg.min, bg.max, Geometry.LU);
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        return new DisplayGeom(this.getGeom(), (IPrimProps)new IPrimProps.Face(this.d_color, null, 2));
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible != visible) {
            this.d_visible = visible;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public String toString() {
        return String.format("Zone[name=\"%s\",bounds(min)=%s,bounds(max)=%s]", this.getName(), this.d_box.getMin().toString(), this.d_box.getMax().toString());
    }
}

