/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.view;

import java.awt.Color;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.domain.view.AViewGeomProp;
import pyrosim.domain.view.ViewMode;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;

public class CameraState
extends AViewGeomProp<CameraRecord> {
    static final long serialVersionUID = 1L;

    public CameraState(CameraRecord record) {
        super(record);
    }

    @Override
    public CameraState clone() {
        return (CameraState)super.clone();
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof CameraGeom) {
            this.set(((CameraGeom)geom).record);
        } else if (geom instanceof Point) {
            Point p = (Point)geom;
            Vector3d moveDir = Util3D.vector(((CameraRecord)this.get()).loc, p.loc);
            ITransform xform = TransformUtil.translate(moveDir.x, moveDir.y, moveDir.z);
            CameraGeom newGeom = this.getCameraGeom().transform(xform.getInfo(), 1);
            this.setGeom(newGeom);
        }
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getCameraGeom());
    }

    private CameraGeom getCameraGeom() {
        return new CameraGeom((CameraRecord)this.get());
    }

    public CameraRecord getCameraRecord() {
        return this.getCameraGeom().record;
    }

    public ViewMode getViewMode() {
        return ((CameraRecord)this.get()).frustum instanceof OrthoCamera.FrustumRecord ? ViewMode.MV_2D : ViewMode.MV_3D;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return new DisplayGeom(this.getGeom(), (IPrimProps)new IPrimProps.Vertex(Color.GREEN, 10.0));
    }

    @Override
    public boolean isEquiv(Object obj) {
        return this == obj;
    }

    private static class CameraGeom
    extends Point {
        private static final long serialVersionUID = -2076150722662797833L;
        public final CameraRecord record;

        public CameraGeom(CameraRecord record) {
            super(record.loc);
            this.record = record;
        }

        @Override
        public CameraGeom optimize(IPointOptimizer pool) {
            Point3d loc = pool.getExisting(this.record.loc);
            Point3d ref = pool.getExisting(this.record.ref);
            if (loc == this.record.loc && ref == this.record.ref) {
                return this;
            }
            CameraRecord rec = new CameraRecord(loc, ref, this.record.up, this.record.zoom, this.record.zoomLoc, this.record.near, this.record.far, this.record.frustum);
            return new CameraGeom(rec);
        }

        @Override
        public CameraGeom transform(TransformInfo ti, int options) {
            if (ti.isIdentity()) {
                return this;
            }
            Matrix4d xform = ti.getMatrix();
            Point3d loc = Util3D.xform(xform, this.record.loc);
            Point3d ref = Util3D.xform(xform, this.record.ref);
            Vector3d up = Util3D.xform(xform, this.record.up);
            Vector3d view = Util3D.vector(loc, ref);
            Vector3d right = Util3D.cross(view, up);
            up.cross(right, view);
            double upLen = Util3D.safeNormalize(up, 1.0E-6);
            if (upLen == 0.0) {
                return this;
            }
            return new CameraGeom(new CameraRecord(loc, ref, up, this.record.zoom, this.record.zoomLoc, this.record.near, this.record.far, this.record.frustum));
        }
    }
}

