/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.DeletePreserveTask;
import pyrosim.domain.tasks.DeleteTask;
import pyrosim.domain.tasks.ReplacePreserveTask;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class Tasks {
    public static Task replace(List<? extends IPyroObject> objects, List<? extends IPyroObject> replacements, boolean preserveIndexes) {
        if (objects.isEmpty()) {
            return EmptyTask.INSTANCE;
        }
        assert (objects.size() == replacements.size());
        if (!preserveIndexes) {
            CompositeTask task = new CompositeTask(objects.get(0).getDomain());
            task.addTask(Tasks.delete(objects));
            for (int m = 0; m < objects.size(); ++m) {
                IPyroObject parent = objects.get(m).getParent();
                task.addTask(new AddTask(parent, new IPyroObject[]{replacements.get(m)}));
            }
            return task;
        }
        return new ReplacePreserveTask(objects, replacements);
    }

    public static Task replace(IPyroObject object, IPyroObject replacement, boolean preserveIndex) {
        return Tasks.replace(Arrays.asList(object), Arrays.asList(replacement), preserveIndex);
    }

    public static Task delete(IPyroObject ... objs) {
        return Tasks.delete(Arrays.asList(objs));
    }

    public static Task delete(Collection<? extends IPyroObject> objs) {
        boolean noPreserve;
        assert (!objs.contains(null)) : "Attempting to delete null object. See case 28897.";
        objs = theUtil.filter(objs, obj -> obj != null);
        IFilteredCollection<? extends IPyroObject> preserveObjs = theUtil.filter(objs, new PreserveIxFilter(true));
        IFilteredCollection<? extends IPyroObject> noPreserveObjs = theUtil.filter(objs, new PreserveIxFilter(false));
        boolean preserve = !preserveObjs.isEmpty();
        boolean bl = noPreserve = !noPreserveObjs.isEmpty();
        if (preserve && noPreserve) {
            CompositeTask task = new CompositeTask(objs.iterator().next().getDomain());
            task.addTask(new DeletePreserveTask(preserveObjs));
            task.addTask(new DeleteTask(noPreserveObjs));
            return task;
        }
        if (preserve) {
            return new DeletePreserveTask(objs);
        }
        if (noPreserve) {
            return new DeleteTask(objs);
        }
        return EmptyTask.INSTANCE;
    }

    private static class PreserveIxFilter<T extends IPyroObject>
    implements Predicate<T> {
        private final boolean d_preserve;

        public PreserveIxFilter(boolean preserve) {
            this.d_preserve = preserve;
        }

        @Override
        public boolean test(T o) {
            IPyroObject parent = o.getParent();
            assert (parent != null);
            return this.d_preserve == TVEntryPoints.ep(parent).preserveIndexOnDelete((PyroMod)o.getDomain(), parent, o);
        }
    }
}

