/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.tasks.AddTask;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.CompositeTask;

public class FillGridsWithPartsTask
extends CompositeTask<PyroMod> {
    private final ModelComposite d_root;
    private final String d_baseID;
    private final Collection<? extends Grid> d_grids;
    private final Particle d_particle;
    private final PartCloud.IDropletCount d_initDropCount;
    private final PartCloud.IInsertion d_insertion;
    private List<IPyroObject> d_addedObjects;
    private final boolean d_distributeQuantities;

    public FillGridsWithPartsTask(PyroMod mediator, ModelComposite rootComp, String baseID, Collection<? extends Grid> grids, Particle particle, PartCloud.IDropletCount initDropCount, PartCloud.IInsertion insertion, boolean distributeQuantities) {
        super(mediator);
        this.d_root = rootComp;
        this.d_baseID = baseID;
        this.d_grids = grids;
        this.d_particle = particle;
        this.d_initDropCount = initDropCount;
        this.d_insertion = insertion;
        this.d_addedObjects = new ArrayList<IPyroObject>();
        this.d_distributeQuantities = distributeQuantities;
    }

    public FillGridsWithPartsTask(PyroMod mediator, String baseID, Collection<? extends Grid> grids, Particle particle, PartCloud.IDropletCount initDropCount, PartCloud.IInsertion insertion, boolean distributeQuantities) {
        this(mediator, mediator.getObstructions(), baseID, grids, particle, initDropCount, insertion, distributeQuantities);
    }

    @Override
    protected void queueBeginRuntimeTasks() {
        if (this.d_grids.isEmpty()) {
            return;
        }
        List<PartCloud> clouds = this.createGridClouds(this.d_grids, this.d_particle, this.d_initDropCount, this.d_insertion, this.d_distributeQuantities);
        if (clouds.isEmpty()) {
            return;
        }
        this.d_addedObjects.addAll(clouds);
        String groupName = Intl.intl("Particle Clouds");
        ModelComposite cloudGroup = this.d_root.find(groupName, ModelComposite.class, false);
        if (cloudGroup == null) {
            cloudGroup = new ModelComposite(groupName);
            this.addTask(new AddTask((IPyroObject)this.d_root, new IPyroObject[]{cloudGroup}));
            this.d_addedObjects.add(cloudGroup);
        }
        this.addTask(new AddTask<PartCloud>((IPyroObject)cloudGroup, (Collection<PartCloud>)clouds));
    }

    public List<IPyroObject> getAddedObjects() {
        return this.d_addedObjects;
    }

    /*
     * WARNING - void declaration
     */
    private List<PartCloud> createGridClouds(Collection<? extends Grid> grids, Particle particle, PartCloud.IDropletCount initDropCount, PartCloud.IInsertion totInsertion, boolean distribute) {
        Unit volUnit = SIUS.unit(56);
        UnitDouble totVolume = new UnitDouble(0.0, volUnit);
        ArrayList<UnitDouble> volumes = new ArrayList<UnitDouble>(grids.size());
        for (Grid grid : grids) {
            UnitDouble volume = grid.getVolume();
            totVolume = totVolume.add(volume);
            volumes.add(volume);
        }
        ArrayList<PartCloud> clouds = new ArrayList<PartCloud>();
        boolean bl = false;
        for (Grid grid : grids) {
            void var10_12;
            UnitDouble volume = (UnitDouble)volumes.get((int)(++var10_12));
            double volFrac = volume.getValue(volUnit) / totVolume.getValue(volUnit);
            PartCloud.IDropletCount count = initDropCount;
            if (distribute && initDropCount instanceof PartCloud.ConstDropletCount) {
                int totNumDrops = initDropCount.getNumDrops(null);
                int numDrops = (int)Math.round((double)totNumDrops * volFrac);
                if (numDrops == 0) continue;
                count = new PartCloud.ConstDropletCount(numDrops);
            }
            PartCloud.IInsertion insertion = totInsertion;
            if (distribute && totInsertion instanceof PartCloud.InsertPeriodically) {
                PartCloud.InsertPeriodically perInsert = (PartCloud.InsertPeriodically)totInsertion;
                UnitDouble totMass = perInsert.massPerTime;
                UnitDouble mass = totMass.scale(volFrac);
                if (mass.getValueNoUnit() == 0.0) continue;
                insertion = new PartCloud.InsertPeriodically(perInsert.dt, mass);
            }
            AABox gridBounds = new AABox();
            grid.getGeom().getBoundingBox(gridBounds);
            String name = this.getCloudName(grid, particle);
            PartCloud cloud = new PartCloud(name, particle, new AABoxGeom(gridBounds));
            cloud.setInsertion(insertion);
            cloud.setInitDrops(count);
            cloud.setVisible(false);
            clouds.add(cloud);
        }
        return clouds;
    }

    private String getCloudName(Grid g, Particle p) {
        if (this.d_baseID != null) {
            return g.getName() + " " + this.d_baseID;
        }
        return String.format(Intl.intl("%1$s %2$s cloud"), g.getName(), p.getName());
    }
}

