/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.util.AUndoableTask;

public class ChangeOrderTask
extends AUndoableTask {
    private final IPyroObject d_target;
    private List<IPyroObject> d_originalOrder;
    private final UnaryOperator<Collection<? extends IPyroObject>> d_reorder;

    public ChangeOrderTask(IPyroObject target, UnaryOperator<Collection<? extends IPyroObject>> reorder) {
        this.d_target = target;
        this.d_originalOrder = null;
        this.d_reorder = reorder;
    }

    private void changeUpdates(boolean pause) {
        PyroMod domain = (PyroMod)this.d_target.getDomain();
        if (domain != null) {
            if (pause) {
                domain.pauseUpdates();
            } else {
                domain.resumeUpdates();
            }
        }
    }

    @Override
    public void undo() {
        this.changeUpdates(true);
        TVEntryPoints.ep(this.d_target).reorder(this.d_target, this.d_originalOrder);
        this.d_originalOrder = null;
        this.changeUpdates(false);
    }

    @Override
    public void run() {
        this.changeUpdates(true);
        this.d_originalOrder = new ArrayList<IPyroObject>(this.d_target.getMembers());
        Collection newOrder = (Collection)this.d_reorder.apply(this.d_target.getMembers());
        TVEntryPoints.ep(this.d_target).reorder(this.d_target, newOrder);
        this.changeUpdates(false);
    }
}

