/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.signals;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.jscience.physics.units.Unit;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;

public class Util {
    public static IOutPin getPin(ISignalSource src, String pinName) {
        for (IOutPin iOutPin : src.getOutputPins()) {
            if (!iOutPin.getName().equals(pinName)) continue;
            return iOutPin;
        }
        return null;
    }

    public static boolean areCompatible(Unit u1, Unit u2) {
        if (!u1.isCompatible(u2)) {
            return false;
        }
        try {
            return u1.getConverterTo(u2) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Collection<IInPin> getInputPins(Iterator<? extends ISignalSink> objs) {
        ArrayList<IInPin> pins = new ArrayList<IInPin>();
        while (objs.hasNext()) {
            pins.add(objs.next().getInputPin());
        }
        return pins;
    }

    public static boolean isCycle(ISignalSink initialNode) {
        return Util.containsCycleImpl(initialNode, new ISignalSink[0]);
    }

    public static boolean containsCycle(ISignalSink target, ISignalSink ctrl) {
        return Util.containsCycleImpl(ctrl, target);
    }

    private static boolean containsCycleImpl(ISignalSink start, ISignalSink ... extraStops) {
        ArrayDeque<ISignalSink> open = new ArrayDeque<ISignalSink>();
        HashSet<ISignalSink> visited = new HashSet<ISignalSink>(Arrays.asList(extraStops));
        open.push(start);
        while (!open.isEmpty()) {
            ISignalSink current = (ISignalSink)open.pop();
            if (!visited.add(current)) {
                return true;
            }
            IInPin inPin = current.getInputPin();
            for (ISignalSource connSrc : inPin.getConnectedSources()) {
                if (!(connSrc instanceof ISignalSink)) continue;
                open.push((ISignalSink)((Object)connSrc));
            }
        }
        return false;
    }
}

