/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.scenario;

import java.util.Collection;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.scenario.Scenario;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public class ScenarioList
extends Composite<Scenario>
implements IDirectDependent {
    private static final long serialVersionUID = 1L;
    private Scenario d_activeScenario;

    public ScenarioList() {
        super(Intl.intl("Scenarios"), Scenario.class);
    }

    public void addDefaults() {
        this.pauseUpdates();
        Scenario defaultScenario = new Scenario(Intl.intl("Default"));
        this.add(defaultScenario);
        this.setActive(defaultScenario);
        this.resumeUpdates();
    }

    public void setActive(Scenario obj) {
        this.pauseUpdates();
        this.d_activeScenario = Scenario.activate(this.d_activeScenario, obj);
        this.resumeUpdates();
        this.changedEvt(PyroMod.EVT_SCENARIO_CHANGED);
    }

    public Scenario getActive() {
        return this.d_activeScenario;
    }

    public void removeDeletedObjs(Collection<IPyroObject> deletedObjs) {
        this.flatten().forEach(scenario -> scenario.removeDeletedObjs(deletedObjs));
    }

    public Task taskSetActive(Scenario obj) {
        final Scenario oldObj = this.getActive();
        final Scenario newObj = obj;
        return new AUndoableTask(){

            @Override
            public void run() {
                ScenarioList.this.pauseUpdates();
                ScenarioList.this.setActive(newObj);
                ScenarioList.this.resumeUpdates();
            }

            @Override
            public void undo() {
                ScenarioList.this.pauseUpdates();
                ScenarioList.this.setActive(oldObj);
                ScenarioList.this.resumeUpdates();
            }
        };
    }

    @Override
    public String toString() {
        return String.format("%s@%s [getActive()=%s]", this.getClass().getName(), Integer.toHexString(this.hashCode()), this.getActive());
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.REQUIRED, (IPyroObject)this.d_activeScenario);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        objs.retainAll(this.flatten());
    }

    @Override
    public Task taskReplaceDep(final IPyroObject old, final IPyroObject replacement) {
        if (this.d_activeScenario != old) {
            return null;
        }
        return new AUndoableTask(){

            @Override
            public void undo() {
                ScenarioList.this.setActive((Scenario)old);
            }

            @Override
            public void run() {
                ScenarioList.this.setActive((Scenario)replacement);
            }
        };
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }
}

