/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.output;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import pyrosim.PyroMod;
import pyrosim.domain.INamed;
import pyrosim.domain.output.Slice;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.BlockGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.UnitDouble;

public class VolumeSlice
extends Slice
implements INamed {
    private static final long serialVersionUID = 1L;
    private IGeom d_geom;
    private String d_name;
    private static final Color s_color = new Color(Color.PINK.getRed(), Color.PINK.getGreen(), Color.pink.getBlue(), 150);

    public VolumeSlice(String name, IGeom geom, IQuantity measurement, boolean includeFlowVector, boolean cellCentered) {
        super(measurement, includeFlowVector, cellCentered);
        assert (geom instanceof AABoxGeom);
        this.d_geom = geom;
        this.d_name = name;
    }

    public VolumeSlice(String name, UnitDouble minx, UnitDouble maxx, UnitDouble miny, UnitDouble maxy, UnitDouble minz, UnitDouble maxz, IQuantity measurement, boolean includeFlowVector, boolean cellCentered) {
        super(measurement, includeFlowVector, cellCentered);
        AABox box = new AABox(minx.getValue(Geometry.LU), miny.getValue(Geometry.LU), minz.getValue(Geometry.LU), maxx.getValue(Geometry.LU), maxy.getValue(Geometry.LU), maxz.getValue(Geometry.LU));
        this.d_geom = new AABoxGeom(box);
        this.d_name = name;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        IGeom geom = this.getSliceGeom();
        IPrimProps.Face sprops = new IPrimProps.Face(s_color, null, 2);
        return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(geom), (IPrimProps)sprops);
    }

    @Override
    public IGeom getSliceGeom() {
        if (this.d_geom instanceof AABoxGeom && !(this.d_geom instanceof BlockGeom)) {
            AABoxGeom aabox = (AABoxGeom)this.d_geom;
            return new BlockGeom(aabox.min, aabox.max, 0);
        }
        return this.d_geom;
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    @Override
    public void setGeom(IGeom geom) {
        if (AABoxGeom.class.isAssignableFrom(geom.getClass())) {
            this.d_geom = geom;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public int hashCode() {
        int hashCode = 7;
        hashCode += 31 * hashCode + this.getQuantity().hashCode();
        hashCode += 31 * hashCode + this.d_geom.hashCode();
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        VolumeSlice s = (VolumeSlice)obj;
        return this.getQuantity().equals(s.getQuantity()) && this.getGeom().equals(s.getGeom());
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.d_name;
    }

    @Override
    public void setName(String name) {
        if (!name.equals(this.d_name) && this.getDomain() != null) {
            ((PyroMod)this.getDomain()).getNames(this).updateRegisteredName(this.d_name, name);
            this.d_name = name;
            this.changedEvt(new Object[0]);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.d_name == null) {
            this.setName(this.getQuantity().getDescription());
        }
    }
}

