/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.hvac;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.IImplicitGeomSrc;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.AHvacGeomComponent;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacFilter;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.geom.Geometry;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.util.Util;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Task;

public class HvacNode
extends AHvacGeomComponent
implements IImplicitGeomSrc {
    private static final long serialVersionUID = 1414663300556603303L;
    public static final String OPT_NODETYPE = "OPT_NODETYPE";
    private static final IPrimProps s_primProps;

    public HvacNode(String id) {
        super(id);
        HvacNode.setDefaults(this);
    }

    @Override
    public HvacNode clone() {
        return (HvacNode)super.clone();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.getProp("XYZ") == null) {
            this.setProp("XYZ", new UnitPoint3D(0.0, 0.0, 0.0, SI.METER));
        }
    }

    public static void setDefaults(HvacNode obj) {
        obj.setProp("TYPE_ID", "NODE");
        obj.setProp(OPT_NODETYPE, (Object)NodeType.AUTO);
        obj.setProp("FILTER_ID", null);
        obj.setProp("LOSS", Arrays.asList(new UnitDouble(0.0, Unit.ONE), new UnitDouble(0.0, Unit.ONE)));
        obj.setProp("VENT_ID", null);
        obj.setProp("XYZ", new UnitPoint3D(0.0, 0.0, 0.0, SI.METER));
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        this.addDep(deps, "VENT_ID");
        this.addDep(deps, "FILTER_ID");
    }

    @Override
    public Object getProp(String key) {
        assert (!key.equals("DUCT_ID"));
        return super.getProp(key);
    }

    @Override
    public void setProp(String key, Object value) {
        assert (!key.equals("DUCT_ID"));
        super.setProp(key, value);
    }

    public void setVent(Vent obj) {
        assert (obj != null);
        this.pauseUpdates();
        this.setProp("VENT_ID", obj);
        this.setProp(OPT_NODETYPE, (Object)NodeType.VENT);
        this.resumeUpdates();
    }

    public Vent getVent() {
        return (Vent)this.getProp("VENT_ID");
    }

    @Override
    public Collection<IPyroGeomSrc> getDefiningObjs(Collection<IPyroGeomSrc> objs) {
        if (this.getNodeType() == NodeType.VENT && this.getVent() != null) {
            objs.add(this.getVent());
        }
        return objs;
    }

    public List<UnitDouble> getTerminalLoss() {
        return (List)this.getProp("LOSS");
    }

    public void setTerminalLoss(UnitDouble inLoss, UnitDouble outLoss) {
        List<UnitDouble> loss = Arrays.asList(inLoss, outLoss);
        this.setProp("LOSS", loss);
    }

    public void setNodeType(NodeType type) {
        assert (type != NodeType.VENT);
        this.pauseUpdates();
        this.setProp(OPT_NODETYPE, (Object)type);
        this.setProp("VENT_ID", null);
        this.resumeUpdates();
    }

    public NodeType getNodeType() {
        return (NodeType)((Object)this.getProp(OPT_NODETYPE));
    }

    public NodeType getFinalNodeType(int numDucts) {
        NodeType type = this.getNodeType();
        if (type != NodeType.AUTO) {
            return type;
        }
        if (numDucts == 1) {
            return NodeType.AMBIENT;
        }
        return NodeType.INTERNAL;
    }

    public void setFilter(HvacFilter obj) {
        this.setProp("FILTER_ID", obj);
    }

    public HvacFilter getFilter() {
        return (HvacFilter)this.getProp("FILTER_ID");
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (old instanceof Vent) {
            Util.keepIfNullOr(objs, Vent.class);
        } else if (old instanceof HvacFilter) {
            Util.keepIfNullOr(objs, HvacFilter.class);
        } else if (old instanceof HvacDuct) {
            Util.keepIfNullOr(objs, HvacDuct.class);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old instanceof Vent) {
            return new AReplaceRefTask<Vent>((Object)old, (Object)replacement){

                @Override
                protected void set(Vent obj) {
                    if (obj != null) {
                        HvacNode.this.setVent(obj);
                    } else {
                        HvacNode.this.setNodeType(NodeType.AMBIENT);
                    }
                }
            };
        }
        if (old instanceof HvacFilter) {
            return new AReplaceRefTask<HvacFilter>((Object)old, (Object)replacement){

                @Override
                protected void set(HvacFilter obj) {
                    HvacNode.this.setFilter(obj);
                }
            };
        }
        return super.taskReplaceDep(old, replacement);
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        if (!(dep instanceof Vent)) {
            return super.taskUpdateDep(dep, changes);
        }
        return GeomUtil.taskChanged(this);
    }

    public Point3d getLocation() {
        if (this.getNodeType() == NodeType.VENT) {
            Vent v = this.getVent();
            return v.getBounds().getCenter();
        }
        return ((UnitPoint3D)this.getProp("XYZ")).getPoint3dValue(Geometry.LU);
    }

    public void setLocation(Point3d p) {
        this.setLocation(new UnitPoint3D(p, Geometry.LU));
    }

    public void setLocation(UnitPoint3D p) {
        this.setProp("XYZ", p);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        IGeomNode geom = this.getGeom();
        return new DisplayGeom(geom, s_primProps);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getNodeGeom());
    }

    public IGeom getNodeGeom() {
        return new Point(this.getLocation());
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof Point && this.getNodeType() != NodeType.VENT) {
            Point p = (Point)geom;
            this.setLocation(p.loc);
        }
    }

    public int getOpenDuctCount(int numDucts) {
        switch (this.getNodeType()) {
            case AUTO: 
            case INTERNAL: {
                return this.getFilter() == null ? Integer.MAX_VALUE : 2 - numDucts;
            }
            case AMBIENT: 
            case VENT: {
                return 1 - numDucts;
            }
        }
        return 0;
    }

    static {
        TVEntryPoint.registerReferencedUpdateTypes(Vent.class);
        s_primProps = new IPrimProps.Vertex(new Color(0xFF7F00), 15.0);
    }

    private static class DuctLoss {
        public final HvacDuct duct1;
        public final HvacDuct duct2;
        public final UnitDouble loss;

        public DuctLoss(HvacDuct duct1, HvacDuct duct2, UnitDouble loss) {
            this.duct1 = duct1;
            this.duct2 = duct2;
            this.loss = loss;
        }
    }

    public static enum NodeType {
        AUTO(false),
        INTERNAL(false),
        AMBIENT(true),
        VENT(true);

        public final boolean terminal;

        private NodeType(boolean terminal) {
            this.terminal = terminal;
        }
    }
}

