/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.hvac;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacComponent;
import pyrosim.domain.hvac.IHvacObject;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Task;

public class HvacLeak
extends HvacComponent
implements IHvacObject {
    private static final long serialVersionUID = 1L;

    public HvacLeak(String id) {
        super(id);
        HvacLeak.setDefaults(this);
    }

    public static void setDefaults(HvacLeak obj) {
        obj.setProp("TYPE_ID", "LEAK");
        obj.setProp("VENT_ID", null);
        obj.setProp("VENT2_ID", null);
        obj.setProp("AREA", SIUS.newud(0.0, 79));
        obj.setProp("LEAK_ENTHALPY", false);
        obj.setProp("LOSS", Arrays.asList(new UnitDouble(0.0, Unit.ONE)));
    }

    public Vent getVent1() {
        return (Vent)this.getProp("VENT_ID");
    }

    public Vent getVent2() {
        return (Vent)this.getProp("VENT2_ID");
    }

    public UnitDouble getLeakArea() {
        return (UnitDouble)this.getProp("AREA");
    }

    public boolean isEnthalpyCalc() {
        return (Boolean)this.getProp("LEAK_ENTHALPY");
    }

    public UnitDouble getLoss() {
        return (UnitDouble)((List)this.getProp("LOSS")).get(0);
    }

    public void setVent1(Vent v) {
        this.updateProp("VENT_ID", v);
    }

    public void setVent2(Vent v) {
        this.updateProp("VENT2_ID", v);
    }

    public void setLeakArea(UnitDouble area) {
        this.updateProp("AREA", area);
    }

    public void setEnthalpy(boolean isEnthalpy) {
        this.updateProp("LEAK_ENTHALPY", isEnthalpy);
    }

    public void setLoss(UnitDouble loss) {
        this.updateProp("LOSS", Arrays.asList(loss));
    }

    private void updateProp(String key, Object value) {
        this.pauseUpdates();
        this.setProp(key, value);
        this.resumeUpdates();
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        this.addDep(deps, "VENT_ID");
        this.addDep(deps, "VENT2_ID");
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        Util.keepIfNullOr(objs, Vent.class);
    }

    @Override
    public Task taskReplaceDep(final IPyroObject old, IPyroObject replacement) {
        if (old instanceof Vent) {
            return new AReplaceRefTask<Vent>((Object)old, (Object)replacement){

                @Override
                protected void set(Vent obj) {
                    if (old.equals(HvacLeak.this.getVent1())) {
                        HvacLeak.this.setVent1(obj);
                    } else if (old.equals(HvacLeak.this.getVent2())) {
                        HvacLeak.this.setVent2(obj);
                    } else assert (false);
                }
            };
        }
        return super.taskReplaceDep(old, replacement);
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        if (!(dep instanceof Vent)) {
            return super.taskUpdateDep(dep, changes);
        }
        return GeomUtil.taskChanged(this);
    }
}

