/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.sprayers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.devices.IDeviceModel;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.Ramp;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class SprayModel
extends NamedPyroObject
implements IDirectDependent,
IDeviceModel {
    static final long serialVersionUID = 1L;
    private Particle d_particle;
    private String d_fyi;
    private UnitDouble d_sprayOffset;
    private FlowRate d_flowRate;
    private List<Jet> d_jets;
    private int d_dropsPerSecond;
    private CustomFDSProps d_customProps = CustomFDSProps.EMPTY;

    public SprayModel(String name, Particle particle) {
        this(name, particle, new ExplicitFlowRate());
    }

    public SprayModel(String name, Particle particle, FlowRate flowRate) {
        this(name, particle, new UnitDouble(0.05, SI.METER), flowRate, 5000, new Jet());
    }

    public SprayModel(String name, Particle particle, UnitDouble sprayOffset, FlowRate flowRate, int dropsPerSecond, Jet ... jets) {
        this(name, particle, sprayOffset, flowRate, dropsPerSecond, Arrays.asList(jets));
    }

    public SprayModel(String name, Particle particle, UnitDouble sprayOffset, FlowRate flowRate, int dropsPerSecond, List<Jet> jets) {
        super(name);
        this.d_sprayOffset = sprayOffset;
        this.d_particle = particle;
        this.d_flowRate = flowRate;
        this.d_dropsPerSecond = dropsPerSecond;
        assert (!jets.isEmpty());
        this.d_jets = jets;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_customProps == null) {
            this.d_customProps = CustomFDSProps.EMPTY;
        }
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String recType) {
        return this.d_customProps;
    }

    @Override
    public void setCustomFDSProps(String recType, CustomFDSProps props) {
        this.d_customProps = props;
        this.changedEvt(new Object[0]);
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String fyi) {
        this.d_fyi = fyi;
        this.changedEvt(new Object[0]);
    }

    public int getDropsPerSecond() {
        return this.d_dropsPerSecond;
    }

    public void setDropsPerSecond(int dropsPerSecond) {
        this.d_dropsPerSecond = dropsPerSecond;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return super.equals(obj) && this.propEquals(obj);
    }

    public boolean propEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SprayModel)) {
            return false;
        }
        SprayModel desc = (SprayModel)obj;
        return this.d_sprayOffset.equals(desc.d_sprayOffset) && this.d_flowRate.equals(desc.d_flowRate) && this.d_jets.equals(desc.d_jets) && this.d_particle.equals(desc.d_particle) && this.d_customProps.equals(desc.d_customProps);
    }

    public int propHash() {
        return this.d_sprayOffset.hashCode() + this.d_flowRate.hashCode() + this.d_jets.hashCode() + this.d_particle.hashCode() + this.d_customProps.hashCode();
    }

    public static boolean isParticleValid(Particle part) {
        return part != null && !part.isType(Particle.Type.TRACER);
    }

    public static Predicate<Particle> getParticleFilter() {
        return new Predicate<Particle>(){

            @Override
            public boolean test(Particle o) {
                return !o.isType(Particle.Type.TRACER);
            }
        };
    }

    public UnitDouble getSprayOffset() {
        return this.d_sprayOffset;
    }

    public void setSprayOffset(UnitDouble sprayOffset) {
        this.d_sprayOffset = sprayOffset;
        this.changedEvt(new Object[0]);
    }

    public Particle getParticle() {
        return this.d_particle;
    }

    public void setParticle(Particle particle) {
        assert (SprayModel.isParticleValid(particle));
        this.d_particle = particle;
        this.changedEvt(new Object[0]);
    }

    public void setFlowRate(FlowRate rate) {
        this.d_flowRate = rate;
        this.changedEvt(new Object[0]);
    }

    public FlowRate getFlowRate() {
        return this.d_flowRate;
    }

    public List<Jet> getJets() {
        return Collections.unmodifiableList(this.d_jets);
    }

    public void setJets(List<Jet> jets) {
        this.d_jets = jets;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.STRONG, (IPyroObject)this.d_particle);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        Util.keepIfNullOr(objs, Particle.class);
        Iterator<T> objit = objs.iterator();
        while (objit.hasNext()) {
            Particle part = (Particle)objit.next();
            if (part == null || SprayModel.isParticleValid(part)) continue;
            objit.remove();
        }
    }

    @Override
    public Task taskReplaceDep(final IPyroObject old, final IPyroObject replacement) {
        if (old != this.getParticle()) {
            return null;
        }
        assert (replacement != null);
        return new AUndoableTask(){

            @Override
            public void undo() {
                SprayModel.this.setParticle((Particle)old);
            }

            @Override
            public void run() {
                SprayModel.this.setParticle((Particle)replacement);
            }
        };
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }

    public static class Jet
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_velocity;
        public final UnitDouble d_orificeDiam;
        public final double d_flowFrac;
        public final UnitDouble d_long1;
        public final UnitDouble d_long2;
        public final UnitDouble d_lat1;
        public final UnitDouble d_lat2;

        public Jet() {
            this(SIUS.newud(5.0, 8), null, 1.0, new UnitDouble(60.0, NonSI.DEGREE_ANGLE), new UnitDouble(75.0, NonSI.DEGREE_ANGLE));
        }

        public Jet(UnitDouble velocity, UnitDouble orificeDiam, double flowFrac, UnitDouble lat1, UnitDouble lat2) {
            this(velocity, orificeDiam, flowFrac, null, null, lat1, lat2);
        }

        public Jet(UnitDouble velocity, UnitDouble orificeDiam, double flowFrac, UnitDouble long1, UnitDouble long2, UnitDouble lat1, UnitDouble lat2) {
            this.d_velocity = velocity;
            this.d_orificeDiam = orificeDiam;
            this.d_flowFrac = flowFrac;
            this.d_long1 = long1;
            this.d_long2 = long2;
            this.d_lat1 = lat1;
            this.d_lat2 = lat2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Jet)) {
                return false;
            }
            Jet jet = (Jet)obj;
            return this.d_flowFrac == jet.d_flowFrac && theUtil.equal(this.d_velocity, jet.d_velocity) && theUtil.equal(this.d_orificeDiam, jet.d_orificeDiam) && theUtil.equal(this.d_long1, jet.d_long1) && theUtil.equal(this.d_long2, jet.d_long2) && theUtil.equal(this.d_lat1, jet.d_lat1) && theUtil.equal(this.d_lat2, jet.d_lat2);
        }

        public int hashCode() {
            return theUtil.hashCode(this.d_flowFrac) + theUtil.hashCode(this.d_velocity) + theUtil.hashCode(this.d_orificeDiam) + theUtil.hashCode(this.d_long1) + theUtil.hashCode(this.d_long2) + theUtil.hashCode(this.d_lat1) + theUtil.hashCode(this.d_lat2);
        }

        public boolean isConicalSpray() {
            return this.d_long1 == null && this.d_long2 == null;
        }
    }

    public static class VaryingFlowRate
    extends FlowRate {
        static final long serialVersionUID = 1L;
        public static final ActiveSprkRamp DEF_RAMP_INPUT = new ActiveSprkRamp();
        public final Ramp d_pressureRamp;
        public final UnitDouble d_opPressure;
        public final UnitDouble d_kFactor;
        public final UnitDouble d_rate;

        public VaryingFlowRate(Ramp pressureRamp, UnitDouble opPressure, UnitDouble kFactor, UnitDouble rate, TimeFunction ramp) {
            super(ramp);
            this.d_opPressure = opPressure;
            this.d_kFactor = kFactor;
            this.d_rate = rate;
            this.d_pressureRamp = pressureRamp;
            assert (this.isValid());
        }

        public boolean isValid() {
            int numSpec = 0;
            if (this.d_opPressure != null) {
                ++numSpec;
            }
            if (this.d_kFactor != null) {
                ++numSpec;
            }
            if (this.d_rate != null) {
                ++numSpec;
            }
            return numSpec >= 2;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof VaryingFlowRate)) {
                return false;
            }
            VaryingFlowRate rate = (VaryingFlowRate)obj;
            return super.equals(obj) && theUtil.equal(this.d_opPressure, rate.d_opPressure) && theUtil.equal(this.d_kFactor, rate.d_kFactor) && theUtil.equal(this.d_rate, rate.d_rate) && this.d_ramp.equals(rate.d_ramp);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + theUtil.hashCode(this.d_opPressure) + theUtil.hashCode(this.d_kFactor) + theUtil.hashCode(this.d_rate) + this.d_ramp.hashCode();
        }

        private static class ActiveSprkRamp
        implements IRampInput {
            static final long serialVersionUID = 1L;

            private ActiveSprkRamp() {
            }

            @Override
            public String getName() {
                return Intl.intl("Num Active Sprinklers/Nozzles");
            }

            @Override
            public int getUnitType() {
                return 28;
            }

            private Object readResolve() throws ObjectStreamException {
                return DEF_RAMP_INPUT;
            }

            @Override
            public String getTVar() {
                return "T";
            }
        }
    }

    public static class PressurizedFlowRate
    extends FlowRate {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_opPressure;
        public final UnitDouble d_kFactor;

        public PressurizedFlowRate() {
            this(SIUS.newud(0.5, 12), SIUS.newud(85.0, 58), new TimeFunction.TanH(new UnitDouble(0.0, SI.SECOND)));
        }

        public PressurizedFlowRate(UnitDouble opPressure, UnitDouble kFactor, TimeFunction ramp) {
            super(ramp);
            this.d_opPressure = opPressure;
            this.d_kFactor = kFactor;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof PressurizedFlowRate)) {
                return false;
            }
            PressurizedFlowRate rate = (PressurizedFlowRate)obj;
            return super.equals(obj) && this.d_opPressure.equals(rate.d_opPressure) && this.d_kFactor.equals(rate.d_kFactor);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.d_opPressure.hashCode() + this.d_kFactor.hashCode();
        }
    }

    public static class ExplicitFlowRate
    extends FlowRate {
        static final long serialVersionUID = 1L;
        public final UnitDouble d_rate;

        public ExplicitFlowRate() {
            this(new TimeBasedValue<UnitDouble>(SIUS.newud(60.0, 30), new TimeFunction.TanH(new UnitDouble(0.0, SI.SECOND))));
        }

        public ExplicitFlowRate(TimeBasedValue<UnitDouble> rate) {
            this((UnitDouble)rate.val, rate.func);
        }

        public ExplicitFlowRate(UnitDouble rate, TimeFunction func) {
            super(func);
            this.d_rate = rate;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ExplicitFlowRate)) {
                return false;
            }
            ExplicitFlowRate rate = (ExplicitFlowRate)obj;
            return super.equals(obj) && this.d_rate.equals(rate.d_rate);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.d_rate.hashCode();
        }
    }

    public static abstract class FlowRate
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final TimeFunction d_ramp;

        public FlowRate(TimeFunction ramp) {
            this.d_ramp = ramp;
        }

        public boolean equals(Object obj) {
            return obj instanceof FlowRate && this.d_ramp.equals(((FlowRate)obj).d_ramp);
        }

        public int hashCode() {
            return this.d_ramp.hashCode();
        }
    }
}

