/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.controls;

import java.util.ArrayList;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;

public class Util {
    public static boolean deleteWires(IInPin inPin) {
        if (inPin == null) {
            return false;
        }
        boolean modified = false;
        ArrayList<? extends IOutPin> currOutPins = new ArrayList<IOutPin>(inPin.getConnections());
        block0: for (IOutPin iOutPin : currOutPins) {
            IControl ctrl;
            if (iOutPin.getAttachedSource() instanceof ISignalSink) {
                ISignalSink sink = (ISignalSink)((Object)iOutPin.getAttachedSource());
                modified |= Util.deleteWires(sink.getInputPin());
            }
            if (!(iOutPin.getAttachedSource() instanceof IControl) || !(ctrl = (IControl)iOutPin.getAttachedSource()).isWire() || ctrl instanceof ControlBridge) continue;
            modified = true;
            inPin.disconnect(iOutPin);
            for (IOutPin iOutPin2 : ctrl.getInputPin().getConnections()) {
                if (!inPin.isCompatible(iOutPin2)) continue;
                inPin.connect(iOutPin2);
                continue block0;
            }
        }
        return modified;
    }

    public static boolean isComplete(IOutPin pin) {
        ISignalSource src = pin.getAttachedSource();
        return !(src instanceof IControl) || ((IControl)src).isComplete();
    }

    public static boolean isWire(IOutPin pin) {
        ISignalSource src = pin.getAttachedSource();
        return src instanceof IControl && ((IControl)src).isWire();
    }

    public static int countNumCompleteInputs(IInPin inPin) {
        int numValid = 0;
        for (IOutPin iOutPin : inPin.getConnections()) {
            if (!Util.isComplete(iOutPin)) continue;
            ++numValid;
        }
        return numValid;
    }

    public static boolean inputLatches(IInPin inPin) {
        for (IOutPin iOutPin : inPin.getConnections()) {
            if (!(iOutPin instanceof ILogicOutPin)) continue;
            return ((ILogicOutPin)iOutPin).latches();
        }
        return false;
    }
}

