/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import pyrosim.Intl;
import pyrosim.domain.variant.Variant;
import pyrosim.io.PyroSimObjectInputStream;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public interface IGeometry
extends Serializable {
    public static final Default DEFAULT = new Default();
    public static final Cartesian CARTESIAN = new Cartesian(null, null, null);
    public static final Spherical SPHERICAL = new Spherical(null, null);
    public static final Cylindrical CYLINDRICAL = new Cylindrical(null, null, null);

    public String getName();

    public static class Cylindrical
    extends Spherical {
        static final long serialVersionUID = 1L;
        public final Variant lengthVar;
        @Deprecated
        public final UnitDouble length;

        public Cylindrical(UnitDouble innerRadius, UnitDouble radius, Variant length) {
            super(innerRadius, radius);
            this.lengthVar = length;
            this.length = null;
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + super.hashCode();
            hash = 31 * hash + theUtil.hashCode(this.lengthVar);
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Cylindrical)) {
                return false;
            }
            return super.equals(obj) && theUtil.equal(this.lengthVar, ((Cylindrical)obj).lengthVar);
        }

        @Override
        public String getName() {
            return Intl.intl("Cylindrical");
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            if (stream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)stream).getVersion() < 108) {
                try {
                    theUtil.assignFinalField(this, Cylindrical.class, "lengthVar", Variant.constant(this.length));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public static class Spherical
    implements IGeometry {
        static final long serialVersionUID = 1L;
        public final UnitDouble innerRadius;
        public final UnitDouble radius;

        public Spherical(UnitDouble innerRadius, UnitDouble radius) {
            this.innerRadius = innerRadius;
            this.radius = radius;
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + theUtil.hashCode(this.innerRadius);
            hash = 31 * hash + theUtil.hashCode(this.radius);
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Spherical)) {
                return false;
            }
            Spherical geo = (Spherical)obj;
            return theUtil.equal(this.innerRadius, geo.innerRadius) && theUtil.equal(this.radius, geo.radius);
        }

        @Override
        public String getName() {
            return Intl.intl("Spherical");
        }
    }

    public static class Cartesian
    implements IGeometry {
        static final long serialVersionUID = 1L;
        public final UnitDouble length;
        public final UnitDouble width;
        public final UnitDouble thickness;

        public Cartesian(UnitDouble length, UnitDouble width) {
            this(length, width, null);
        }

        public Cartesian(UnitDouble length, UnitDouble width, UnitDouble thickness) {
            this.length = length;
            this.width = width;
            this.thickness = thickness;
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + theUtil.hashCode(this.length);
            hash = 31 * hash + theUtil.hashCode(this.width);
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Cartesian)) {
                return false;
            }
            Cartesian geo = (Cartesian)obj;
            return theUtil.equal(this.length, geo.length) && theUtil.equal(this.width, geo.width);
        }

        @Override
        public String getName() {
            return Intl.intl("Cartesian");
        }
    }

    public static class Default
    implements IGeometry {
        static final long serialVersionUID = 1L;

        @Override
        public String getName() {
            return Intl.intl("Default");
        }

        private Object readResolve() throws ObjectStreamException {
            return DEFAULT;
        }
    }
}

