/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.domain.Grid;
import pyrosim.domain.GridMergeUtil;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.Vent;
import pyrosim.util.Util;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSeg3D;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.nmt.EdgeUse;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.FaceLoop;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.util.Pair;

public class GridUtil {
    public static List<Pair<Grid, List<Vent>>> constructVents(Collection<? extends Grid> grids, Map<Grid, GridMergeUtil.BoundaryInfo> gridBoundaries, Surface surf, GridFace ... faces) {
        ArrayList<Pair<Grid, List<Vent>>> resultVents = new ArrayList<Pair<Grid, List<Vent>>>();
        for (Grid grid : grids) {
            GridMergeUtil.BoundaryInfo bi = gridBoundaries.get(grid);
            if (bi == null) continue;
            List<Vent> vents = new ArrayList();
            block1: for (Face face : bi.faces) {
                for (GridFace gf : faces) {
                    if (!GridUtil.equal(face.plane, gf.getPlane(grid), 1.0E-9)) continue;
                    Collection<Face> splitFaces = GridUtil.divideFaces(face);
                    for (Face splitFace : splitFaces) {
                        AABox sfBounds = splitFace.getBounds();
                        AARectangle rface = AARectangle.construct(sfBounds.getMin(), sfBounds.getMax(), 1.0E-6, false);
                        if (rface == null) {
                            System.err.println("Could not construct vent face from mesh boundary.");
                            continue;
                        }
                        String name = String.format(Intl.intl("Mesh Vent: %1$s [%2$s]"), grid.getName(), gf.name());
                        Vent v = new Vent(name, surf, rface);
                        vents.add(v);
                    }
                    continue block1;
                }
            }
            if (vents.isEmpty()) continue;
            vents = Util.sort(vents);
            resultVents.add(new Pair(grid, vents));
        }
        return resultVents;
    }

    private static Collection<Face> divideFaces(Face face) {
        Vector3d edir;
        int faxis = Util3D.getClosestAxis(face.plane.getNormal());
        int splitAxis = faxis == 2 ? 0 : 2;
        ArrayList<LineSeg> linesToAdd = new ArrayList<LineSeg>();
        for (FaceLoop loop : face.edgeLoops) {
            for (EdgeUse eu : loop.edges) {
                edir = eu.getTangent(0.0);
                int eaxis = Util3D.getClosestAxis(edir);
                if (eaxis != splitAxis) continue;
                linesToAdd.add(new LineSeg(eu.v1().loc, eu.v2().loc));
            }
        }
        if (linesToAdd.isEmpty()) {
            return Arrays.asList(face);
        }
        AABox bounds = face.getBounds();
        Model fmod = new Model();
        fmod.addFace(face, 0);
        for (LineSeg ls : linesToAdd) {
            edir = ls.getTangent(0.0, ICurve.Orient.POSITIVE, false);
            double[] isect = Inter3D.lineAABoxIsect(ls.p1, edir, bounds.getMin(), bounds.getMax(), 1.0E-9);
            if (isect == null) continue;
            Point3d p1 = ls.evaluate(isect[0]);
            Point3d p2 = ls.evaluate(isect[1]);
            fmod.addEdge(0, new LineSeg3D(p1, p2));
        }
        return fmod.getFaces();
    }

    protected static boolean equal(Plane3d plane1, Plane3d plane2, double tol) {
        return plane1.epsilonEquals(plane2, tol) || plane1.epsilonEquals(plane2.negate(), tol);
    }

    public static final class GridFace
    extends Enum<GridFace> {
        public static final /* enum */ GridFace XMIN = new GridFace();
        public static final /* enum */ GridFace XMAX = new GridFace();
        public static final /* enum */ GridFace YMIN = new GridFace();
        public static final /* enum */ GridFace YMAX = new GridFace();
        public static final /* enum */ GridFace ZMIN = new GridFace();
        public static final /* enum */ GridFace ZMAX = new GridFace();
        private static final /* synthetic */ GridFace[] $VALUES;

        public static GridFace[] values() {
            return (GridFace[])$VALUES.clone();
        }

        public static GridFace valueOf(String name) {
            return Enum.valueOf(GridFace.class, name);
        }

        public Plane3d getPlane(Grid grid) {
            AABox gbounds = grid.getBounds();
            switch (this) {
                case XMIN: {
                    return new Plane3d(-1.0, 0.0, 0.0, gbounds.getMinX());
                }
                case XMAX: {
                    return new Plane3d(1.0, 0.0, 0.0, -gbounds.getMaxX());
                }
                case YMIN: {
                    return new Plane3d(0.0, -1.0, 0.0, gbounds.getMinY());
                }
                case YMAX: {
                    return new Plane3d(0.0, 1.0, 0.0, -gbounds.getMaxY());
                }
                case ZMIN: {
                    return new Plane3d(0.0, 0.0, -1.0, gbounds.getMinZ());
                }
                case ZMAX: {
                    return new Plane3d(0.0, 0.0, 1.0, -gbounds.getMaxZ());
                }
            }
            assert (false);
            return null;
        }

        static {
            $VALUES = new GridFace[]{XMIN, XMAX, YMIN, YMAX, ZMIN, ZMAX};
        }
    }
}

