/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.SkipDep;
import pyrosim.geom.IGeomSource;
import thunderheadeng.gui.ADomainObject;
import thunderheadeng.util.theUtil;

public abstract class APyroObject
extends ADomainObject<PyroMod>
implements IPyroObject {
    static final long serialVersionUID = 1L;
    @SkipDep
    private transient IPyroObject d_parent = null;
    private boolean d_enabled = true;

    @Override
    public Object clone() {
        APyroObject obj = (APyroObject)super.clone();
        obj.d_parent = null;
        return obj;
    }

    protected void removeFromDomain(PyroMod domain) {
        for (IPyroObject iPyroObject : this.getMembers()) {
            iPyroObject.setDomain(null, null);
        }
        if (this instanceof IGeomSource) {
            domain.getGeomLocator().remove((IGeomSource)((Object)this));
            if (this.registerProximity()) {
                domain.getGeomProx().remove((IGeomSource)((Object)this));
            }
        }
        if (this instanceof INamed) {
            domain.getNames(this).unregisterName(((INamed)((Object)this)).getName());
        }
        this.removedEvt((Object)this);
        this.d_parent = null;
    }

    protected void addToDomain(PyroMod domain, IPyroObject parent) {
        this.d_parent = parent;
        this.addedEvt((Object)this);
        if (this instanceof INamed) {
            domain.getNames(this).registerName(((INamed)((Object)this)).getName());
        }
        if (this instanceof IGeomSource) {
            domain.getGeomLocator().add((IGeomSource)((Object)this));
            if (this.registerProximity()) {
                domain.getGeomProx().add((IGeomSource)((Object)this));
            }
        }
        for (IPyroObject iPyroObject : this.getMembers()) {
            iPyroObject.setDomain(domain, this);
        }
    }

    @Override
    @Deprecated
    public void setDomain(PyroMod owner) {
        super.setDomain(owner);
    }

    @Override
    public void setDomain(PyroMod domain, IPyroObject parent) {
        if (this.getDomain() == domain) {
            return;
        }
        if (this.getDomain() != null) {
            this.pauseUpdates();
            this.removeFromDomain((PyroMod)this.getDomain());
            this.resumeUpdates();
        }
        super.setDomain(domain);
        if (domain != null) {
            this.pauseUpdates();
            this.addToDomain((PyroMod)this.getDomain(), parent);
            this.resumeUpdates();
        }
    }

    @Override
    public IPyroObject getParent() {
        return this.d_parent;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.d_enabled == enabled) {
            return;
        }
        this.d_enabled = enabled;
        if (this.getDomain() != null) {
            this.changedEvt(PyroMod.EVT_ENABLED_CHANGED);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.d_enabled;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_enabled = true;
        in.defaultReadObject();
    }

    protected boolean registerProximity() {
        return false;
    }

    @Override
    public boolean changedEvt(Object ... changes) {
        this.pauseUpdates();
        IPyroObject parent = this.getParent();
        if (parent instanceof Composite && !APyroObject.changesExclusiveTo(changes, PyroMod.EVT_SEL)) {
            ((Composite)parent).changedEvt(new Object[0]);
        }
        if (this.getDomain() != null && this instanceof IGeomSource && ((PyroMod)this.getDomain()).isListening() && !APyroObject.changesExclusiveTo(changes, PyroMod.EVT_SEL, PyroMod.EVT_VISIBILITY_CHANGED, PyroMod.EVT_APPEARANCE, PyroMod.EVT_PARENT_CHANGED)) {
            ((PyroMod)this.getDomain()).getGeomLocator().update((IGeomSource)((Object)this));
            if (this.registerProximity()) {
                ((PyroMod)this.getDomain()).getGeomProx().update((IGeomSource)((Object)this));
            }
        }
        boolean result = super.changedEvt(changes);
        this.resumeUpdates();
        return result;
    }

    protected static boolean changesExclusiveTo(Object[] changeList, Object ... changes) {
        if (changeList.length == 0) {
            return false;
        }
        for (Object c1 : changeList) {
            boolean found = false;
            for (Object c2 : changes) {
                if (c1 != c2) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<? extends IPyroObject> getMembers() {
        return Collections.EMPTY_LIST;
    }

    public <T> Collection<T> getMembers(Class<T> type) {
        return theUtil.filter(this.getMembers(), type);
    }

    public <T> Collection<T> getMembers(Class<T> type, Predicate<? super T> filter) {
        return theUtil.filter(this.getMembers(), type, filter);
    }

    public <T> Collection<T> flatten(Class<T> type) {
        return Hierarchy.flatten(this.getMembers(), type);
    }

    public <T> Collection<T> flatten(Class<T> type, Predicate<? super T> filter) {
        return Hierarchy.flatten(this.getMembers(), type, filter);
    }
}

