/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.jeuclid.font.FontFactory;

public class DefaultFontFactory
extends FontFactory {
    private Map<String, Font> fontCache = new HashMap<String, Font>();

    DefaultFontFactory() {
    }

    public Font getFont(String name, int style, int size) {
        Font font = this.fontCache.get(name);
        font = font == null ? new Font(name, style, size) : font.deriveFont(style, size);
        return font;
    }

    public Font registerFont(int format, File fontFile) throws IOException, FontFormatException {
        return this.cacheFont(Font.createFont(format, fontFile));
    }

    public Font registerFont(int format, InputStream fontStream) throws IOException, FontFormatException {
        return this.cacheFont(Font.createFont(format, fontStream));
    }

    protected Font cacheFont(Font font) {
        this.fontCache.put(font.getFontName(), font);
        this.fontCache.put(font.getFamily(), font);
        return font;
    }
}

