/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.support.attributes;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.jeuclid.elements.support.attributes.AbstractAttributeMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMAttributeMap
extends AbstractAttributeMap {
    private final NamedNodeMap namedNodeMap;

    public DOMAttributeMap(NamedNodeMap attributeMap) {
        this.namedNodeMap = attributeMap;
    }

    @Override
    protected String getAttribute(String attrName) {
        Node valueNode = this.namedNodeMap.getNamedItem(attrName);
        if (valueNode == null) {
            return null;
        }
        return valueNode.getNodeValue();
    }

    @Override
    protected String getAttributeNS(String namespace, String attrName) {
        Node valueNode = this.namedNodeMap.getNamedItemNS(namespace, attrName);
        if (valueNode == null) {
            return null;
        }
        return valueNode.getNodeValue();
    }

    @Override
    public Map<String, String> getAsMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        for (int i = 0; i < this.namedNodeMap.getLength(); ++i) {
            Node n = this.namedNodeMap.item(i);
            m.put(n.getNodeName(), n.getNodeValue());
        }
        return m;
    }

    public String toString() {
        return this.getAsMap().toString();
    }
}

