/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.script;

import java.awt.Graphics2D;
import net.sourceforge.jeuclid.MathBase;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.presentation.script.AbstractSubSuper;
import org.w3c.dom.DOMException;
import org.w3c.dom.mathml.MathMLElement;
import org.w3c.dom.mathml.MathMLScriptElement;

public class Msub
extends AbstractSubSuper
implements MathMLScriptElement {
    public static final String ELEMENT = "msub";

    public Msub(MathBase base) {
        super(base);
    }

    public void paint(Graphics2D g, float posX, float posY) {
        super.paint(g, posX, posY);
        JEuclidElement e1 = this.getMathElement(0);
        JEuclidElement e2 = this.getMathElement(1);
        e1.paint(g, posX, posY);
        e2.paint(g, posX + e1.getWidth(g), posY + this.getSubBaseLineShift(g));
    }

    public float calculateWidth(Graphics2D g) {
        return this.getMathElement(0).getWidth(g) + this.getMathElement(1).getWidth(g);
    }

    public float calculateAscentHeight(Graphics2D g) {
        return this.getMathElement(0).getAscentHeight(g);
    }

    public float calculateDescentHeight(Graphics2D g) {
        return this.caclulateDescentHeightWithSub(g);
    }

    public int getScriptlevelForChild(JEuclidElement child) {
        if (child.isSameNode(this.getFirstChild())) {
            return this.getAbsoluteScriptLevel();
        }
        return this.getAbsoluteScriptLevel() + 1;
    }

    public boolean isChildBlock(JEuclidElement child) {
        if (child.isSameNode(this.getFirstChild())) {
            return super.isChildBlock(child);
        }
        return false;
    }

    public String getTagName() {
        return ELEMENT;
    }

    public JEuclidElement getBase() {
        return this.getMathElement(0);
    }

    public JEuclidElement getSubscript() {
        return this.getMathElement(1);
    }

    public JEuclidElement getSuperscript() {
        return null;
    }

    public void setBase(MathMLElement base) {
        this.setMathElement(0, base);
    }

    public void setSubscript(MathMLElement subscript) {
        this.setMathElement(1, subscript);
    }

    public void setSuperscript(MathMLElement superscript) {
        throw new DOMException(3, "msub does not have superscript");
    }
}

