/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.converter;

import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import net.sourceforge.jeuclid.converter.ConverterRegistry;
import net.sourceforge.jeuclid.converter.ImageIOConverter;

public final class ImageIODetector {
    private ImageIODetector() {
    }

    public static void detectConversionPlugins(ConverterRegistry registry) {
        String[] mimeTypes;
        for (String mimeType : mimeTypes = ImageIO.getWriterMIMETypes()) {
            Iterator<ImageWriter> iwit = ImageIO.getImageWritersByMIMEType(mimeType);
            if (iwit == null) continue;
            while (iwit.hasNext()) {
                ImageWriter iw = iwit.next();
                String[] suffixes = iw.getOriginatingProvider().getFileSuffixes();
                if (suffixes != null) {
                    for (String suffix : suffixes) {
                        registry.registerMimeTypeAndSuffix(mimeType, suffix, false);
                    }
                }
                registry.registerConverter(mimeType, new ImageIOConverter(iw), false);
            }
        }
    }
}

