/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util.time;

import thunderheadeng.util.time.AClock;

public class WallClock
extends AClock {
    private long d_timeOffset;
    private long d_timeOnResume;

    public WallClock() {
        this(0.0, 1.0);
    }

    public WallClock(double tOffset, double scale) {
        this.setScale(scale);
        this.setTime(tOffset);
    }

    @Override
    public void setScale(double scale) {
        if (this.isPaused()) {
            this.d_timeOnResume = (long)((double)this.d_timeOnResume * this.getScale() / scale);
        } else {
            long rt = System.nanoTime();
            long currTime = rt - this.d_timeOffset;
            this.d_timeOffset = rt - (long)(this.getScale() / scale * (double)currTime);
        }
        super.setScale(scale);
    }

    @Override
    public void setTime(double time) {
        double[] range = this.getRange();
        if (time > range[1]) {
            time = range[1];
        } else if (time < range[0]) {
            time = range[0];
        }
        long runningTime = System.nanoTime();
        long newTime = this.toTickUnit(time);
        if (this.isPaused()) {
            this.d_timeOnResume = newTime;
        } else {
            this.d_timeOffset = runningTime - newTime;
        }
    }

    @Override
    public double getTime() {
        double time = this.isPaused() ? this.toTimeUnit(this.d_timeOnResume) : this.toTimeUnit(System.nanoTime() - this.d_timeOffset);
        return this.clampTime(time);
    }

    @Override
    public double pause() {
        if (this.isPaused()) {
            return this.getTime();
        }
        this.d_timeOnResume = System.nanoTime() - this.d_timeOffset;
        super.pause();
        return (double)this.d_timeOnResume * 1.0E-9 * this.getScale();
    }

    @Override
    public double resume() {
        if (!this.isPaused()) {
            return this.getTime();
        }
        super.resume();
        this.d_timeOffset = System.nanoTime() - this.d_timeOnResume;
        return (double)this.d_timeOnResume * 1.0E-9 * this.getScale();
    }

    private double toTimeUnit(long ticks) {
        return (double)ticks * 1.0E-9 * this.getScale();
    }

    private long toTickUnit(double t) {
        return (long)(t / (1.0E-9 * this.getScale()));
    }
}

