/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.BiDoublePredicate;
import thunderheadeng.util.BiIntPredicate;
import thunderheadeng.util.CachedSupplier;
import thunderheadeng.util.Disposable;
import thunderheadeng.util.FilteredCollection;
import thunderheadeng.util.FilteredCollection2;
import thunderheadeng.util.FlatMappedCollection;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IntComparator;
import thunderheadeng.util.IntToFloatFunction;
import thunderheadeng.util.MappedCollection;
import thunderheadeng.util.MappedList;
import thunderheadeng.util.Pair;
import thunderheadeng.util.ReversedList;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.TypeFilteredCollection;
import thunderheadeng.util.theTimer;

public class theUtil {
    private static final float[] R = new float[]{0.4f, 0.6f};
    private static final float[] G = new float[]{0.4f, 0.6f};
    private static final float[] B = new float[]{0.5f, 0.8f};
    private static final Random DEF_RAND = new Random();
    private static final int REVERSE_THRESHOLD = 18;

    public static boolean equal(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1 == o2 || o1.equals(o2);
    }

    public static int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public static int hashCode(double d) {
        long v = Double.doubleToLongBits(d);
        return (int)(v ^ v >>> 32);
    }

    public static int hashCode(boolean b) {
        return b ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode();
    }

    public static <T> Collection<T> cast(Collection<?> orig, Collection<T> result, Class<T> resultType) {
        for (Object o : orig) {
            result.add(resultType.cast(o));
        }
        return result;
    }

    public static Vector3d projectToPlane(Vector3d planeNormal, Vector3d point) {
        Vector3d projPoint = new Vector3d(point);
        double dist = planeNormal.dot(projPoint);
        Vector3d moveVec = new Vector3d(planeNormal);
        moveVec.scale(-dist);
        projPoint.add((Tuple3d)moveVec);
        return projPoint;
    }

    public static double angleBetweenNPIToPPI(Vector3d axis, Vector3d ref, Vector3d vec) {
        double angle = ref.angle(vec);
        Vector3d cross = new Vector3d();
        cross.cross(ref, vec);
        double dot = cross.dot(axis);
        if (dot >= 0.0) {
            return angle;
        }
        return -angle;
    }

    public static double angleBetween0To2PI(Vector3d axis, Vector3d v1, Vector3d v2) {
        double anglePIPI = theUtil.angleBetweenNPIToPPI(axis, v1, v2);
        if (anglePIPI >= 0.0) {
            return anglePIPI;
        }
        return Math.PI * 2 + anglePIPI;
    }

    public static UnitDouble roundAngle(UnitDouble angle, UnitDouble nearestInc, Unit u) {
        double angleRad = angle.getValue(SI.RADIAN);
        double nearestIncRad = nearestInc.getValue(SI.RADIAN);
        long numRevs = Math.round(Math.PI * 2 / nearestIncRad);
        long mult = Math.round(Math.abs(angleRad) / nearestIncRad) % numRevs;
        if (angleRad < 0.0) {
            mult = -mult;
        }
        double nativeValue = nearestInc.getValueNoUnit() * (double)mult;
        double convertedValue = UnitDouble.convert(nativeValue, nearestInc.getUnit(), u);
        return new UnitDouble(convertedValue, u);
    }

    public static Point3d p4dTo3d(Point4d p) {
        double invw = 1.0 / p.w;
        return new Point3d(p.x * invw, p.y * invw, p.z * invw);
    }

    public static void acquire(Disposable obj) {
        if (obj != null) {
            obj.acquire();
        }
    }

    public static void acquire(Disposable[] objs) {
        if (objs != null) {
            for (int m = 0; m < objs.length; ++m) {
                if (objs[m] == null) continue;
                objs[m].acquire();
            }
        }
    }

    public static <T> void acquire(Collection<T> objs) {
        if (objs != null) {
            for (T obj : objs) {
                theUtil.acquire(obj);
            }
        }
    }

    public static void acquire(Object obj) {
        if (obj instanceof Disposable) {
            ((Disposable)obj).acquire();
        }
    }

    public static void acquire(Object[] objs) {
        if (objs != null) {
            for (int m = 0; m < objs.length; ++m) {
                if (!(objs[m] instanceof Disposable)) continue;
                ((Disposable)objs[m]).acquire();
            }
        }
    }

    public static void release(Disposable obj) {
        if (obj != null) {
            obj.release();
        }
    }

    public static void release(Disposable[] objs) {
        if (objs != null) {
            for (int m = 0; m < objs.length; ++m) {
                if (objs[m] == null) continue;
                objs[m].release();
            }
        }
    }

    public static <T> void release(Collection<T> objs) {
        if (objs != null) {
            for (T obj : objs) {
                theUtil.release(obj);
            }
        }
    }

    public static void release(Object obj) {
        if (obj instanceof Disposable) {
            ((Disposable)obj).release();
        }
    }

    public static void release(Object[] objs) {
        if (objs != null) {
            for (int m = 0; m < objs.length; ++m) {
                if (!(objs[m] instanceof Disposable)) continue;
                ((Disposable)objs[m]).release();
            }
        }
    }

    public static String getFileExtension(File f) {
        String name = f.getAbsolutePath();
        int extix = name.lastIndexOf(".");
        if (extix >= 0 && extix < name.length() - 1) {
            return name.substring(extix + 1);
        }
        return "";
    }

    public static int binarySearch(double[] a, double key, DoubleComparator comp) {
        return theUtil.binarySearch(a, key, 0, a.length - 1, comp);
    }

    private static int binarySearch(double[] a, double key, int low, int high, DoubleComparator comp) {
        while (low <= high) {
            int mid = low + high >> 1;
            double midVal = a[mid];
            int cmp = comp.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static <T> int binarySearch(List<? extends T> list, T key, Comparator<? super T> comp) {
        return theUtil.binarySearch(list, key, 0, list.size() - 1, comp);
    }

    public static <T> int binarySearch(List<? extends T> list, T key, int low, int high, Comparator<? super T> comp) {
        while (low <= high) {
            int mid = low + high >> 1;
            T midVal = list.get(mid);
            int cmp = comp.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static <T extends Number> int[] toIntArray(Collection<T> coll) {
        if (coll == null) {
            return new int[0];
        }
        int[] values = new int[coll.size()];
        int index = 0;
        for (Number val : coll) {
            values[index++] = val.intValue();
        }
        return values;
    }

    public static Integer[] toIntArray(int ... vals) {
        Integer[] arr = new Integer[vals.length];
        for (int m = 0; m < vals.length; ++m) {
            arr[m] = vals[m];
        }
        return arr;
    }

    public static <T extends Number> double[] toDoubleArray(Collection<T> coll) {
        if (coll == null) {
            return new double[0];
        }
        double[] values = new double[coll.size()];
        int ix = 0;
        for (Number val : coll) {
            values[ix++] = val.doubleValue();
        }
        return values;
    }

    public static <T extends Number> double[] toDoubleArray(Double[] vals) {
        return theUtil.toDoubleArray(Arrays.asList(vals));
    }

    public static <T> T[] toArray(Collection<T> coll) {
        assert (!coll.isEmpty());
        if (coll.isEmpty()) {
            return null;
        }
        return theUtil.toArray(coll, coll.iterator().next().getClass());
    }

    public static <T> T[] toArray(Collection<? extends T> coll, Class<T> type) {
        assert (type != null);
        if (coll == null) {
            return (Object[])Array.newInstance(type, 0);
        }
        Object[] array = (Object[])Array.newInstance(type, coll.size());
        return coll.toArray(array);
    }

    public static <T> T serialCopy(T obj) throws IOException, NotSerializableException {
        try {
            ByteArrayOutputStream bufferStream = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(bufferStream);
            os.writeObject(obj);
            os.close();
            byte[] data = bufferStream.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            ObjectInputStream is = new ObjectInputStream(inputStream);
            return (T)is.readObject();
        }
        catch (ClassNotFoundException e) {
            assert (false);
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public static double doubleResolution(double val) {
        long lval = Double.doubleToLongBits(val);
        return Double.longBitsToDouble(++lval) - val;
    }

    public static float floatResolution(float val) {
        int ival = Float.floatToIntBits(val);
        return Float.intBitsToFloat(++ival) - val;
    }

    public static int[] randomList(int min, int max) {
        return theUtil.randomList(min, max, new Random());
    }

    public static int[] randomList(int min, int max, Random rand) {
        ArrayList<Integer> ints = new ArrayList<Integer>(max - min + 1);
        for (int m = min; m <= max; ++m) {
            ints.add(m);
        }
        Collections.shuffle(ints, rand);
        return theUtil.toIntArray(ints);
    }

    public static <T> List<T> randomize(Collection<? extends T> coll) {
        return theUtil.randomize(coll, new Random());
    }

    public static <T> List<T> randomize(Collection<? extends T> coll, Random rand) {
        ArrayList<? extends T> list = new ArrayList<T>(coll);
        Collections.shuffle(list, rand);
        return list;
    }

    public static <T> Collection<T> sort(Comparator<T> comparator, T ... objs) {
        return theUtil.sort(comparator, Arrays.asList(objs));
    }

    public static <T> Collection<T> sort(Comparator<T> comparator, Collection<? extends T> objs) {
        TreeSet<T> set = new TreeSet<T>(comparator);
        set.addAll(objs);
        return set;
    }

    public static <T> T findObjectForClass(Map<Class, T> map, Class type) {
        if (type == null) {
            return null;
        }
        T obj = map.get(type);
        if (obj != null) {
            return obj;
        }
        obj = theUtil.findObjectForClass(map, type.getSuperclass());
        if (obj != null) {
            return obj;
        }
        for (Class<?> ifaceClass : type.getInterfaces()) {
            obj = theUtil.findObjectForClass(map, ifaceClass);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public static <T> Collection<T> findObjectsForClass(Map<Class, T> map, Class type, Collection<T> objs) {
        for (Map.Entry<Class, T> entry : map.entrySet()) {
            if (!entry.getKey().isAssignableFrom(type)) continue;
            objs.add(entry.getValue());
        }
        return objs;
    }

    public static <T> T findObjectForArrayClass(boolean preferSuperClasses, Map<Class, T> map, Class type) {
        if (type == null) {
            return null;
        }
        T obj = map.get(type);
        if (obj != null) {
            return obj;
        }
        Pair<Class, Integer> root = theUtil.getComponentRoot(type);
        if (preferSuperClasses) {
            T result = theUtil.searchSuperArray(preferSuperClasses, map, (Class)root.v1, (Integer)root.v2);
            if (result != null) {
                return result;
            }
            return theUtil.searchInterfacesArray(preferSuperClasses, map, (Class)root.v1, (Integer)root.v2);
        }
        T result = theUtil.searchInterfacesArray(preferSuperClasses, map, (Class)root.v1, (Integer)root.v2);
        if (result != null) {
            return result;
        }
        return theUtil.searchSuperArray(preferSuperClasses, map, (Class)root.v1, (Integer)root.v2);
    }

    private static <T> T searchSuperArray(boolean preferSuperClasses, Map<Class, T> map, Class compRoot, int numDimensions) {
        Class superClass = theUtil.getArrayClass(compRoot.getSuperclass(), numDimensions);
        return theUtil.findObjectForArrayClass(preferSuperClasses, map, superClass);
    }

    private static <T> T searchInterfacesArray(boolean preferSuperClasses, Map<Class, T> map, Class compRoot, int numDimensions) {
        for (Class<?> clazz : compRoot.getInterfaces()) {
            Class clazz2 = theUtil.getArrayClass(clazz, numDimensions);
            T obj = theUtil.findObjectForArrayClass(preferSuperClasses, map, clazz2);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public static Class getSuperArrayClass(Class arrayClazz) {
        int numLevels = 0;
        while (arrayClazz.isArray()) {
            ++numLevels;
            arrayClazz = arrayClazz.getComponentType();
        }
        Class<Object> result = arrayClazz.getSuperclass();
        for (int m = 0; m < numLevels; ++m) {
            result = theUtil.getArrayClass(result);
        }
        return result;
    }

    public static Pair<Class, Integer> getComponentRoot(Class clazz) {
        int numLevels = 0;
        while (clazz.isArray()) {
            ++numLevels;
            clazz = clazz.getComponentType();
        }
        return new Pair<Class, Integer>(clazz, numLevels);
    }

    public static void processComponentRoot(Class type, BiConsumer<Class, Integer> processor) {
        int numLevels = 0;
        while (type.isArray()) {
            ++numLevels;
            type = type.getComponentType();
        }
        processor.accept(type, numLevels);
    }

    public static Class getArrayClass(Class clazz, int numDimensions) {
        for (int m = 0; m < numDimensions; ++m) {
            clazz = theUtil.getArrayClass(clazz);
        }
        return clazz;
    }

    public static <T> Class<? extends T[]> getArrayClass(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        return Array.newInstance(clazz, 0).getClass();
    }

    public static <T> Collection<T> findObjectsForLowerClass(Map<Class, T> map, Class type, Collection<T> objs) {
        for (Map.Entry<Class, T> entry : map.entrySet()) {
            if (!type.isAssignableFrom(entry.getKey())) continue;
            objs.add(entry.getValue());
        }
        return objs;
    }

    public static <T> T[] append(Class<T> clazz, T[] arr1, T ... arr2) {
        int m;
        Object[] arr = (Object[])Array.newInstance(clazz, arr1.length + arr2.length);
        for (m = 0; m < arr1.length; ++m) {
            arr[m] = arr1[m];
        }
        while (m < arr.length) {
            arr[m] = arr2[m - arr1.length];
            ++m;
        }
        return arr;
    }

    public static int[] append(int[] arr1, int ... arr2) {
        int m;
        if (arr2.length == 0) {
            return arr1;
        }
        if (arr1.length == 0) {
            return arr2;
        }
        int[] arr = new int[arr1.length + arr2.length];
        for (m = 0; m < arr1.length; ++m) {
            arr[m] = arr1[m];
        }
        while (m < arr.length) {
            arr[m] = arr2[m - arr1.length];
            ++m;
        }
        return arr;
    }

    public static Color newRandomColor() {
        return theUtil.newRandomColor(DEF_RAND, R[0], R[1], G[0], G[1], B[0], B[1]);
    }

    public static Color newRandomColor(float minRed, float maxRed, float minGreen, float maxGreen, float minBlue, float maxBlue) {
        return theUtil.newRandomColor(DEF_RAND, minRed, maxRed, minGreen, maxGreen, minBlue, maxBlue);
    }

    public static Color newRandomColor(Random rand, float minRed, float maxRed, float minGreen, float maxGreen, float minBlue, float maxBlue) {
        return new Color(theUtil.randomFloat(rand, minRed, maxRed), theUtil.randomFloat(rand, minGreen, maxGreen), theUtil.randomFloat(rand, minBlue, maxBlue));
    }

    private static float randomFloat(Random rand, float min, float max) {
        float dx = max - min;
        return rand.nextFloat() * dx + min;
    }

    public static final boolean le(double v1, double v2, double tol) {
        return v1 - v2 <= tol;
    }

    public static final boolean le0(double v, double tol) {
        return v <= tol;
    }

    public static final boolean ge(double v1, double v2, double tol) {
        return v1 - v2 >= -tol;
    }

    public static final boolean ge0(double v, double tol) {
        return v >= -tol;
    }

    public static final boolean lt(double v1, double v2, double tol) {
        return v1 - v2 < -tol;
    }

    public static final boolean lt0(double v, double tol) {
        return v < -tol;
    }

    public static final boolean gt(double v1, double v2, double tol) {
        return v1 - v2 > tol;
    }

    public static final boolean gt0(double v, double tol) {
        return v > tol;
    }

    public static final boolean eq(double v1, double v2, double tol) {
        return Math.abs(v1 - v2) <= tol;
    }

    public static final boolean eq0(double v, double tol) {
        return Math.abs(v) <= tol;
    }

    public static final boolean releq(double v1, double v2, double tol) {
        double reltol = Math.max(Math.abs(v1), Math.abs(v2)) * tol;
        return Math.abs(v1 - v2) <= reltol;
    }

    public static int compare(double d1, double d2, double epsilon) {
        if (Math.abs(d1 - d2) <= epsilon) {
            return 0;
        }
        if (d1 > d2) {
            return 1;
        }
        return -1;
    }

    public static <T> boolean containsEquiv(T obj, T ... list) {
        for (T listObj : list) {
            if (!listObj.equals(obj)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean contains(T obj, T ... list) {
        for (T listObj : list) {
            if (listObj != obj) continue;
            return true;
        }
        return false;
    }

    public static byte toCCb(float ccf) {
        return (byte)(ccf * 255.0f);
    }

    public static float toCCf(byte ccb) {
        int comp = 0xFF & ccb;
        return (float)comp / 255.0f;
    }

    public static long randomSeed(Random rand) {
        double dseed = -9.223372036854776E18 + rand.nextDouble() * 1.8446744073709552E19;
        return (long)dseed;
    }

    public static List<Integer> toList(int[] objs) {
        if (objs == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(objs).boxed().collect(Collectors.toList());
    }

    public static List<Double> toList(double[] objs) {
        if (objs == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(objs).boxed().collect(Collectors.toList());
    }

    public static <T> List<? extends T> toList(Iterable<? extends T> objs) {
        if (objs instanceof List) {
            return (List)objs;
        }
        return (List)theUtil.toCollection(new ArrayList(), objs);
    }

    public static <T> Set<? extends T> toSet(Iterable<? extends T> objs) {
        if (objs instanceof Set) {
            return (Set)objs;
        }
        return (Set)theUtil.toCollection(new HashSet(), objs);
    }

    public static <T> Collection<? extends T> toCollection(Iterable<? extends T> objs) {
        if (objs instanceof Collection) {
            return (Collection)objs;
        }
        return theUtil.toCollection(new ArrayList(), objs);
    }

    private static <T> Collection<? extends T> toCollection(Collection<T> coll, Iterable<? extends T> objs) {
        for (T obj : objs) {
            coll.add(obj);
        }
        return coll;
    }

    public static double lerp(double v1, double v2, double t) {
        return (v2 - v1) * t + v1;
    }

    public static void assignFinalField(Object obj, String strField, Object val) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        theUtil.assignFinalField(obj, obj.getClass(), strField, val);
    }

    public static void assignFinalField(Object obj, Class<?> clazz, String strField, Object val) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = clazz.getDeclaredField(strField);
        boolean accessible = f.isAccessible();
        f.setAccessible(true);
        f.set(obj, val);
        if (!accessible) {
            f.setAccessible(false);
        }
    }

    public static <T> IFilteredCollection<T> filter(Collection<?> coll, Class<T> type) {
        return new TypeFilteredCollection<T>(coll, type);
    }

    public static <T> IFilteredCollection<T> filter(Collection<? extends T> coll, Predicate<? super T> filter) {
        return new FilteredCollection2<T>(coll, filter);
    }

    public static <T> IFilteredCollection<T> filter(Collection<?> coll, Class<T> type, Predicate<? super T> filter) {
        return new FilteredCollection<T>(coll, type, filter);
    }

    public static <InT, OutT> Collection<OutT> flatMap(Collection<InT> coll, Function<? super InT, ? extends Iterable<? extends OutT>> mapper) {
        return new FlatMappedCollection(coll, mapper);
    }

    public static <InT, OutT> Collection<OutT> map(Collection<InT> coll, Function<InT, OutT> mapper) {
        return new MappedCollection<InT, OutT>(coll, mapper);
    }

    public static <InT, OutT> Set<OutT> map(Set<InT> coll, Function<InT, OutT> mapper) {
        return (Set)theUtil.map(coll, mapper);
    }

    public static <InT, OutT> Collection<OutT> map(Collection<InT> collection, Function<InT, OutT> mapper, Function<OutT, InT> invMapper, Class<OutT> targetType) {
        return new MappedCollection<InT, OutT>(collection, mapper, invMapper, targetType);
    }

    public static <InT, OutT> Set<OutT> map(Set<InT> set, Function<InT, OutT> mapper, Function<OutT, InT> invMapper, Class<OutT> targetType) {
        return (Set)theUtil.map(set, mapper, invMapper, targetType);
    }

    public static <InT, OutT> List<OutT> map(List<InT> coll, Function<InT, OutT> mapper) {
        return new MappedList<InT, OutT>(coll, mapper);
    }

    public static <InT, OutT> List<OutT> map(List<InT> set, Function<InT, OutT> mapper, Function<OutT, InT> invMapper, Class<OutT> targetType) {
        return new MappedList<InT, OutT>(set, mapper, invMapper, targetType);
    }

    public static <InT, OutT> Collection<OutT> transform(Collection<InT> collection, Function<InT, OutT> transformer, Function<OutT, InT> invTransformer, Class<OutT> transformedType) {
        return theUtil.map(collection, transformer, invTransformer, transformedType);
    }

    public static <InT, OutT> Set<OutT> transform(Set<InT> set, Function<InT, OutT> transformer, Function<OutT, InT> invTransformer, Class<OutT> transformedType) {
        return theUtil.map(set, transformer, invTransformer, transformedType);
    }

    public static <InT, OutT> Set<OutT> transform(Set<InT> coll, Function<InT, OutT> transformer) {
        return theUtil.map(coll, transformer);
    }

    public static <InT, OutT> Collection<OutT> transform(Collection<InT> coll, Function<InT, OutT> transformer) {
        return theUtil.map(coll, transformer);
    }

    public static <T> Stream<T> iteratorToFiniteStream(Iterator<T> iterator) {
        Iterable iterable = () -> iterator;
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> Stream<T> iteratorToFiniteStream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> Stream<T> iteratorToInfiniteStream(Iterator<T> iterator) {
        return Stream.generate(iterator::next);
    }

    public static <T> Iterator<T> iterate(final T obj, final int count) {
        return new Iterator<T>(){
            private int ix = 0;

            @Override
            public boolean hasNext() {
                return this.ix < count;
            }

            @Override
            public T next() {
                ++this.ix;
                return obj;
            }
        };
    }

    public static <T> Iterator<T> infiniteIterator(final T obj) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public T next() {
                return obj;
            }
        };
    }

    public static <T> Iterator<T> iterator(T[] objs) {
        return theUtil.iterator(objs, 0, objs.length);
    }

    public static <T> Iterator<T> iterator(final T[] objs, final int start, int count) {
        final int end = start + count;
        assert (end <= objs.length);
        return new Iterator<T>(){
            private int d_ix;
            {
                this.d_ix = start;
            }

            @Override
            public boolean hasNext() {
                return this.d_ix < end;
            }

            @Override
            public T next() {
                Object next = objs[this.d_ix];
                ++this.d_ix;
                return next;
            }
        };
    }

    public static int[] sequentialList(int begin, int count) {
        int end = begin + count;
        int[] arr = new int[count];
        int m = begin;
        int ix = 0;
        while (m < end) {
            arr[ix] = m++;
            ++ix;
        }
        return arr;
    }

    public static <T> void copyInto(T[] dest, T[] source, int sourceOffset, int destOffset, int length) throws IndexOutOfBoundsException {
        if (length <= 0) {
            return;
        }
        for (int m = 0; m < length; ++m) {
            dest[m + destOffset] = source[m + sourceOffset];
        }
    }

    public static <ElemT> ElemT[] lazyTransform(ElemT[] elements, Class<ElemT> type, UnaryOperator<ElemT> xform) {
        Object[] newElements = null;
        for (int m = 0; m < elements.length; ++m) {
            ElemT elem = elements[m];
            Object newElem = xform.apply(elem);
            if (newElements == null) {
                if (elem == newElem) continue;
                newElements = (Object[])Array.newInstance(type, elements.length);
                theUtil.copyInto(newElements, elements, 0, 0, m);
            }
            newElements[m] = newElem;
        }
        return newElements == null ? elements : newElements;
    }

    public static boolean isSequential(int[] arr, int offset, int length) {
        return theUtil.getSequentialCount(arr, offset, length) == length;
    }

    public static int getSequentialCount(int[] arr, int offset, int length) {
        if (length < 2) {
            return length;
        }
        int end = offset + length;
        int prev = arr[offset];
        for (int m = offset + 1; m < end; ++m) {
            int curr = arr[m];
            if (curr != prev + 1) {
                return m - offset;
            }
            prev = curr;
        }
        return length;
    }

    public static <T> int getMatchCount(Collection<T> objs, Predicate<T> predicate) {
        int count = 0;
        for (T obj : objs) {
            if (!predicate.test(obj)) {
                return count;
            }
            ++count;
        }
        return count;
    }

    public static <T> boolean isUniform(T[] arr) {
        return theUtil.isUniform(arr, Objects::equals);
    }

    public static <T> boolean isUniform(T[] arr, BiPredicate<T, T> equals) {
        return theUtil.getUniformCount(arr, 0, arr.length, equals) == arr.length;
    }

    public static <T> int getUniformCount(T[] arr, int offset, int length, BiPredicate<T, T> equals) {
        if (length <= 1) {
            return length;
        }
        T first = arr[0];
        int end = offset + length;
        for (int m = offset; m < end; ++m) {
            if (equals.test(first, arr[m])) continue;
            return m - offset;
        }
        return length;
    }

    public static <T> int getUniformCount(Collection<T> values) {
        return theUtil.getUniformCount(values, Objects::equals);
    }

    public static <T> int getUniformCount(Collection<T> values, BiPredicate<T, T> equals) {
        if (values.isEmpty()) {
            return 0;
        }
        Iterator<T> it = values.iterator();
        T first = it.next();
        int ucount = 1;
        while (it.hasNext()) {
            T next = it.next();
            if (!Objects.equals(first, next)) {
                return ucount;
            }
            ++ucount;
        }
        assert (ucount == values.size());
        return ucount;
    }

    public static <T> boolean isUniform(Collection<? extends T> items) {
        return theUtil.isUniform(items, Objects::equals);
    }

    public static <T> boolean isUniform(Collection<? extends T> items, BiPredicate<T, T> equals) {
        if (items.isEmpty()) {
            return true;
        }
        Iterator<T> it = items.iterator();
        T first = it.next();
        while (it.hasNext()) {
            if (equals.test(first, it.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean isUniform(double ... items) {
        return theUtil.isUniform(items, (double v1, double v2) -> v1 == v2);
    }

    public static boolean isUniform(double[] items, BiDoublePredicate equals) {
        if (items.length == 0) {
            return true;
        }
        double first = items[0];
        for (int m = 1; m < items.length; ++m) {
            if (equals.test(first, items[m])) continue;
            return false;
        }
        return true;
    }

    public static boolean isUniform(int ... items) {
        return theUtil.isUniform(items, (int v1, int v2) -> v1 == v2);
    }

    public static boolean isUniform(int[] items, BiIntPredicate equals) {
        if (items.length == 0) {
            return true;
        }
        int first = items[0];
        for (int m = 1; m < items.length; ++m) {
            if (equals.test(first, items[m])) continue;
            return false;
        }
        return true;
    }

    public static <T> Supplier<T> cached(Supplier<T> supplier) {
        return new CachedSupplier<T>(supplier);
    }

    public static <T> void reverse(T[] arr) {
        int size = arr.length;
        int i = 0;
        int mid = size >> 1;
        int j = size - 1;
        while (i < mid) {
            T temp = arr[i];
            arr[i] = arr[j];
            arr[j] = temp;
            ++i;
            --j;
        }
    }

    public static <ItemT, TraitT> void groupSequentialMatches(List<ItemT> items, Function<ItemT, TraitT> getTraits, TriConsumer<List<ItemT>, Integer, TraitT> processor) {
        int ucount;
        for (int m = 0; m < items.size(); m += ucount) {
            ucount = theUtil.getUniformCount(theUtil.map(items.subList(m, items.size()), getTraits));
            TraitT trait = getTraits.apply(items.get(m));
            processor.accept(items.subList(m, m + ucount), m, trait);
        }
    }

    public static void sort(int[] arr, IntComparator comparator) {
        int[] result = Arrays.stream(arr).boxed().sorted((i1, i2) -> comparator.compare((int)i1, (int)i2)).mapToInt(i -> i).toArray();
        System.arraycopy(result, 0, arr, 0, arr.length);
    }

    public static void parallelSetAll(float[] array, IntToFloatFunction generator) {
        Objects.requireNonNull(generator);
        IntStream.range(0, array.length).parallel().forEach(i -> {
            fArray[i] = generator.applyAsFloat(i);
        });
    }

    public static float parallelGetMin(float[] array, float defVal) {
        return (float)IntStream.range(0, array.length).parallel().mapToDouble(i -> array[i]).min().orElse(defVal);
    }

    public static float parallelGetMax(float[] array, float defVal) {
        return (float)IntStream.range(0, array.length).parallel().mapToDouble(i -> array[i]).min().orElse(defVal);
    }

    public static void main(String[] args) {
        int count = 400000000;
        float[] data = new float[count];
        Random r = new Random(0L);
        for (int m = 0; m < count; ++m) {
            data[m] = r.nextFloat();
        }
        theTimer timer = new theTimer();
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (int m = 0; m < data.length; ++m) {
            float d = data[m];
            if (d < min) {
                min = d;
            }
            if (!(d > max)) continue;
            max = d;
        }
        System.out.println(timer.curr());
    }

    public static boolean startsWithIgnoreCase(String s1, String s) {
        if (s1.length() < s.length()) {
            return false;
        }
        for (int m = 0; m < s.length(); ++m) {
            if (Character.toLowerCase(s1.charAt(m)) == Character.toLowerCase(s.charAt(m))) continue;
            return false;
        }
        return true;
    }

    public static boolean setsEqual(Collection<?> s1, Collection<?> s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        if (s1 instanceof Set && s2 instanceof Set) {
            return s1.equals(s2);
        }
        if (s1.size() != s2.size()) {
            return false;
        }
        for (Object o1 : s1) {
            if (s2.contains(o1)) continue;
            return false;
        }
        return true;
    }

    public static void reverse(List<?> list, int begin, int end) {
        int size = end - begin;
        if (size < 18 || list instanceof RandomAccess) {
            int i = begin;
            int mid = size >> 1;
            int j = size - 1;
            while (i < mid) {
                Collections.swap(list, i, j);
                ++i;
                --j;
            }
        } else {
            ListIterator<?> fwd = list.listIterator(begin);
            ListIterator<?> rev = list.listIterator(end);
            int mid = list.size() >> 1;
            for (int i = 0; i < mid; ++i) {
                Object tmp = fwd.next();
                fwd.set(rev.previous());
                rev.set(tmp);
            }
        }
    }

    public static <T> ReversedList<T> reverse(List<T> l) {
        return new ReversedList<T>(l);
    }

    public static boolean testAll(int options, int opt) {
        return (options & opt) == opt;
    }

    public static boolean testAny(int options, int opt) {
        return (options & opt) != 0;
    }

    public static <E extends Enum<E>> EnumSet<E> toSet(Class<E> type, E ... vals) {
        switch (vals.length) {
            case 0: {
                return EnumSet.noneOf(type);
            }
            case 1: {
                return EnumSet.of(vals[0]);
            }
            case 2: {
                return EnumSet.of(vals[0], vals[1]);
            }
            case 3: {
                return EnumSet.of(vals[0], vals[1], vals[2]);
            }
            case 4: {
                return EnumSet.of(vals[0], vals[1], vals[2], vals[3]);
            }
            case 5: {
                return EnumSet.of(vals[0], vals[1], vals[2], vals[3], vals[4]);
            }
        }
        return EnumSet.of(vals[0], (Enum[])Arrays.copyOfRange(vals, 1, vals.length));
    }

    public static interface DoubleComparator {
        public int compare(double var1, double var3);
    }
}

