/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util.stat;

import java.util.Map;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.InfiniteUrn;
import thunderheadeng.util.stat.Urn;
import thunderheadeng.util.theUtil;

public class UrnUtil {
    public static <T> IUrn<T> newUrn(Map<T, Double> weightedValues) {
        double weight = Double.NaN;
        for (Map.Entry<T, Double> entry : weightedValues.entrySet()) {
            if (Double.isNaN(weight)) {
                weight = entry.getValue();
                continue;
            }
            if (theUtil.eq(weight, entry.getValue(), 1.0E-6)) continue;
            return new InfiniteUrn<T>(weightedValues);
        }
        return new Urn<T>(weightedValues.keySet());
    }

    public static <T> Urn<T> makeFinite(IUrn<T> urn, int ballCount) {
        if (urn instanceof Urn) {
            Urn burn = (Urn)urn;
            if (burn.getValues().size() == ballCount) {
                return burn;
            }
        } else if (urn instanceof InfiniteUrn) {
            return ((InfiniteUrn)urn).distribute(ballCount);
        }
        Map<T, Double> weights = urn.getWeights();
        return new InfiniteUrn<T>(weights).distribute(ballCount);
    }

    public static <T> InfiniteUrn<T> makeInfinite(IUrn<T> urn) {
        if (urn instanceof InfiniteUrn) {
            return (InfiniteUrn)urn;
        }
        return new InfiniteUrn<T>(urn.getWeights());
    }

    public static <T> T getDominant(IUrn<T> urn) {
        double maxWeight = 0.0;
        T maxValue = null;
        for (Map.Entry<T, Double> entry : urn.getWeights().entrySet()) {
            if (!(entry.getValue() > maxWeight)) continue;
            maxWeight = entry.getValue();
            maxValue = entry.getKey();
        }
        return maxValue;
    }
}

