/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util.stat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.IUrnSampler;

public class Urn<T>
implements Serializable,
IUrn<T> {
    private static final long serialVersionUID = -2045357536456688958L;
    private List<T> d_values;

    public Urn(T ... values) {
        this((Collection<T>)Arrays.asList(values));
    }

    public Urn(Collection<? extends T> values) {
        this.d_values = values != null && values.size() > 0 ? new ArrayList<T>(values) : Collections.EMPTY_LIST;
    }

    @Override
    public void getUnique(Collection<? super T> unique) {
        unique.addAll(this.d_values);
    }

    @Override
    public Map<T, Double> getWeights() {
        LinkedIdentityHashMap<T, Double> map = new LinkedIdentityHashMap<T, Double>();
        for (T t : this.d_values) {
            Double count = (Double)map.get(t);
            if (count == null) {
                map.put(t, 1.0);
                continue;
            }
            map.put(t, count + 1.0);
        }
        for (Map.Entry entry : map.entrySet()) {
            entry.setValue((Double)entry.getValue() / (double)this.d_values.size());
        }
        return map;
    }

    public Map<T, Integer> getCounts() {
        LinkedIdentityHashMap<T, Integer> countMap = new LinkedIdentityHashMap<T, Integer>();
        for (T val : this.d_values) {
            Integer count = (Integer)countMap.get(val);
            if (count == null) {
                countMap.put(val, 1);
                continue;
            }
            countMap.put(val, count + 1);
        }
        return countMap;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Urn && ((Urn)obj).d_values.equals(this.d_values);
    }

    public int hashCode() {
        return 0x95FA3 ^ this.d_values.hashCode();
    }

    public List<T> getValues() {
        return this.d_values;
    }

    @Override
    public T getValue(Random rand) {
        if (this.d_values.size() == 0) {
            return null;
        }
        int i = rand.nextInt(this.d_values.size());
        return this.d_values.get(i);
    }

    public Urn<T> shuffleRandomly(Random r) {
        Urn<T> newUrn = new Urn<T>(this.d_values);
        Collections.shuffle(newUrn.d_values, r);
        return newUrn;
    }

    @Override
    public IUrnSampler<T> getSampler(Random r) {
        int samplingIndex = r.nextInt(this.d_values.size());
        return new Sampler(this, samplingIndex);
    }

    public String toString() {
        return Arrays.toString(this.d_values.toArray());
    }

    private static class Sampler<T>
    implements IUrnSampler<T> {
        private final Urn<T> d_urn;
        private int d_samplingIndex;

        public Sampler(Urn<T> urn, int samplingIndex) {
            this.d_urn = urn;
            this.d_samplingIndex = samplingIndex;
        }

        @Override
        public T getCurrentSample() {
            return (T)((Urn)this.d_urn).d_values.get(this.d_samplingIndex);
        }

        @Override
        public T sampleNext() {
            T curr = this.getCurrentSample();
            this.d_samplingIndex = (this.d_samplingIndex + 1) % ((Urn)this.d_urn).d_values.size();
            return curr;
        }
    }
}

