/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util.stat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.IUrnSampler;
import thunderheadeng.util.stat.Urn;
import thunderheadeng.util.theUtil;

public class InfiniteUrn<T>
implements IUrn<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Entry<T>[] d_ballWeights;

    public InfiniteUrn(Map<T, Double> ballWeights) {
        assert (theUtil.eq(InfiniteUrn.sumWeights(ballWeights.values()), 1.0, 1.0E-6));
        this.d_ballWeights = new Entry[ballWeights.size()];
        int ix = 0;
        double f = 0.0;
        for (Map.Entry<T, Double> mentry : ballWeights.entrySet()) {
            this.d_ballWeights[ix++] = new Entry<T>(f, mentry.getKey());
            f += mentry.getValue().doubleValue();
        }
    }

    public InfiniteUrn(Object ... vals) {
        this(InfiniteUrn.toWeights(vals));
    }

    private static <T> Map<T, Double> toWeights(Object ... vals) {
        assert (vals.length % 2 == 0);
        LinkedIdentityHashMap<Object, Double> map = new LinkedIdentityHashMap<Object, Double>();
        for (int m = 0; m < vals.length; m += 2) {
            map.put(vals[m], (Double)vals[m + 1]);
        }
        return map;
    }

    public int hashCode() {
        return 0x5987FA ^ this.getWeights().hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof InfiniteUrn && ((InfiniteUrn)obj).getWeights().equals(this.getWeights());
    }

    public Urn<T> distribute(int ballCount) {
        Map<T, Double> distribution = this.getWeights();
        ArrayList<Map.Entry<T, Double>> sortedDist = new ArrayList<Map.Entry<T, Double>>(distribution.entrySet());
        Collections.sort(sortedDist, new Comparator<Map.Entry<T, Double>>(){

            @Override
            public int compare(Map.Entry<T, Double> o1, Map.Entry<T, Double> o2) {
                return Double.compare(o2.getValue(), o1.getValue());
            }
        });
        ArrayList list = new ArrayList(ballCount);
        int remaining = ballCount;
        for (Map.Entry entry : sortedDist) {
            int count = (int)Math.round((Double)entry.getValue() * (double)ballCount);
            if (count > remaining) {
                count = remaining;
            } else if (count == 0) {
                count = 1;
            }
            for (int m = 0; m < count; ++m) {
                list.add(entry.getKey());
            }
            if ((remaining -= count) > 0) continue;
            break;
        }
        while (remaining > 0) {
            list.add(((Map.Entry)sortedDist.get(0)).getKey());
            --remaining;
        }
        assert (list.size() == ballCount);
        return new Urn(list);
    }

    private static double sumWeights(Collection<Double> weights) {
        double sum = 0.0;
        for (Double val : weights) {
            assert (val >= 0.0);
            sum += val.doubleValue();
        }
        return sum;
    }

    @Override
    public void getUnique(Collection<? super T> unique) {
        for (Entry<T> entry : this.d_ballWeights) {
            unique.add(entry.val);
        }
    }

    @Override
    public Map<T, Double> getWeights() {
        LinkedIdentityHashMap map = new LinkedIdentityHashMap();
        for (int m = 0; m < this.d_ballWeights.length; ++m) {
            Entry<T> entry = this.d_ballWeights[m];
            double nextF = m < this.d_ballWeights.length - 1 ? this.d_ballWeights[m + 1].f : 1.0;
            double weight = nextF - entry.f;
            map.put(entry.val, weight);
        }
        return map;
    }

    @Override
    public T getValue(Random rand) {
        double v = rand.nextDouble();
        int ix = Arrays.binarySearch(this.d_ballWeights, (Object)v);
        if (ix < 0 && (ix = -ix - 2) < 0) {
            ix = 0;
        }
        return this.d_ballWeights[ix].val;
    }

    @Override
    public IUrnSampler<T> getSampler(Random r) {
        return new Sampler<T>(this.getWeights(), r);
    }

    public String toString() {
        return this.getWeights().toString();
    }

    public static class Sampler<T>
    implements IUrnSampler<T> {
        private final Object[] d_balls;
        private final double[] d_desiredCounts;
        private final int[] d_counts;
        private int d_iteration;
        private int d_samplingIndex;
        private T d_currBall;
        private double[] d_roundingErrors;
        private double[] d_ratios;

        public Sampler(Map<T, Double> weights, Random r) {
            ArrayList<Map.Entry<T, Double>> sortedWeights = new ArrayList<Map.Entry<T, Double>>(weights.entrySet());
            Collections.sort(sortedWeights, new Comparator<Map.Entry<T, Double>>(){

                @Override
                public int compare(Map.Entry<T, Double> o1, Map.Entry<T, Double> o2) {
                    return o2.getValue().compareTo(o1.getValue());
                }
            });
            double minWeight = !sortedWeights.isEmpty() ? (Double)((Map.Entry)sortedWeights.get(sortedWeights.size() - 1)).getValue() : Double.POSITIVE_INFINITY;
            this.d_balls = new Object[sortedWeights.size()];
            this.d_desiredCounts = new double[sortedWeights.size()];
            this.d_roundingErrors = new double[sortedWeights.size() - 1];
            this.d_ratios = new double[sortedWeights.size() - 1];
            for (int m = 0; m < sortedWeights.size(); ++m) {
                Map.Entry entry = (Map.Entry)sortedWeights.get(m);
                this.d_balls[m] = entry.getKey();
                this.d_desiredCounts[m] = (Double)entry.getValue() / minWeight;
                if (m <= 0) continue;
                this.d_ratios[m - 1] = this.d_desiredCounts[m - 1] / this.d_desiredCounts[m];
            }
            this.d_counts = new int[sortedWeights.size()];
            Arrays.fill(this.d_counts, 0);
            this.sampleNext();
        }

        @Override
        public T getCurrentSample() {
            return this.d_currBall;
        }

        @Override
        public T sampleNext() {
            T curr = this.d_currBall;
            while (true) {
                int desiredCount;
                int currCount = this.d_counts[this.d_samplingIndex];
                int n = desiredCount = this.d_samplingIndex < this.d_ratios.length ? (int)Math.round(this.d_ratios[this.d_samplingIndex]) : 1;
                if (currCount == 0 && this.d_samplingIndex < this.d_roundingErrors.length) {
                    int n2 = this.d_samplingIndex;
                    this.d_roundingErrors[n2] = this.d_roundingErrors[n2] + (this.d_ratios[this.d_samplingIndex] - (double)desiredCount);
                }
                int roundingError = 0;
                if (this.d_samplingIndex < this.d_roundingErrors.length) {
                    int n3 = roundingError = theUtil.gt0(this.d_roundingErrors[this.d_samplingIndex], 0.0) ? (int)Math.floor(this.d_roundingErrors[this.d_samplingIndex]) : (int)Math.ceil(this.d_roundingErrors[this.d_samplingIndex]);
                }
                if (currCount < (desiredCount += roundingError)) {
                    this.d_currBall = this.d_balls[this.d_samplingIndex];
                    int n4 = this.d_samplingIndex;
                    this.d_counts[n4] = this.d_counts[n4] + 1;
                    if (currCount + 1 >= desiredCount) break;
                    for (int i = 0; i < this.d_samplingIndex; ++i) {
                        this.d_counts[i] = 0;
                    }
                    this.d_samplingIndex = 0;
                    break;
                }
                if (currCount == desiredCount && this.d_samplingIndex < this.d_roundingErrors.length) {
                    int n5 = this.d_samplingIndex;
                    this.d_roundingErrors[n5] = this.d_roundingErrors[n5] - (double)roundingError;
                }
                if (this.d_samplingIndex < this.d_balls.length - 1) {
                    ++this.d_samplingIndex;
                    continue;
                }
                Arrays.fill(this.d_counts, 0);
                this.d_samplingIndex = 0;
            }
            return curr;
        }
    }

    private static class Entry<T>
    implements Comparable<Double>,
    Serializable {
        private static final long serialVersionUID = 1L;
        public final double f;
        public final T val;

        public Entry(double f, T val) {
            this.f = f;
            this.val = val;
        }

        @Override
        public int compareTo(Double v) {
            return Double.compare(this.f, v);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Entry && Objects.equals(((Entry)obj).val, this.val) && ((Entry)obj).f == this.f;
        }

        public int hashCode() {
            return 0x34AF938 ^ Double.hashCode(this.f) + Objects.hashCode(this.val);
        }
    }
}

