/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util.mtproc;

import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import thunderheadeng.util.mtproc.MTListProcessorPool;
import thunderheadeng.util.mtproc.MTListProcessorThread;

public class MTProcessor {
    private final int d_numThreads;
    private final CyclicBarrier d_endLock;
    private final AtomicInteger d_ix;
    private final Object d_guidedLock;
    private Schedule d_defSchedule;
    private Schedule d_schedule;
    private int d_guidedOffset;
    private final MTListProcessorPool d_mtlpPool;

    public MTProcessor(int maxNumThreads, Schedule defSchedule, MTListProcessorPool mtlpPool) {
        this.d_endLock = new CyclicBarrier(maxNumThreads);
        this.d_numThreads = maxNumThreads;
        this.d_guidedLock = new Object();
        this.d_ix = new AtomicInteger();
        this.d_defSchedule = defSchedule;
        this.d_mtlpPool = mtlpPool;
    }

    public int getNumThreads() {
        return this.d_numThreads;
    }

    public Schedule getDefaultSchedule() {
        return this.d_defSchedule;
    }

    public <T> void process(List<T> items, IProc<T> proc) throws ExecutionException {
        this.process(items, proc, this.d_defSchedule);
    }

    public <T> void process(List<? extends T> items, IProc<T> proc, Schedule schedule) throws ExecutionException {
        this.d_ix.set(0);
        this.d_guidedOffset = 0;
        this.d_schedule = schedule;
        List<MTListProcessorThread> threads = this.d_mtlpPool.getThreads(this.d_numThreads - 1);
        Runner<T> runner = new Runner<T>(this, items, proc);
        for (int m = 0; m < this.d_numThreads - 1; ++m) {
            MTListProcessorThread mtlpThread = threads.get(m);
            mtlpThread.run(runner);
        }
        runner.run(this.d_numThreads - 1);
        if (((Runner)runner).d_caughtException != null) {
            throw new ExecutionException(((Runner)runner).d_caughtException);
        }
    }

    protected int[] getNextProcParams(int threadNum) {
        switch (this.d_schedule) {
            case DYNAMIC: {
                return new int[]{this.d_ix.getAndIncrement(), 1};
            }
        }
        return null;
    }

    public static interface IProc<T> {
        public void process(T var1, int var2, int var3);
    }

    protected static class Runner<T>
    implements MTListProcessorThread.IRunner {
        private final MTProcessor d_processor;
        private final List<? extends T> d_list;
        private final IProc<T> d_currProc;
        private Throwable d_caughtException = null;

        public Runner(MTProcessor processor, List<? extends T> list, IProc<T> currProc) {
            this.d_processor = processor;
            this.d_list = list;
            this.d_currProc = currProc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(int threadId) {
            try {
                this.process(threadId);
            }
            catch (Throwable t) {
                Runner runner = this;
                synchronized (runner) {
                    if (this.d_caughtException == null) {
                        this.d_caughtException = t;
                    }
                }
            }
            try {
                this.d_processor.d_endLock.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (BrokenBarrierException brokenBarrierException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void process(int threadNum) {
            List<T> buffer = this.d_list;
            int listSize = this.d_list.size();
            int numThreads = this.d_processor.getNumThreads();
            AtomicInteger d_ix = this.d_processor.d_ix;
            Object d_guidedLock = this.d_processor.d_guidedLock;
            block2 : switch (this.d_processor.d_schedule) {
                case DYNAMIC: {
                    int ix;
                    while ((ix = d_ix.getAndIncrement()) < listSize) {
                        this.d_currProc.process(buffer.get(ix), threadNum, ix);
                    }
                    break;
                }
                case STATIC: {
                    int count = listSize / numThreads;
                    int remaining = listSize % numThreads;
                    if (threadNum < remaining) {
                        ++count;
                    }
                    int offset = count * threadNum;
                    if (threadNum >= remaining) {
                        offset += remaining;
                    }
                    int end = offset + count;
                    for (int m = offset; m < end; ++m) {
                        this.d_currProc.process(buffer.get(m), threadNum, m);
                    }
                    break;
                }
                case GUIDED: {
                    block10: while (true) {
                        int count;
                        int remaining;
                        int offset;
                        Object end = d_guidedLock;
                        synchronized (end) {
                            offset = this.d_processor.d_guidedOffset;
                            remaining = listSize - offset;
                            count = (int)Math.ceil((double)remaining / (double)numThreads);
                            assert (remaining == 0 || count <= remaining);
                            MTProcessor m = this.d_processor;
                            m.d_guidedOffset = m.d_guidedOffset + count;
                        }
                        if (remaining == 0) break block2;
                        int end2 = offset + count;
                        int m = offset;
                        while (true) {
                            if (m >= end2) continue block10;
                            this.d_currProc.process(buffer.get(m), threadNum, m);
                            ++m;
                        }
                        break;
                    }
                }
            }
        }
    }

    public static enum Schedule {
        DYNAMIC,
        GUIDED,
        STATIC;

    }
}

