/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLLabel;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.io.UrlDataLoader;
import thunderheadeng.license3.LicenseManager;

public class VersionUtil {
    private static CheckForUpdatesPnl buildFailedStatusPanel() {
        CheckForUpdatesPnl panel = new CheckForUpdatesPnl();
        panel.setConnectionStatus(false);
        panel.setLayout(new GridBagLayout());
        GridBagHelper gbh = new GridBagHelper(panel);
        guiLabel errorMsg = new guiLabel(Intl.intl("Unable to connect to server."));
        gbh.addRow(errorMsg);
        gbh.finalizeRows();
        return panel;
    }

    public static CheckForUpdatesPnl buildPanel(LicenseManager lm, String versionCurrent, IVersionSource versionSrc) {
        Supplier<String> lmVerSupp = () -> lm.getLicenseVersion();
        return VersionUtil.buildPanel(lmVerSupp, versionCurrent, versionSrc);
    }

    public static CheckForUpdatesPnl buildPanel(Supplier<String> lmVerSupplier, String versionCurrent, IVersionSource versionSrc) {
        List<RevisionDesc> prodVersion = versionSrc.getRevisions();
        if (prodVersion == null) {
            return VersionUtil.buildFailedStatusPanel();
        }
        RevisionDesc supportedMaint = new RevisionDesc(lmVerSupplier.get() + "99", null, null);
        Collections.sort(prodVersion, RevisionDesc.getComparator());
        RevisionDesc[] sortedVersions = new RevisionDesc[prodVersion.size()];
        prodVersion.toArray(sortedVersions);
        int maintIx = Arrays.binarySearch(sortedVersions, supportedMaint, RevisionDesc.getComparator());
        int instIx = Arrays.binarySearch(sortedVersions, new RevisionDesc(versionCurrent, null, null), RevisionDesc.getComparator());
        int newestIx = 0;
        int maintIxFixed = maintIx;
        int instIxFixed = instIx;
        if (maintIx < 0) {
            maintIxFixed = -1 * (maintIx + 1);
        }
        if (instIx < 0) {
            instIxFixed = -1 * (instIxFixed + 1);
        }
        CheckForUpdatesPnl panel = new CheckForUpdatesPnl();
        panel.setLayout(new GridBagLayout());
        GridBagHelper gbh = new GridBagHelper(panel);
        if (instIxFixed == 0) {
            guiLabel lbl = new guiLabel(String.format(Intl.intl("You are using the latest version of %s."), versionSrc.getProductName()));
            gbh.addRow(lbl);
            guiLabel versionLabel = new guiLabel(String.format(Intl.intl("Current Version: %s"), versionCurrent));
            gbh.addRow(versionLabel);
            panel.setUpToDate(true);
        } else if (instIxFixed <= maintIxFixed && RevisionDesc.getComparator().compare(new RevisionDesc(versionCurrent, null, null), supportedMaint) > 0) {
            guiLabel pitch = new guiLabel(Intl.intl("You are using the latest version supported by your license."));
            guiLabel newLbl = new guiLabel(Intl.intl("A newer version is available:"));
            String tempLbl = String.format("<a href=%s>%s</a> - <i>%s</i>", prodVersion.get((int)newestIx).address, prodVersion.get((int)newestIx).name, prodVersion.get(newestIx).getReleaseDate());
            HTMLLabel maint = new HTMLLabel(tempLbl);
            gbh.addRow(pitch);
            gbh.addRow(newLbl);
            gbh.addIdentRow(maint);
            guiLabel versionLabel = new guiLabel(String.format(Intl.intl("Current Version: %s"), versionCurrent));
            gbh.addRow(versionLabel);
        } else if (instIxFixed > 0 && instIxFixed > maintIxFixed && maintIxFixed == newestIx) {
            guiLabel free = new guiLabel(Intl.intl("You are not using the latest version supported by your license."));
            guiLabel newLbl = new guiLabel(Intl.intl("A free upgrade is available:"));
            String tempLbl = String.format("<a href=%s>%s</a> - <i>%s</i>", prodVersion.get((int)maintIxFixed).address, prodVersion.get((int)maintIxFixed).name, prodVersion.get(maintIxFixed).getReleaseDate());
            HTMLLabel maint = new HTMLLabel(tempLbl);
            gbh.addRow(free);
            gbh.addRow(newLbl);
            gbh.addIdentRow(maint);
            guiLabel versionLabel = new guiLabel(String.format(Intl.intl("Current Version: %s"), versionCurrent));
            gbh.addRow(versionLabel);
        } else {
            guiLabel free = new guiLabel(Intl.intl("You are not using the latest version supported by your license."));
            guiLabel newLbl = new guiLabel(Intl.intl("A free upgrade is available:"));
            String tempLbl = String.format("<a href=%s>%s</a> - <i>%s</i>", prodVersion.get((int)maintIxFixed).address, prodVersion.get((int)maintIxFixed).name, prodVersion.get(maintIxFixed).getReleaseDate());
            HTMLLabel maint = new HTMLLabel(tempLbl);
            guiLabel pay = new guiLabel(Intl.intl("A newer version is available:"));
            String tempLblLatest = String.format("<a href=%s>%s</a> - <i>%s</i>", prodVersion.get((int)newestIx).address, prodVersion.get((int)newestIx).name, prodVersion.get(newestIx).getReleaseDate());
            HTMLLabel latest = new HTMLLabel(tempLblLatest);
            gbh.addRow(free);
            gbh.addRow(newLbl);
            gbh.addIdentRow(maint);
            gbh.addRowSpace(0);
            gbh.addRow(pay);
            gbh.addIdentRow(latest);
            guiLabel versionLabel = new guiLabel(String.format(Intl.intl("Current Version: %s"), versionCurrent));
            gbh.addRow(versionLabel);
        }
        gbh.finalizeRows();
        return panel;
    }

    public static void main(String[] args) {
        MockCheckForUpdatesDlg dlg = new MockCheckForUpdatesDlg();
        if (dlg.doModal() == 1) {
            System.out.println("OK clicked");
        }
    }

    private static class MockCheckForUpdatesDlg
    extends ACheckForUpdatesDlg {
        public MockCheckForUpdatesDlg() {
            super((Window)null, "Check for Updates", false);
        }

        @Override
        protected void init(boolean isCheckOnStart) {
            this.d_updates = VersionUtil.buildPanel(() -> "2018.2.0110", "2018.1.1214", (IVersionSource)new LocalVersionSource("D:\\version.json", "MockProduct"));
            guiPanel c = this.getDialogPane();
            c.add(this.d_updates);
            this.pack();
        }
    }

    public static class URLVersionSource
    extends AVersionSource {
        private final String d_url;

        public URLVersionSource(String url, String product) {
            super(product);
            this.d_url = url;
        }

        @Override
        public List<RevisionDesc> getRevisions() {
            try {
                UrlDataLoader fromUrl = new UrlDataLoader(new URL(this.d_url), UrlDataLoader.BLIND_HOSTNAME_VERIFIER, UrlDataLoader.BLIND_TRUST_MANAGER);
                String versionJson = fromUrl.connectAndRead();
                return this.parseVersionFile(versionJson);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static class LocalVersionSource
    extends AVersionSource {
        private final String d_fileName;

        public LocalVersionSource(String fileName, String product) {
            super(product);
            this.d_fileName = fileName;
        }

        @Override
        public List<RevisionDesc> getRevisions() {
            try {
                byte[] testFileBytes = Files.readAllBytes(Paths.get(this.d_fileName, new String[0]));
                String testFileJson = new String(testFileBytes);
                return this.parseVersionFile(testFileJson);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private static abstract class AVersionSource
    implements IVersionSource {
        protected final String d_product;

        protected AVersionSource(String product) {
            this.d_product = product;
        }

        @Override
        public String getProductName() {
            return this.d_product;
        }

        protected List<RevisionDesc> parseVersionFile(String jsonStr) {
            try {
                JSONParser jsonParser = new JSONParser();
                JSONObject jsonObject = (JSONObject)jsonParser.parse(jsonStr);
                JSONArray projectArr = (JSONArray)jsonObject.get((Object)this.d_product.toLowerCase());
                ArrayList<RevisionDesc> projectVersions = new ArrayList<RevisionDesc>();
                for (JSONObject curJson : projectArr) {
                    projectVersions.add(new RevisionDesc((String)curJson.get((Object)"revision"), (String)curJson.get((Object)"address"), (String)curJson.get((Object)"date")));
                }
                return projectVersions;
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static interface IVersionSource {
        public List<RevisionDesc> getRevisions();

        public String getProductName();
    }

    private static class RevisionDesc {
        public final String name;
        public final String address;
        public final String readableDate;
        public final int year;
        public final int ordinal;
        public final int date;

        public RevisionDesc(String revisionName, String revisionAddress, String revDate) {
            this.name = revisionName;
            this.address = revisionAddress;
            this.readableDate = revDate;
            String[] parts = revisionName.split("\\.");
            if (parts.length == 3) {
                this.year = Integer.parseInt(parts[0]);
                this.ordinal = Integer.parseInt(parts[1]);
                this.date = Integer.parseInt(parts[2]);
            } else if (parts.length == 2) {
                this.year = Integer.parseInt(parts[0]);
                this.date = Integer.parseInt(parts[1]);
                this.ordinal = -1;
            } else {
                this.year = Integer.parseInt(parts[0]);
                this.ordinal = Integer.parseInt(parts[1]);
                this.date = Integer.parseInt(parts[2]);
            }
        }

        public String getReleaseDate() {
            return this.readableDate;
        }

        public static Comparator<RevisionDesc> getComparator() {
            return (rev1, rev2) -> {
                int comp = Integer.compare(rev2.year, rev1.year);
                if (comp != 0) {
                    return comp;
                }
                if (rev1.ordinal > 0 && rev2.ordinal > 0 && (comp = Integer.compare(rev2.ordinal, rev1.ordinal)) != 0) {
                    return comp;
                }
                comp = Integer.compare(rev2.date, rev1.date);
                return comp;
            };
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RevisionDesc)) {
                return false;
            }
            return this.name.equals(((RevisionDesc)obj).name);
        }
    }

    private static class CheckForUpdatesPnl
    extends guiPanel {
        private guiCheckBox d_checkOnStart = new guiCheckBox(Intl.intl("Check for newer version on startup"));
        private boolean d_isUpToDate;
        private boolean d_connectionStatus;

        public CheckForUpdatesPnl() {
            this.setUpToDate(false);
            this.setConnectionStatus(true);
        }

        public JComponent getCheckBoxComponent() {
            return this.d_checkOnStart;
        }

        public void setCheckOnStartStatus(boolean checkOnStartup) {
            this.d_checkOnStart.setSelected(checkOnStartup);
        }

        public void setUpToDate(boolean isUpToDate) {
            this.d_isUpToDate = isUpToDate;
        }

        public void setConnectionStatus(boolean isConnected) {
            this.d_connectionStatus = isConnected;
        }

        public boolean isUpToDate() {
            return this.d_isUpToDate;
        }

        public boolean isConnected() {
            return this.d_connectionStatus;
        }

        public boolean isCheckOnStart() {
            return this.d_checkOnStart.isSelected();
        }
    }

    public static abstract class ACheckForUpdatesDlg
    extends guiDialog {
        protected CheckForUpdatesPnl d_updates;
        protected guiCheckBox d_checkOnStartCB = new guiCheckBox(Intl.intl("Check for newer version on startup"));

        protected guiPanel getMainPnl() {
            return this.d_updates;
        }

        public ACheckForUpdatesDlg(Window owner, String title, boolean isCheckOnStart) {
            super(owner, title, 1);
            this.init(isCheckOnStart);
        }

        public boolean isUpToDate() {
            return this.d_updates.isUpToDate();
        }

        public boolean isConnected() {
            return this.d_updates.isConnected();
        }

        public boolean isCheckOnStart() {
            return this.d_checkOnStartCB.isSelected();
        }

        protected abstract void init(boolean var1);
    }
}

