/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.Collection;
import thunderheadeng.util.APredicate;

public class TypeFilter<T>
extends APredicate<T> {
    private final Class<?>[] d_types;

    public TypeFilter(Class<?> ... types) {
        this.d_types = types;
    }

    public TypeFilter(Collection<Class<? extends T>> types) {
        this.d_types = types.toArray(new Class[types.size()]);
    }

    @Override
    public boolean test(T t) {
        for (Class<?> type : this.d_types) {
            if (!type.isInstance(t)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        return obj instanceof TypeFilter && TypeFilter.compareAsSets(((TypeFilter)obj).d_types, this.d_types);
    }

    public int hashCode() {
        int hashCode = 0;
        for (Class<?> type : this.d_types) {
            hashCode += type.hashCode();
        }
        return 0x235234FE ^ hashCode;
    }

    private static <T> boolean compareAsSets(Class<? extends T>[] a1, Class<? extends T>[] a2) {
        if (a1.length != a2.length) {
            return false;
        }
        for (int m = 0; m < a1.length; ++m) {
            boolean found = false;
            Class<T> c1 = a1[m];
            for (int n = 0; n < a2.length; ++n) {
                if (!c1.equals(a2[n])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

