/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.TextProps;
import thunderheadeng.util.TypedProp;

public class TeciProps
extends Properties
implements IPropertySet {
    public TeciProps() {
    }

    public TeciProps(Properties parent) {
        super(parent);
    }

    public boolean partialEquals(Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            Object thisVal = this.get(entry.getKey());
            if (Objects.equals(thisVal, entry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> boolean isDefined(IPropertySet.Prop<T> prop) {
        return this.containsKey(prop.key);
    }

    protected <T> T get(String prop, T dval, Class<T> type) {
        return this.get(dval == null ? new TypedProp<T>((Object)prop, type) : new TypedProp<T>((Object)prop, dval));
    }

    @Override
    public <T> T get(IPropertySet.Prop<T> prop) {
        assert (prop instanceof TypedProp);
        return this.get((TypedProp)prop);
    }

    public <T> T get(TypedProp<T> prop) {
        return this.get(prop, TextProps.getParser(prop));
    }

    public <T> T get(IPropertySet.Prop<T> prop, TextProps.IParser<T> parser) {
        String sval = this.getProperty((String)prop.key);
        if (sval == null) {
            return prop.defVal;
        }
        if (parser == null) {
            return prop.defVal;
        }
        try {
            return parser.parse(sval);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return prop.defVal;
        }
    }

    public boolean getBoolean(String prop, boolean dval) {
        return this.get(prop, dval, Boolean.class);
    }

    public boolean getBoolean(IPropertySet.Prop<Boolean> prop) {
        return this.get(prop);
    }

    public int getInt(String prop, int dval) {
        return this.get(prop, dval, Integer.class);
    }

    public int getInt(IPropertySet.Prop<Integer> prop) {
        return this.get(prop);
    }

    public long getLong(String prop, long dval) {
        return this.get(prop, dval, Long.class);
    }

    public long getLong(IPropertySet.Prop<Long> prop) {
        return this.get(prop);
    }

    public float getFloat(String prop, float dval) {
        return this.get(prop, Float.valueOf(dval), Float.class).floatValue();
    }

    public float getFloat(IPropertySet.Prop<Float> prop) {
        return this.get(prop).floatValue();
    }

    public double getDouble(String prop, double dval) {
        return this.get(prop, dval, Double.class);
    }

    public double getDouble(IPropertySet.Prop<Double> prop) {
        return this.get(prop);
    }

    public String getString(String prop, String dval) {
        return this.get(prop, dval, String.class);
    }

    public String getString(IPropertySet.Prop<String> prop) {
        return this.get(prop);
    }

    public UnitDouble getUnitDouble(IPropertySet.Prop<UnitDouble> prop) {
        return this.get(prop);
    }

    public UnitDouble getUnitDouble(String key, UnitDouble defVal) {
        return this.get(key, defVal, UnitDouble.class);
    }

    @Override
    public <T> void set(IPropertySet.Prop<T> prop, T val) {
        if (prop instanceof TypedProp) {
            this.set((TypedProp)prop, val);
        } else {
            this.set(prop.key.toString(), val);
        }
    }

    public <T> void set(TypedProp<T> prop, T val) {
        this.set(prop, val, TextProps.getFormatter(prop));
    }

    public <T> void set(IPropertySet.Prop<T> prop, T val, Function<T, String> formatter) {
        String sval = formatter.apply(val);
        this.setProperty(prop.key.toString(), sval);
    }

    public void set(String prop, Object val) {
        this.setProperty(prop, val == null ? null : val.toString());
    }

    @Override
    public <T> void remove(IPropertySet.Prop<T> prop) {
        this.remove(prop.key);
    }

    public static class Prop {
    }
}

