/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import thunderheadeng.util.BiIntFunction;

public class TaskProgress {
    public static final int INDETERMINATE = -1;
    private final AtomicBoolean d_running = new AtomicBoolean(true);
    private int d_max = 100;
    private int d_current = -1;
    private String d_message = "";
    private BiIntFunction<String> d_messageGen;

    public synchronized boolean isIndeterminate() {
        return this.d_current == -1;
    }

    public synchronized void setIndeterminate(boolean status) {
        this.setProgress(status ? -1 : 0);
    }

    public synchronized int[] getProgress() {
        if (this.d_current == -1) {
            return null;
        }
        return new int[]{this.d_current, this.d_max};
    }

    public synchronized void setMax(int max) {
        this.d_max = max;
    }

    public synchronized void setProgress(int curr) {
        this.d_current = curr;
    }

    public synchronized void reset(int max) {
        this.reset(max, 0);
    }

    public synchronized void reset() {
        this.reset(100, -1);
    }

    private synchronized void reset(int max, int current) {
        this.d_running.set(true);
        this.d_current = current;
        this.d_max = max;
    }

    public synchronized String getMessage() {
        if (this.d_messageGen != null) {
            return this.d_messageGen.apply(this.d_current, this.d_max);
        }
        return this.d_message;
    }

    public synchronized void setMessage(String msg) {
        this.d_message = msg;
    }

    public synchronized void setMessageGenerator(BiIntFunction<String> msgGen) {
        this.d_messageGen = msgGen;
    }

    public void cancel() {
        this.d_running.set(false);
    }

    public boolean isRunning() {
        return this.d_running.get();
    }

    public void check() throws CancellationException {
        if (!this.isRunning()) {
            throw new CancellationException();
        }
    }
}

