/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.Observable;
import java.util.Stack;
import thunderheadeng.Intl;
import thunderheadeng.gui.Application;
import thunderheadeng.util.Task;

public class TaskManager
extends Observable {
    private final Stack<DescribedTask> d_undo = new Stack();
    private final Stack<DescribedTask> d_redo = new Stack();

    public String describeUndo() {
        return this.d_undo.isEmpty() || this.d_undo.peek().desc == null ? Intl.intl("Undo") : String.format(Intl.intl("Undo %s"), this.d_undo.peek().desc);
    }

    public String describeRedo() {
        return this.d_redo.isEmpty() || this.d_redo.peek().desc == null ? Intl.intl("Redo") : String.format(Intl.intl("Redo %s"), this.d_redo.peek().desc);
    }

    public void clearHistory() {
        this.d_undo.clear();
        this.d_redo.clear();
    }

    public void clearRedoHistory() {
        this.d_redo.clear();
    }

    public void clearUndoHistory() {
        this.d_undo.clear();
    }

    public void exec(Task tsk, String desc) {
        this.exec(new DescribedTask(tsk, desc), false);
    }

    private void exec(DescribedTask tsk, boolean isRedo) {
        if (!isRedo) {
            this.d_redo.clear();
        }
        if (tsk.task.canUndo()) {
            this.d_undo.push(tsk);
        } else {
            this.d_undo.clear();
        }
        this.run(tsk.task);
        this.setChanged();
        this.notifyObservers();
    }

    protected void run(Task task) {
        switch (task.getEst()) {
            case 0: {
                this.runShort(task);
                break;
            }
            case 1: {
                this.runMed(task);
                break;
            }
            case 2: {
                this.runLong(task);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void runShort(Task tsk) {
        tsk.run();
    }

    private void runMed(Task tsk) {
        Application.getApp().beginWaitCursor();
        tsk.run();
        Application.getApp().endWaitCursor();
    }

    private void runLong(Task tsk) {
        tsk.run();
    }

    private void undoShort(Task tsk) {
        tsk.undo();
    }

    private void undoMed(Task tsk) {
        Application.getApp().beginWaitCursor();
        tsk.undo();
        Application.getApp().endWaitCursor();
    }

    private void undoLong(Task tsk) {
        tsk.undo();
    }

    public boolean canUndo() {
        return !this.d_undo.empty();
    }

    public void undo() {
        assert (this.canUndo());
        DescribedTask tsk = this.d_undo.pop();
        assert (tsk.task.canUndo());
        this.d_redo.push(tsk);
        switch (tsk.task.getEst()) {
            case 0: {
                this.undoShort(tsk.task);
                break;
            }
            case 1: {
                this.undoMed(tsk.task);
                break;
            }
            case 2: {
                this.undoLong(tsk.task);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.setChanged();
        this.notifyObservers();
    }

    public boolean canRedo() {
        return !this.d_redo.empty();
    }

    public void redo() {
        assert (this.canRedo());
        DescribedTask tsk = this.d_redo.pop();
        this.exec(tsk, true);
    }

    private static class DescribedTask {
        public final Task task;
        public final String desc;

        public DescribedTask(Task t, String desc) {
            this.task = t;
            this.desc = desc;
        }
    }
}

