/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SoftHashMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, SoftValue> hash = new HashMap<K, SoftValue>();
    private final ReferenceQueue queue = new ReferenceQueue();

    @Override
    public V get(Object key) {
        V result = null;
        SoftReference soft_ref = this.hash.get(key);
        if (soft_ref != null && (result = (V)soft_ref.get()) == null) {
            this.hash.remove(key);
        }
        return result;
    }

    private void processQueue() {
        SoftValue sv;
        while ((sv = (SoftValue)this.queue.poll()) != null) {
            this.hash.remove(sv.key);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        this.hash.put(key, new SoftValue(value, key, this.queue));
        return value;
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        this.hash.remove(key);
        return null;
    }

    @Override
    public void clear() {
        this.processQueue();
        this.hash.clear();
    }

    @Override
    public int size() {
        this.processQueue();
        return this.hash.size();
    }

    @Override
    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    private static class SoftValue
    extends SoftReference {
        private final Object key;

        private SoftValue(Object k, Object key, ReferenceQueue q) {
            super(k, q);
            this.key = key;
        }
    }
}

