/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class SetMetrics
implements Serializable,
Cloneable {
    public static final long serialVersionUID = 1L;
    private final Hashtable<Class, Set<Object>> d_hash = new Hashtable();
    private final boolean d_identityHashes;

    public SetMetrics() {
        this(Collections.EMPTY_SET);
    }

    public SetMetrics(Collection s) {
        this(s, true);
    }

    public SetMetrics(boolean identityHashes) {
        this(Collections.EMPTY_SET, identityHashes);
    }

    public SetMetrics(Collection s, boolean identityHashes) {
        this.d_identityHashes = identityHashes;
        for (Object o : s) {
            this.add(o);
        }
    }

    protected <T> Set<T> newSet() {
        return this.d_identityHashes ? new LinkedIdentityHashSet() : new LinkedHashSet();
    }

    public boolean add(Object obj) {
        return this.addEntry(obj.getClass(), obj);
    }

    public boolean contains(Object obj) {
        Set<Object> vals = this.d_hash.get(obj.getClass());
        if (vals != null) {
            return vals.contains(obj);
        }
        return false;
    }

    public boolean remove(Object obj) {
        return this.removeEntry(obj.getClass(), obj);
    }

    public void clear() {
        this.d_hash.clear();
    }

    private boolean removeEntry(Class clazz, Object obj) {
        Set<Object> vals = this.d_hash.get(clazz);
        if (vals == null) {
            return false;
        }
        boolean removed = vals.remove(obj);
        if (vals.isEmpty()) {
            this.d_hash.remove(clazz);
        }
        return removed;
    }

    private boolean addEntry(Class clazz, Object obj) {
        Set<Object> objs = this.d_hash.get(clazz);
        if (objs == null) {
            objs = this.newSet();
            this.d_hash.put(clazz, objs);
        }
        return objs.add(obj);
    }

    public <T> Set<T> filter(Class<? extends T> ... clazzes) {
        return this.filter(new DefFilter<T>(clazzes));
    }

    public <T> Set<T> filter(IFilter<T> c) {
        Set<T> found = this.newSet();
        for (Map.Entry<Class, Set<Object>> entry : this.d_hash.entrySet()) {
            for (Class<T> clazz : c.getClazzes()) {
                if (!clazz.isAssignableFrom(entry.getKey())) continue;
                for (Object o : entry.getValue()) {
                    T obj = clazz.cast(o);
                    if (!c.objectPasses(obj)) continue;
                    found.add(obj);
                }
            }
        }
        return found;
    }

    public <T> boolean isEmpty(IFilter<T> c) {
        for (Map.Entry<Class, Set<Object>> entry : this.d_hash.entrySet()) {
            for (Class<T> clazz : c.getClazzes()) {
                if (!clazz.isAssignableFrom(entry.getKey())) continue;
                for (Object o : entry.getValue()) {
                    if (!c.objectPasses(clazz.cast(o))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public <T> int count(IFilter<T> c) {
        int count = 0;
        for (Map.Entry<Class, Set<Object>> entry : this.d_hash.entrySet()) {
            for (Class<T> clazz : c.getClazzes()) {
                if (!clazz.isAssignableFrom(entry.getKey())) continue;
                for (Object o : entry.getValue()) {
                    if (!c.objectPasses(clazz.cast(o))) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public int getNum(Class ... clazzes) {
        return this.count(new DefFilter(clazzes));
    }

    public boolean isEmpty() {
        for (Set<Object> set : this.d_hash.values()) {
            if (set.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isExclusiveSingle(Class clazz) {
        return this.isExclusive(clazz) && this.getNum(clazz) == 1;
    }

    public <T> boolean containsAny(Class<T> type, Predicate<? super T> test) {
        for (Map.Entry<Class, Set<Object>> entry : this.d_hash.entrySet()) {
            if (!type.isAssignableFrom(entry.getKey()) || !entry.getValue().stream().map(o -> type.cast(o)).filter(test).findAny().isPresent()) continue;
            return true;
        }
        return false;
    }

    public <T> boolean isExclusive(Class<T> type, Predicate<? super T> test) {
        return this.isExclusive(type, Predicates.alwaysTrue(), test);
    }

    public boolean isExclusive(Class ... clazzes) {
        Predicate cfilter = c -> {
            for (Class clazz : clazzes) {
                if (!clazz.isAssignableFrom((Class<?>)c)) continue;
                return true;
            }
            return false;
        };
        return this.isExclusive(Object.class, cfilter, Predicates.alwaysTrue());
    }

    public <T> boolean isExclusive(Class<T> type, Predicate<Class<? extends T>> typeFilter, Predicate<? super T> test) {
        boolean isPresent = false;
        for (Map.Entry<Class, Set<Object>> entry : this.d_hash.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            Class entryType = entry.getKey();
            if (!type.isAssignableFrom(entryType) || !typeFilter.test(entryType)) {
                return false;
            }
            if (!entry.getValue().stream().map(o -> type.cast(o)).allMatch(test)) {
                return false;
            }
            isPresent = true;
        }
        return isPresent;
    }

    public Collection<?> flatten() {
        return theUtil.flatMap(this.d_hash.values(), so -> so);
    }

    public SetMetrics clone() {
        try {
            SetMetrics copy = (SetMetrics)super.clone();
            for (Map.Entry<Class, Set<Object>> kvPair : this.d_hash.entrySet()) {
                for (Object o : kvPair.getValue()) {
                    copy.add(o);
                }
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        return String.format("SetMetrics[d_identityHashes=%s,d_hash=%s]", this.d_identityHashes, this.d_hash.toString());
    }

    public static final class DefFilter<T>
    extends AFilter<T> {
        public DefFilter(Class<? extends T> ... clazzes) {
            super(clazzes);
        }

        @Override
        public final boolean objectPasses(T obj) {
            return true;
        }

        @Override
        public boolean reset() {
            return false;
        }
    }

    public static abstract class AFilter<T>
    implements IFilter<T> {
        private final Class<? extends T>[] d_clazzes;

        public AFilter(Class<? extends T> ... clazzes) {
            this.d_clazzes = clazzes;
        }

        @Override
        public Class<? extends T>[] getClazzes() {
            return this.d_clazzes;
        }
    }

    public static interface IFilter<T> {
        public boolean objectPasses(T var1);

        public Class<? extends T>[] getClazzes();

        public boolean reset();
    }
}

