/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util.Queue;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import thunderheadeng.util.Queue.FixEnumImpl;
import thunderheadeng.util.Queue.QNodeImpl;
import thunderheadeng.util.Queue.Queue;

public class QImpl
implements Queue {
    protected int num_elem = 0;
    protected QNodeImpl head_node;
    protected QNodeImpl tail_node;
    private int max_size;

    public QImpl() {
        this(Integer.MAX_VALUE);
    }

    public QImpl(int maxSize) {
        this.max_size = maxSize;
        this.head_node = null;
        this.tail_node = null;
    }

    public void setMaxSize(int maxSize) {
        this.max_size = maxSize;
    }

    public int getMaxSize() {
        return this.max_size;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("----" + this.num_elem + " elements in Queue-----\n");
        System.out.println("----" + this.num_elem + " elements in Queue-----\n");
        Enumeration e = this.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            buf.append(i++ + ": " + e.nextElement() + "\n");
        }
        buf.append("--------End of Queue-------\n");
        return buf.toString();
    }

    @Override
    public synchronized Object lastElement() throws NoSuchElementException {
        if (this.tail_node == null) {
            throw new NoSuchElementException();
        }
        return this.tail_node.elem;
    }

    @Override
    public synchronized Object firstElement() throws NoSuchElementException {
        if (this.head_node == null) {
            throw new NoSuchElementException();
        }
        return this.head_node.elem;
    }

    @Override
    public synchronized void insertFirst(Object elem) {
        if (this.head_node == null) {
            this.head_node = this.tail_node = new QNodeImpl(elem);
        } else {
            QNodeImpl temp;
            this.head_node.prev = temp = new QNodeImpl(elem, null, this.head_node);
            this.head_node = temp;
        }
        ++this.num_elem;
        while (this.num_elem > this.max_size) {
            this.removeLast();
        }
    }

    @Override
    public synchronized void insertLast(Object elem) {
        if (this.head_node == null) {
            this.head_node = this.tail_node = new QNodeImpl(elem);
        } else {
            QNodeImpl temp;
            this.tail_node.next = temp = new QNodeImpl(elem, this.tail_node, null);
            this.tail_node = temp;
        }
        ++this.num_elem;
        while (this.num_elem > this.max_size) {
            this.removeFirst();
        }
    }

    @Override
    public synchronized Object removeFirst() throws NoSuchElementException {
        if (this.head_node == null) {
            throw new NoSuchElementException();
        }
        Object result = this.head_node.elem;
        --this.num_elem;
        if (this.head_node == this.tail_node) {
            this.tail_node = null;
            this.head_node = null;
        } else {
            QNodeImpl newhead = this.head_node.next;
            newhead.prev = null;
            this.head_node = newhead;
        }
        return result;
    }

    @Override
    public synchronized Object removeLast() throws NoSuchElementException {
        if (this.head_node == null) {
            throw new NoSuchElementException();
        }
        Object result = this.tail_node.elem;
        --this.num_elem;
        if (this.head_node == this.tail_node) {
            this.tail_node = null;
            this.head_node = null;
        } else {
            QNodeImpl newtail = this.tail_node.prev;
            newtail.next = null;
            this.tail_node = newtail;
        }
        return result;
    }

    @Override
    public synchronized int size() {
        return this.num_elem;
    }

    @Override
    public synchronized Enumeration elements() {
        int len = this.num_elem;
        FixEnumImpl the_enum = new FixEnumImpl(len);
        QNodeImpl cur_node = this.head_node;
        for (int indx = 0; indx < len; ++indx) {
            the_enum.addMember(cur_node.elem);
            cur_node = cur_node.next;
        }
        return the_enum;
    }

    @Override
    public void clear() {
        this.num_elem = 0;
        this.head_node = null;
        this.tail_node = null;
    }

    @Override
    public synchronized Object clone() {
        QImpl result = new QImpl();
        int len = this.num_elem;
        QNodeImpl cur_node = this.head_node;
        for (int indx = 0; indx < len; ++indx) {
            result.insertLast(cur_node.elem);
            cur_node = cur_node.next;
        }
        return result;
    }
}

