/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import thunderheadeng.util.APredicate;
import thunderheadeng.util.theUtil;

public class Predicates {
    public static final <T> Predicate<T> alwaysTrue() {
        return AlwaysTrue.INSTANCE;
    }

    public static final <T> Predicate<T> alwaysFalse() {
        return AlwaysFalse.INSTANCE;
    }

    public static final <T> boolean alwaysTrue(Predicate<T> pred) {
        return pred == Predicates.alwaysTrue();
    }

    public static final <T> boolean alwaysFalse(Predicate<T> pred) {
        return pred == Predicates.alwaysFalse();
    }

    public static final <T> Predicate<T> always(boolean answer) {
        if (answer) {
            return Predicates.alwaysTrue();
        }
        return Predicates.alwaysFalse();
    }

    public static final <T> Predicate<T> or(Predicate<T> p1, Predicate<? super T> p2) {
        if (p2 == Predicates.alwaysTrue()) {
            return Predicates.alwaysTrue();
        }
        if (p2 == Predicates.alwaysFalse()) {
            return p1;
        }
        return p1.or(p2);
    }

    public static final <T> Predicate<T> or(Predicate<T> ... tests) {
        if (tests.length == 1) {
            return tests[0];
        }
        if (tests.length == 2) {
            return Predicates.or(tests[0], tests[1]);
        }
        return new MultiOr<T>(tests);
    }

    public static final <T> Predicate<T> and(Predicate<T> p1, Predicate<? super T> p2) {
        if (p2 == Predicates.alwaysTrue()) {
            return p1;
        }
        if (p2 == Predicates.alwaysFalse()) {
            return Predicates.alwaysFalse();
        }
        return p1.and(p2);
    }

    public static final <T> Predicate<T> and(Predicate<T> ... tests) {
        if (tests.length == 1) {
            return tests[0];
        }
        if (tests.length == 2) {
            return Predicates.and(tests[0], tests[1]);
        }
        return new MultiAnd<T>(tests);
    }

    public static <T> Predicate<T> combine(Predicate<T> f1, Predicate<T> f2) {
        return Predicates.and(f1, f2);
    }

    protected static <T> boolean setsEqual(T[] set1, T[] set2) {
        if (set1.length != set2.length) {
            return false;
        }
        for (T obj1 : set1) {
            if (Predicates.contains(set2, obj1)) continue;
            return false;
        }
        return true;
    }

    protected static <T> boolean contains(T[] set, T obj) {
        for (T obj1 : set) {
            if (!theUtil.equal(obj1, obj)) continue;
            return true;
        }
        return false;
    }

    public static <T> Predicate<T> cache(Predicate<T> filter) {
        if (Predicates.alwaysTrue(filter) || Predicates.alwaysFalse(filter)) {
            return filter;
        }
        return new CachedFilter<T>(filter);
    }

    public static <T> Predicate<T> parallelCache(Predicate<T> filter) {
        if (Predicates.alwaysTrue(filter) || Predicates.alwaysFalse(filter)) {
            return filter;
        }
        return new ParallelCachedFilter<T>(filter);
    }

    public static class ParallelCachedFilter<T>
    extends APredicate<T> {
        static final long serialVersionUID = 1L;
        private final Map<T, Boolean> d_filterCache;
        private final Predicate<T> d_baseFilter;

        protected ParallelCachedFilter(Predicate<T> baseFilter) {
            this.d_baseFilter = baseFilter;
            this.d_filterCache = Collections.synchronizedMap(new HashMap());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean test(T o) {
            Map<T, Boolean> map = this.d_filterCache;
            synchronized (map) {
                Boolean test = this.d_filterCache.get(o);
                if (test == null) {
                    test = this.d_baseFilter.test(o);
                    this.d_filterCache.put(o, test);
                }
                return test;
            }
        }

        public boolean equals(Object obj) {
            return obj instanceof ParallelCachedFilter && ((ParallelCachedFilter)obj).d_baseFilter.equals(this.d_baseFilter);
        }

        public int hashCode() {
            return 0x239F8EAE ^ this.d_baseFilter.hashCode();
        }
    }

    public static class CachedFilter<T>
    extends APredicate<T> {
        static final long serialVersionUID = 1L;
        private final Map<T, Boolean> d_filterCache;
        private final Predicate<T> d_baseFilter;

        protected CachedFilter(Predicate<T> baseFilter) {
            this.d_baseFilter = baseFilter;
            this.d_filterCache = new HashMap<T, Boolean>();
        }

        @Override
        public boolean test(T o) {
            Boolean test = this.d_filterCache.get(o);
            if (test == null) {
                test = this.d_baseFilter.test(o);
                this.d_filterCache.put(o, test);
            }
            return test;
        }

        public boolean equals(Object obj) {
            return obj instanceof CachedFilter && ((CachedFilter)obj).d_baseFilter.equals(this.d_baseFilter);
        }

        public int hashCode() {
            return 0x15623 ^ this.d_baseFilter.hashCode();
        }
    }

    public static final class Negate<T>
    extends APredicate<T> {
        static final long serialVersionUID = 1L;
        public final Predicate<T> pred;

        public Negate(Predicate<T> pred) {
            this.pred = pred;
        }

        @Override
        public boolean test(T t) {
            return !this.pred.test(t);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Negate && ((Negate)obj).pred.equals(this.pred);
        }

        public int hashCode() {
            return 0x234FE832 ^ this.pred.hashCode();
        }

        @Override
        public Predicate<T> negate() {
            return this.pred;
        }
    }

    public static class MultiOr<T>
    extends APredicate<T>
    implements Serializable {
        static final long serialVersionUID = 1L;
        public Predicate<T>[] filters;

        public MultiOr(Predicate<T> ... filters) {
            this.filters = filters;
        }

        public int hashCode() {
            int hash = 0;
            for (Predicate<T> filter : this.filters) {
                hash += filter.hashCode();
            }
            return hash ^= 0x3498FE82;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof MultiOr && Predicates.setsEqual(((MultiOr)obj).filters, this.filters);
        }

        @Override
        public boolean test(T t) {
            for (Predicate<T> filter : this.filters) {
                if (!filter.test(t)) continue;
                return true;
            }
            return false;
        }
    }

    public static final class Or<T>
    extends APredicate<T> {
        static final long serialVersionUID = 1L;
        public final Predicate<T> pred1;
        public final Predicate<? super T> pred2;

        public Or(Predicate<T> pred1, Predicate<? super T> pred2) {
            this.pred1 = pred1;
            this.pred2 = pred2;
        }

        @Override
        public boolean test(T t) {
            return this.pred1.test(t) || this.pred2.test(t);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof Or && (((Or)obj).pred1.equals(this.pred1) && ((Or)obj).pred2.equals(this.pred2) || ((Or)obj).pred1.equals(this.pred2) && ((Or)obj).pred2.equals(this.pred1));
        }

        public int hashCode() {
            return 0xF328FDA3 ^ this.pred1.hashCode() + this.pred2.hashCode();
        }
    }

    public static class MultiAnd<T>
    extends APredicate<T>
    implements Serializable {
        static final long serialVersionUID = 1L;
        public Predicate<T>[] filters;

        public MultiAnd(Predicate<T> ... filters) {
            this.filters = filters;
        }

        public int hashCode() {
            int hash = 0;
            for (Predicate<T> filter : this.filters) {
                hash += filter.hashCode();
            }
            return hash ^= 0xF398FDE1;
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof MultiAnd && Predicates.setsEqual(((MultiAnd)obj).filters, this.filters);
        }

        @Override
        public boolean test(T t) {
            for (Predicate<T> filter : this.filters) {
                if (filter.test(t)) continue;
                return false;
            }
            return true;
        }
    }

    public static final class And<T>
    extends APredicate<T> {
        static final long serialVersionUID = 1L;
        public final Predicate<T> pred1;
        public final Predicate<? super T> pred2;

        public And(Predicate<T> pred1, Predicate<? super T> pred2) {
            this.pred1 = pred1;
            this.pred2 = pred2;
        }

        @Override
        public boolean test(T t) {
            return this.pred1.test(t) && this.pred2.test(t);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof And && (((And)obj).pred1.equals(this.pred1) && ((And)obj).pred2.equals(this.pred2) || ((And)obj).pred1.equals(this.pred2) && ((And)obj).pred2.equals(this.pred1));
        }

        public int hashCode() {
            return 0x2398FA32 ^ this.pred1.hashCode() + this.pred2.hashCode();
        }
    }

    private static final class AlwaysFalse<T>
    implements Predicate<T>,
    Serializable {
        static final long serialVersionUID = 1L;
        public static final AlwaysFalse INSTANCE = new AlwaysFalse();

        private AlwaysFalse() {
        }

        @Override
        public final boolean test(T t) {
            return false;
        }

        public boolean shouldFilter(T o) {
            return true;
        }

        @Override
        public final Predicate<T> or(Predicate<? super T> other) {
            return other;
        }

        @Override
        public final Predicate<T> and(Predicate<? super T> other) {
            return this;
        }

        @Override
        public final Predicate<T> negate() {
            return AlwaysTrue.INSTANCE;
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    private static final class AlwaysTrue<T>
    implements Predicate<T>,
    Serializable {
        static final long serialVersionUID = 1L;
        public static final AlwaysTrue INSTANCE = new AlwaysTrue();

        private AlwaysTrue() {
        }

        @Override
        public final boolean test(T t) {
            return true;
        }

        public boolean shouldFilter(T o) {
            return false;
        }

        @Override
        public final Predicate<T> or(Predicate<? super T> other) {
            return this;
        }

        @Override
        public final Predicate<T> and(Predicate<? super T> other) {
            return other;
        }

        @Override
        public final Predicate<T> negate() {
            return AlwaysFalse.INSTANCE;
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }
}

