/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import thunderheadeng.Intl;
import thunderheadeng.io.UrlDataLoader;

public class OnlineLicenseReq {
    public static Response getAuth(String regKey, String hostid, String eth0) throws IOException, ParserConfigurationException, SAXException {
        String strUrl = String.format("https://www.thunderheadeng.com/auth.php?hostid=%s&key=%s&eth0=%s", hostid, regKey, eth0);
        URL url = new URL(strUrl);
        UrlDataLoader urlLoader = new UrlDataLoader(url, UrlDataLoader.BLIND_HOSTNAME_VERIFIER, UrlDataLoader.BLIND_TRUST_MANAGER);
        URLConnection conn = urlLoader.connect();
        int httpCode = UrlDataLoader.getResponseCode(conn);
        Response resp = new Response();
        if (httpCode == 200) {
            String contentXml = urlLoader.read(conn);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document xmldoc = db.parse(new InputSource(new StringReader(contentXml)));
            Node licNode = xmldoc.getElementsByTagName("license").item(0);
            resp.err = Integer.parseInt(licNode.getAttributes().item(0).getTextContent());
            resp.license = licNode.getTextContent().trim();
        } else {
            resp.err = httpCode;
            resp.license = null;
        }
        return resp;
    }

    public static class Response {
        public int err;
        public String license;

        public boolean isError() {
            return this.err != 0;
        }

        public String getLicenseString() {
            return this.license;
        }

        public String getErrorString() {
            switch (this.err) {
                case -10: {
                    return String.format(Intl.intl("[%d] Connection timed out"), this.err);
                }
                case -1: {
                    return String.format("[%d] %s", this.err, this.license);
                }
                case 0: {
                    return String.format(Intl.intl("[%d] Success"), this.err);
                }
                case 1: {
                    return String.format(Intl.intl("[%d] Registration key not found."), this.err);
                }
                case 10: {
                    return String.format(Intl.intl("[%d] This key has been issued to another host."), this.err);
                }
                case 11: {
                    return String.format(Intl.intl("[%d] Database Error - Unable to add \"issued\" record."), this.err);
                }
                case 12: {
                    return String.format(Intl.intl("[%d] Floating license must be installed manually."), this.err);
                }
            }
            return String.format(Intl.intl("[%d] Unknown Error"), this.err);
        }
    }
}

