/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;

public class ObservableProxy
implements IObservable {
    private final IObservable d_owner;
    private boolean d_changed;
    private int d_pauseCounter;
    private List<Object> d_observers;
    private Set<Object> d_events;

    public ObservableProxy(IObservable owner) {
        this.d_owner = owner;
        this.d_pauseCounter = 0;
        this.d_changed = false;
        this.d_observers = null;
        this.d_events = Collections.emptySet();
    }

    @Override
    public synchronized void addObserver(IObserver observer, boolean weakRef) {
        Object ref;
        Object object = ref = weakRef ? new WeakReference<IObserver>(observer) : observer;
        if (this.d_observers == null) {
            this.d_observers = new ArrayList<Object>(5);
        }
        this.d_observers.add(ref);
    }

    @Override
    public synchronized void deleteObserver(IObserver o) {
        if (this.d_observers != null) {
            Iterator<Object> it = this.d_observers.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (next instanceof WeakReference) {
                    WeakReference ref = (WeakReference)next;
                    Object refobj = ref.get();
                    if (refobj != null && refobj != o) continue;
                    it.remove();
                    break;
                }
                if (next != o) continue;
                it.remove();
                break;
            }
            if (this.d_observers.isEmpty()) {
                this.d_observers = null;
            }
        }
    }

    public synchronized int countObservers() {
        return this.d_observers.size();
    }

    private synchronized void fireNotification(Set<Object> events) {
        Object[] observers;
        if (this.d_observers == null) {
            return;
        }
        for (Object obj : observers = this.d_observers.toArray(new Object[this.d_observers.size()])) {
            IObserver observer;
            if (obj instanceof WeakReference) {
                WeakReference ref = (WeakReference)obj;
                IObserver obs = (IObserver)ref.get();
                if (obs == null) continue;
                observer = obs;
            } else {
                observer = (IObserver)obj;
            }
            if (events.isEmpty()) {
                observer.update(this.d_owner, null);
                continue;
            }
            for (Object arg : events) {
                observer.update(this.d_owner, arg);
            }
        }
    }

    public void pause() {
        ++this.d_pauseCounter;
    }

    public boolean resume() {
        --this.d_pauseCounter;
        assert (this.d_pauseCounter >= 0);
        return this.tryFireNotification(null);
    }

    protected boolean tryFireNotification() {
        return this.tryFireNotification(null);
    }

    protected boolean tryFireNotification(Object event) {
        if (this.d_events.isEmpty()) {
            this.d_events = Collections.singleton(event);
        } else if (this.d_events.size() > 1 || !Objects.equals(event, this.d_events.iterator().next())) {
            if (this.d_events.size() == 1) {
                this.d_events = new LinkedHashSet<Object>(this.d_events);
            }
            this.d_events.add(event);
        }
        if (this.d_pauseCounter == 0 && this.d_changed) {
            this.fireNotification(this.d_events);
            this.d_changed = false;
            this.d_events = Collections.emptySet();
            return true;
        }
        return false;
    }

    public void setChanged(boolean changed) {
        this.d_changed = changed;
        this.tryFireNotification();
    }

    public void modified(Object event) {
        this.d_changed = true;
        this.tryFireNotification(event);
    }
}

